/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:ffont.h 12.0$ */
/* $ACIS:ffont.h 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/ditroff/dit3812/RCS/ffont.h,v $ */

#if !defined(lint) && !defined(LOCORE)  && defined(RCS_HDRS)
static char *rcsidffont = "$Header:ffont.h 12.0$";
#endif


typedef struct FFS {
		      int		 ffs_size;
		      pmp_font		*ffs_font;
		      struct FFS	*ffs_next;
		   } ffsize;

typedef struct FF {
		    char         *ff_name;
		    char	 *ff_cpage;
		    ffsize       *ff_sizes;
		    struct FF    *ff_next;   /* For free list */
		  } f_font;



   /*\
   |* Maintains information about formatter fonts.  
   |* By convention, the font associated at size 0 (if
   |* defined) is a rule of the form accepted by gn_Name (see gen_name.h) that
   |* may be expanded to determine the name of the printer font associated
   |* with any size.
   |*
   |* PROVIDES:
   |*   ff_Add(name,size,a_font) -- Adds (or replaces) the font named
   |*   char *name;                 'name' at 'size', associated with
   |*   int   size;		    'a_font'.  If 'name' at 'size' is already
   |*	char *a_font;		    defined, the old definition is
   |*				    superceded, and the font formerly
   |*   associated with it is returned.
   |*
   |*   ff_FAdd(font,size,a_font) -- Associates 'a_font' with 'font' at 'size'
   |*   f_font *font;		    If an associated printer font is already
   |*   int     size;		    defined, the old definition is overidden
   |*   char   *a_font;		    and returned.
   |*
   |*   ff_Info(name)            -- Returns a pointer to the structure
   |*   char *name;		    describing the font named 'name', or
   |*                               NULL if no font 'name' has been
   |*                               defined. (returns (f_font *))
   |*
   |*   ff_Name(ffont)           -- Returns name of font described by
   |*   f_font *ffont;		    'ffont'
   |*
   |*   ff_Codepage(ffont)	 -- Returns name of the codepage associated
   |*	f_font *ffont; 		    with ffont.
   |*
   |*   ff_SetCodepage(ffont,cp) -- Specifies that codepage named 'cp' is to
   |*	f_font *ffont; 		    be used for ffont.
   |*
   |*   ff_Pfont(ffont,size)     -- Returns the name of the printer font
   |*   f_font *ffont;              associated with 'ffont' at size
   |*   int     size;               'size'   (returns (char *))
   |*
   |*   ff_Squeeze(ffont,size,real_size) --
   |*   f_font *ffont;              Returns the name of the printer font
   |*   int     size;               associated with 'ffont' at 'size', or,
   |*   int    *real_size;          if no corresponding font exists, returns
   |*   			    the printer that fits best. (usually the
   |*	next smallest defined size.  Sets contents of real_size (int *) to
   |*   the actual size selected.  If no corresponding font can be found,
   |*   returns NULL and sets real_size to 0.
   |*
   |*   NOTES:
   |*      May also want to provide (eventually) functions that return
   |*      a list of legal fonts, of legal sizes for a given font, etc.
   \*/



#define FNT_UNDEFINED -1
#define FNT_UNMOUNTED -2
#define FNT_ERROR     -3

int ff_debug;

extern pmp_font	*ff_Add();
extern pmp_font	*ff_FAdd();
extern f_font	*ff_Info();
#define		 ff_Name(f)		(f->ff_name)
#define		 ff_Codepage(f)		(f->ff_cpage)
#define		 ff_SetCodepage(f,c)	(f->ff_cpage=(c))
extern pmp_font	*ff_PFont();
extern pmp_font	*ff_Squeeze();
extern int	 ff_Print();
