/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:raster.h 12.0$ */
/* $ACIS:raster.h 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/fdb_ca/h/RCS/raster.h,v $ */

#if !defined(lint) && !defined(LOCORE)  && defined(RCS_HDRS)
static char *rcsidraster = "$Header:raster.h 12.0$";
#endif

/*
 * raster.h: include file for the raster type
 */

#ifndef _RASTER
#define _RASTER

typedef struct {
    int w;			/* current width of the raster */
    int maxw;		/* maximum width of the raster */
    int roww;		/* the width in bytes of a row */
    int h;			/* current heigth of the raster */
    int maxh;		/* maximum heigth of the raster */
    unsigned char *r;			/* the raster, note that the bits of the
				   raster are stored row after row with
				   each row filled out to the number of
				   bytes that hold maxw of bits */
} raster_type;

void raster_setup ();
void raster_clear ();
void raster_initialize ();
void raster_set_pel ();
void raster_clear_pel ();
boolean raster_test_pel ();
void raster_print ();
void raster_copy ();

#endif	_RASTER
