/*
 * 5799-CGZ (C) COPYRIGHT IBM CORPORATION 1986,1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: build3812.c,v 12.0 88/11/11 12:37:23 root dec88 $ */
/* $Source: /ibm/acis/usr/src/ibm/fdb_ca/src/RCS/build3812.c,v $ */

#ifndef lint
static char *rcsid = "$Header: build3812.c,v 12.0 88/11/11 12:37:23 root dec88 $";
#endif

/*
 *  procedure to build the 3812 format.
 */ 

/*-------------------include project and standard type defs*/
#include "itc.h"
#include "stddefs.h"
/*------------------include appropriate header files*/
#include <stdio.h>
#include <ctype.h>
#include "palloc.h"
#include "symtab.h"
#include "raster.h"
#include "sys/file.h"
/*-------------------include ibm font processing definitions*/
#include "ibmfonts.h"
#include "font3812.h"
/*--------Font type definitions*/
#include "fonts.h"

/*-----------------------include wm font definitions*/
#include "wmFontTools.h"

/*--------------------------Global data objects-----------------------------*/
byte *pool;			/* the palloc pool used in this module */

/*---------------------------code page file*/
#define DefaultCodePoint "SV320000"

#define MAXFONTNAMES 100
char *IntName[MAXFONTNAMES][20];
char *IBMName[MAXFONTNAMES][50];

static int offset;
static int fp,fpi;
extern errno;
/*
 * compress 3800 font data to remove the extra bits.
 */
void  
charCompress(ibmfd,ibmc,f_out)
 ibm_fd_type *ibmfd;
struct ibm_cdata *ibmc;
  ibm_fdata f_out;
{
}
/*
 * convert ibm font data character into the 3812 character format.
 */
void  
build3812_char(ibmfd,ibmc,Makenames,DoDebug)
 ibm_fd_type *ibmfd;
struct ibm_cdata *ibmc;
int Makenames;
int DoDebug;

{
    ibm_fdata f_out;
    int i, j, emsg, n;
    char *p, *data;
    char c, pchar;
    index_data key;
#ifndef ibm3820
    natural newLeft, newRight, newTop, newBottom;
    raster_type rtemp, ntemp;
    int newx, newy;
#endif


    f_out.c_data.x = ibmc->fni_box_size_x;
    f_out.c_data.y = ibmc->fni_box_size_y;
    f_out.c_data.a_space = ibmc-> fni_a_space;
    f_out.c_data.c_space = ibmc->fni_c_space;
#ifdef ibm3820
    f_out.c_data.offset  = ibmc->fni_ascender;
    f_out.r_data = (char *)(ibmfd->fng_patterns + ibmc->fni_pattern_offset);
#else 
    f_out.c_data.offset  = ibmfd->fno_uniform_baseline_offset;

    /* setup the raster */
    /* first initialize a tempory raster_type */
    raster_initialize (&rtemp, f_out.c_data.x, f_out.c_data.x,
	f_out.c_data.y, f_out.c_data.y, 
	ibmfd->fng_patterns+ibmc->fni_pattern_offset);
    /* find the size of the data in the raster pattern and compress */
    raster_find_left_right (&rtemp,&newLeft,&newRight);
    raster_find_top_bottom (&rtemp,&newTop,&newBottom);
    newx = (newRight-newLeft)+1;
    newy = (newBottom-newTop)+1;
    raster_initialize (&ntemp, newx, newx, newy, newy,NULL);
    raster_compress(&rtemp,&ntemp,newTop,newBottom,newLeft,newRight);
    /* calculate the new offset and x,y of the new raster */
    f_out.c_data.offset -= newTop; 
    f_out.c_data.x = newx;
    f_out.c_data.y = newy;
    f_out.r_data =(char *)ntemp.r;
#endif
      n = ( (f_out.c_data.x + 7 )/8) * f_out.c_data.y;
      if (Makenames) {
      printf("raster for x  xx %*s\n",8,ibmc->fni_id);
      }
      if (DoDebug) {
	printf("raster for x  xx %*s\n",8,ibmc->fni_id);
	printf("x,y: %d,%d\n",f_out.c_data.x,f_out.c_data.y);
	printf("a,c,offset: %d,%d,%d\n",f_out.c_data.a_space,
			    f_out.c_data.c_space,f_out.c_data.offset);
	p = f_out.r_data;
	for (j=0;j<f_out.c_data.y;j++){
	    for (i=0;i<f_out.c_data.x; i++){
		if ((i % 8) == 0) {
		    if (i != 0) p++;
		    c = *p;
		}
		pchar = (c & 0200) ? '@' : '-';
		putchar(pchar);
		c = c << 1;
	    }
	    p++;
	    printf("\n");
	}
	printf("\n");
      }
      strncpy( key.name , ibmc->fni_id,8);
      key.offset =offset;
      key.length =CharInfoLen + n;
            /* write the font data */
      data = (char *)&f_out;
      if (emsg = (write (fp,data,CharInfoLen)) != CharInfoLen ) {
         fprintf(stderr,"error writing fixed data, key:%s emsg:%d errno:%d,fp:%d\n",ibmc->fni_id,emsg,errno,fp);
      }     
      if (emsg = (write (fp,f_out.r_data,n)) != n) {
         fprintf(stderr,"error writing bit pattern, key:%s emsg:%d errno:%d,fp:%d\n",ibmc->fni_id,emsg,errno,fp);
      }
      /* write the index data */
      write (fpi,&key ,IndexDataLen);
      offset = offset + key.length;
#ifdef ibm3820
#else 
      raster_free(&ntemp);
#endif
}
/*
 * procedure build3812: convert ibm font data into the 3812 format
 */  
int 
build3812(ibm, wm, fontnameTbl,Makedefault,Makenames,DoDebug)
ibm_fd_type *ibm;
wmFontType *wm;
string fontnameTbl;
int Makedefault;
int Makenames;
int DoDebug;
{
    string family;
    string typeface;
    string weight;
    string ptsize;
    string separator;
    char filenamePag[100];
    char filenameDir[100];
    natural iptsize;
    natural i;
    struct ibm_cdata *ibm_char;
    FILE *fnf;    /* font name file */
    char *t1;
    char *t2;
    char *idname;
    int  font_cnt;
    char *names[2];

    /* Read in the list of font names and internal font names */
    /* This data is stored in a file called fontnameTBL       */
    /* The first name is the internal name, followed          */
    /* by the IBM name.                                       */
    if ((fnf = fopen(fontnameTbl,"r")) == NULL) {
       fprintf (stderr,"Can not find font name file:%s", fontnameTbl);
       exit(1);
    }
    for (i = 0; i < MAXFONTNAMES && getNames(fnf, names);) {
       if (names[0] == (char *)0)
       		continue;
       strcpy(IntName[i],names[0]);
       strcpy(IBMName[i++],names[1]);
    }
    if(i >= MAXFONTNAMES) {
    	fprintf(stderr,"To many font names!\n");
	exit(1);
    }
    font_cnt = i;     /* count of font names */
    close (fnf);
    for (i=0;i<font_cnt;i++){
    }
    /* construct font name form is family-point size-typeface */
    /* strip off trailing white space from ibm family name */
    for (t2=t1=ibm->fnd_family; *t1 != '\0'; t1++) {
	if (isalnum(*t1)) {
	    t2=t1;		/* find the last alpha numeric */
	}
    }
    *(++t2) = '\0';

    /* search the list of IBM font names and find a match      */
    family = (char *) 0;             /* if not found            */
    for ( i = 0;i<font_cnt;i++) {
        if (strcmp(IBMName[i],ibm->fnd_family) == 0){
            family =(char *) IntName[i];
            break;
        }
    }
    if (family == (char *) 0) {
	fprintf (stderr, "build3812: Unknown font family name -%s-\n",
	    ibm->fnd_family);
	fprintf (stderr, "    -unknown- will be used for the family name\n");
    }
    /*
    if (strcmp("SONORAN SANS SERIF", ibm->fnd_family) == 0) {
        family = "ibmss";
    } else if (strcmp("SONORAN SERIF", ibm->fnd_family) == 0) {
        family = "ibms";
    } else if (strcmp("PRESTIGE", ibm->fnd_family) == 0 ) {
        family = "ibmf";
    } else if (strcmp("PI SANS SERIF", ibm->fnd_family) == 0) {
	family = "ibmpss";
    } else if (strcmp("PI SERIF", ibm->fnd_family) == 0) {
	family = "ibmps";
    } else {
	family = "unknown";
    }
        */
    /* construct pt size in a string */
    ptsize = "  ";
    iptsize = ((ibm->fnd_vertical_size + 5)/10);
    if (iptsize < 10) {
	sprintf (ptsize, "%1d", iptsize);
    } else {
	sprintf (ptsize, "%2d", iptsize);
    }

    separator = "";
    /* figure out weight, '' for medium, 'b' for bold */
    wm->facecodes = 0;

    if (strcmp ("medium", ibm->fnd_weight_class) == 0) {
        weight = "";
    } else if (strcmp("light", ibm->fnd_weight_class) == 0) {
        weight = "L";
	separator = ".";
    } else if (strcmp("bold", ibm->fnd_weight_class) == 0) {
        weight = "B";
	separator = ".";
	wm->facecodes |= 01;
    } else {
        weight = "u";
	separator = ".";
        fprintf (stderr, "ibm2wm: Unknown weight class -%s-\n",
            ibm->fnd_weight_class);
        fprintf (stderr, "	-u- will be used\n");
    }

    /* figure out typeface- '' for roman, 'i' for italic */
    if (strcmp("roman", ibm->fnd_typeface) == 0) {
	typeface = "";
    } else if (strcmp("italic", ibm->fnd_typeface) == 0) {
	typeface = "I";
	separator = ".";
	wm->facecodes |= 02;
    } else {
	typeface = "x";
	separator = ".";
	fprintf (stderr, "ibm2wm: Unknown typeface -%s-\n",
	    ibm->fnd_typeface);
	fprintf (stderr, "	-x- will be used \n");
    }

    /* now constrct font name */
    wm->fontname = (string) malloc (strlen(family)+strlen(ptsize)+
        strlen(separator) +strlen(weight)+strlen(typeface)+1);
    sprintf (wm->fontname,"%s%s%s%s.%s", family,separator,weight,typeface,ptsize);
    /*
     * If the option was for Makedefault then only display the output font name.
     */
    if (Makedefault) {
	fprintf(stdout,"%s\n",wm->fontname);
	exit(0);
    }

    /* initialize the rest of the global info, except max value will not
       be set to real values */
    wm->familyname = family;
    wm->pointsize = iptsize; 
	
    wm->MaxNWtoOrigin.ns = 0;
    wm->MaxNWtoOrigin.we = 0;

    wm->MaxNtoS.ns = 0;
    wm->MaxNtoS.we = 0;

    wm->MaxWtoE.ns = 0;
    wm->MaxWtoE.we = 0;

    wm->MaxWbase.ns = 0;
    wm->MaxWbase.we = 0;

    wm->MaxNewline.ns = 0;
    wm->MaxNewline.we = 0;

    /* create the files for the dbm for building the font data base */
    sprintf (filenameDir, "%s.ndx",wm->fontname);
    sprintf (filenamePag, "%s.dat",wm->fontname);
    fpi = open (filenameDir,O_WRONLY +O_CREAT +O_TRUNC,0644);
    fp = open (filenamePag,O_WRONLY+O_CREAT +O_TRUNC,0644);
    offset = 0;
    /* initialize the output file for the font data */
    /* convert each character to wm format */
    while (symtab_scan_next(ibm->fni_c_index,&idname,&ibm_char) == 0) {
	    build3812_char (ibm, ibm_char,Makenames,DoDebug);
    }
    close(fp);
    close(fpi);
    if (weight == "b") {
       weight = "bold";
    }
    fprintf(stderr,"%s %s %s size %s converted to: %s\n",ibm-> fnd_family,weight,ibm->fnd_typeface,ptsize,wm->fontname);
    return(0);
}
