/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
#ifndef CH_SEEN
#define CH_SEEN 1
/* $Header:char.h 12.0$ */
/* $ACIS:char.h 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/lib/pmp/RCS/char.h,v $ */

#if !defined(lint) && !defined(LOCORE)  && defined(RCS_HDRS)
static char *rcsidchar = "$Header:char.h 12.0$";
#endif

	/*\
	|*	int	ch_fix(constraint)
	|*	int	ch_init(constraint)
	|*	CHAR	*ch_new(width,height,lt,rb,off,enc,sz,ptrn,ops)
	|*	CHAR	*ch_free(ch)
	|*	CHAR	*ch_pmpread(fil,encoding,size,index,ops)
	|*	CHAR	*ch_acisread(fil,encoding,size,ops)
	|*	int	ch_aciswrite(fil,ch)
	|*	int	ch_pmpwrite(fil,ch,index)
	|*	int	ch_width(ch)
	|*	int	ch_height(ch)
	|*	int	ch_LTspace(ch)
	|*	int	ch_RBspace(ch)
	|*	int	ch_totalwidth(ch)
	|*	int	ch_offset(ch)
	|*	int	ch_encoding(ch)
	|*	int	ch_sizepattern(ch)
	|*	char 	*ch_pattern(ch)
	|*
	|*	CHAR_ops	*ch_newops(info,read,free,ptrn,length)
	|*	CHAR_ops	*ch_getops(ch)
	|*	char	*ch_info(ch)
	|*	char	*ch_set_info(ch,info)
	|*	char	*ch_set_pattern(ch,p,e)
	|*	char	*ch_op_info(op);
	|*	char	*ch_op_set_info(op,info)
	\*/

typedef struct CV {
		char	  *ch_o_info;
		int	 (*ch_o_read)();
    		int	 (*ch_o_free)();
		char	*(*ch_o_ptrn)();
		u_int32	 (*ch_o_length)();
		} CHAR_ops;
		

typedef	struct CH {
		int16	 	ch_ht;
		int16	 	ch_wid;
		int16	 	ch_LT;
		int16	 	ch_RB;
		int16	 	ch_off;
		u_int16		ch_code;
		u_int32		ch_patlength;
		char		*ch_ptrn;
		CHAR_ops	*ch_ops;
		} CHAR;

/***===================================================================***/

extern int 	 ch_debug;
extern CHAR	*ch_error;

/***===================================================================***/

/* encodings */
#define CH_RASTER	0x0001

#define CH_LARGE_PTRN	0x0100
#define CH_FREE_PTRN	0x0200
#define CH_FREED	0x8000

#define CH_LARGE_CHAR_SIZE	16
#define CH_PMP_CHAR_SIZE	7

/***===================================================================***/

extern	int	 ch_fix();
extern	int	 ch_init();
extern	CHAR	*ch_new();
extern	CHAR	*ch_free();
extern	CHAR	*ch_pmpread();
extern	CHAR	*ch_acisread();
extern	int	 ch_pmpwrite();
extern	int	 ch_aciswrite();
extern	int	 ch_textwrite();
extern	int	 ch_sizepattern();
extern	char	*ch_pattern();

extern	CHAR_ops	*ch_newops();

#define ch_width(c)		((c)?(c)->ch_wid:ch_error->ch_wid)
#define ch_height(c)		((c)?(c)->ch_ht:ch_error->ch_ht)
#define ch_LTspace(c)		((c)?(c)->ch_LT:ch_error->ch_LT)
#define ch_RBspace(c)		((c)?(c)->ch_RB:ch_error->ch_RB)
#define ch_totalwidth(c)	((c)?(c)->ch_LT+(c)->ch_wid+(c)->ch_RB:\
			ch_error->ch_LT+ch_error->ch_wid+ch_error->ch_RB)
#define ch_offset(c)		((c)?(c)->ch_off:ch_error->ch_off)
#define ch_encoding(c)		((c)?(c)->ch_code:ch_error->ch_code)
#define ch_getops(c)		((c)?(c)->ch_ops:ch_error->ch_ops);
#define ch_op_info(o)		((o)?(o)->ch_o_info:NULL)
#define ch_op_set_info(o,i)	((o)?(o)->ch_o_info=(i):NULL)
#define ch_info(c)		((c)?ch_op_info((c)->ch_ops):NULL)
#define ch_set_info(c,i)	((c)?ch_op_setinfo((c)->ch_ops,i):NULL)
#define ch_set_pattern(c,p,e) ((c)?(c)->ch_code=(e),(c)->ch_ptrn=(p):NULL)

#endif /*CH_SEEN*/
