/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
#ifndef FNT_SEEN
#define FNT_SEEN 1
/* $Header:font.h 12.0$ */
/* $ACIS:font.h 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/lib/pmp/RCS/font.h,v $ */

#if !defined(lint) && !defined(LOCORE)  && defined(RCS_HDRS)
static char *rcsidfont = "$Header:font.h 12.0$";
#endif

	/*\
	|* int		  fnt_init(constraint)
	|* FONT		 *fnt_open(name,type)
	|* int		  fnt_close(font)
	|* int		  fnt_addch(font,ch,chr)
	|* CHAR		 *fnt_char(font,ch)
	|* char		**fnt_get_path()
	|* char		**fnt_set_path(dirs)
	|* int		  fnt_add_dir()
	|* char		 *fnt_loadinfo(f)
	|* char		 *fnt_setloadinfo(f,i)
	\*/


typedef	struct FNT {
			char		 *fnt_name;
			int		  fnt_format;
			u_int32		 *fnt_offsets;
			CHAR		**fnt_data;
			FILE		 *fnt_datfile;
			char		 *fnt_datname;
			char		 *fnt_offname;
			struct FNT	 *fnt_next;
			struct FNT	 *fnt_prev;
			char		 *fnt_ldinfo;
		    } FONT;

/***===================================================================***/


extern int fnt_debug;

/* FONT FORMATS */

#define FNT_ACIS	0x0001
#define FNT_PMP		0x0002
#define FNT_CLOSED	0x8000

/***===================================================================***/

extern	 int	  fnt_init();
extern   FONT	 *fnt_open();
extern   int	  fnt_close();
extern   int	  fnt_addch();		/* not implemented */
extern   CHAR	 *fnt_char();
extern   char	**fnt_get_path();
extern   char	**fnt_set_path();
extern   int	  fnt_add_dir();

#define fnt_loadinfo(f)		((f)?(f)->fnt_ldinfo:NULL)
#define fnt_setloadinfo(f,i)	((f)?(f)->fnt_ldinfo=(i):NULL)

#endif /* FNT_SEEN */
