/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
#ifndef P_SEEN
#define P_SEEN 1
/* $Header:printer.h 12.0$ */
/* $ACIS:printer.h 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/lib/pmp/RCS/printer.h,v $ */

#if !defined(lint) && !defined(LOCORE)  && defined(RCS_HDRS)
static char *rcsidprinter = "$Header:printer.h 12.0$";
#endif

	/*\
	|*	int	pr_open(outfil)
	|*	int	pr_close()
	|*	int	pr_get_copies()
	|*	int	pr_set_copies(copies)
	|*	int	pr_next_copies(copies)
	|*	int	pr_get_tray()
	|*	int	pr_set_tray(tray)
	|*	int	pr_next_tray(tray)
	|*	int	pr_eject(clear)
	|*	int	pr_clear()
	|*	int	pr_set_display(value)
	|*	int	pr_ring_bell()
	|*	int	pr_jog()
	|*	int	pr_rotate(orient)
	|*	int	pr_get_pgwidth()
	|*	int	pr_set_pgwidth(width)
	|*	int	pr_get_pgheight()
	|*	int	pr_set_pgheight(height)
	|*	int	pr_image(ht,wid,len,encoding,image)
	|*	int	pr_activate(font)
	\*/

extern int pr_debug;

extern int		pr_copies;
extern int		pr_tmpcopyknt;
extern int		pr_tray;
extern int		pr_traytmp;
#ifdef DEBUG_UTILS
extern u_debug_arg	pr_debug_args[];
#endif /* DEBUG_UTILS */

/***============================================================***/

#define P_NO_TRAY		RP_NO_TRAY
#define P_MAIN_TRAY		RP_MAIN_TRAY
#define P_ALTERNATE_TRAY	RP_ALTERNATE_TRAY

#define P_PORTRAIT		RP_PORTRAIT
#define P_LEFT_LANDSCAPE	RP_LEFT_LANDSCAPE
#define P_RIGHT_LANDSCAPE	RP_RIGHT_LANDSCAPE
#define P_INVERTED		RP_INVERTED

#define P_RASTER		CH_RASTER

/***============================================================***/

#define pr_set_debug(s)	u_SetDebug(s,1,pr_debug_args)

extern	int	pr_open();
#define pr_close()		(rp_close())
#define pr_get_copies()		(pr_copies)
#define pr_set_copies(n)	((n)>0?pr_copies=(n):FALSE)
#define pr_next_copies(n)	((n)>0?pr_tmpcopyknt=(n):FALSE)

#define pr_get_tray()		(pr_tray)
#define _pr_trayok(t)		((t)==P_MAIN_TRAY||(t)==P_ALTERNATE_TRAY)
#define pr_set_tray(t)		(_pr_trayok(t)?pr_tray=(t):P_NO_TRAY)
#define pr_next_tray(t)		(_pr_trayok(t)?pr_traytmp=(t):P_NO_TRAY)
extern	int	pr_eject();
#define pr_clear()		rp_clear()
extern	int	pr_setdisplay();
#define pr_ring_bell()		rp_ring()
#define pr_jog()		rp_jog()
#define pr_rotate(o)		(vp_rotate(o)?rp_rotate(o):FALSE)

#define pr_get_pgwidth()	(vp_pgwidth)
#define pr_get_pgheight()	(vp_pgheight)
extern	int	pr_set_pgwidth();
extern	int	pr_set_pgheight();

extern	int	pr_image();
#define pr_marked()	(vp_flush(VP_NONE),rp_state==RP_MARKED)
#define pr_activate(f)	(vp_active=(f))
#define pr_putchar(c)	(txt_putc(vp_active,c))
#define pr_putstring(s)	(txt_puts(vp_active,s))
#define pr_putnstring(s,n)	(txt_putnstr(vp_active,s,n))
#endif /* P_SEEN */
