/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:mTab.h 12.0$ */
/* $ACIS:mTab.h 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/rvd/client/RCS/mTab.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidmTab = "$Header:mTab.h 12.0$";
#endif

/*
 * $Header:mTab.h 12.0$
 * $ACIS:mTab.h 12.0$
 * $Author: root $
 * $Source: /ibm/acis/usr/src/ibm/rvd/client/RCS/mTab.h,v $
 */
#ifndef _MTAB_H_
#define _MTAB_H_

#define MTAB "/etc/mtab"

#include "common.h"

#include <fstab.h>
#include <mtab.h>
#include <sys/param.h>
#include <rpc/rpc.h>
#include <sys/errno.h>
#include <sys/time.h>
#include <sys/vfs.h>
#include <nfs/nfs.h>
#include <rpcsvc/mount.h>
#include <sys/mount.h>


typedef struct mtab mtab_t, *mtab_p;
#define ZMTAB ((mtab_t *)NULL)

typedef struct mtab_dev {
    dev_t m_major;
    dev_t m_minor;
} mdev_t, *mdev_p;

void mtab_debugOn();
void mtab_debugOff();
void mtab_sync();
void mtab_reset();

int mtab_init();
/* util$yankFile()
 */

int mtab_mount(/*spec,path,type*/);
/* mtab$init()
 * eperm - not super-user
 * enoent - non-exist comp of path
 * enodev - non-exist comp of spec
 * enotblk - spec not block dev
 * enotdir - non-dir comp of path or spec
 * ebusy - path busy or spec already mounted
 * emfile - mount table full
 * error - /etc/mtab and kernel not in sync
 */

int mtab_umount(/*spec*/);
/* mtab$init()
 * eperm
 * einval - dev not mounted
 * ebusy - spec busy
 */

int mtab_compress();

mdev_p mtab_nam2dev(/*spec*/);

mtab_p mtab_byDir(/*path*/);
mtab_p mtab_byDev(/*dev_t*/);
mtab_p mtab_byNam(/*spec*/);
/* mtab$init()
 */

#define MTAB_LEN (NMOUNT * sizeof(mtab_t))
#define MTAB_MOD 0644
#define MTAB_DIR (sizeof(((mtab_p)0)->m_path))
#define MTAB_DEV (sizeof(((mtab_p)0)->m_dname))

#define mtabidx(_e_) ((int)((u_long)_e_ - (u_long)mtab_db)/sizeof(mtab_t))

#endif
