/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:rvdflush.c 12.0$ */
/* $ACIS:rvdflush.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/rvd/cntrl/RCS/rvdflush.c,v $ */

#ifndef lint
static char *rcsid = "$Header:rvdflush.c 12.0$";
#endif


#ifndef lint
static char *rcsid_rvdflush_c = "$Header:rvdflush.c 12.0$";
#endif lint

/* Copyright 1984 by the Massachusetts Institute of Technology */
/* See permission and disclaimer notice in the file "notice.h" */
#include "notice.h"


/* Force spindown of all drives on a given host */

#include	<stdio.h>
#include	<sys/types.h>
#include	<sys/socket.h>
#include	<netinet/in.h>
#include	<machineio/vdconst.h>

#include	"rvd_types.h"
#include	"extern.h"

#define	BUFLEN	4096		/* Long enough to include an authenticator. */
#define	NAMLEN	 128		/* Maximum length of a server hostname. */

rvdflush(argc, argv)
	int	argc;
	char	**argv;
{
	char	*pass, *cmdstr;
	char	*cp;
	int	i;
	struct	in_addr	client, localhost;
	struct	sockaddr_in	*fh, *resolve_host();
	char	sbuf[BUFLEN];
	int	debug = 0;
	char	server[NAMLEN];
	extern	char	*myname;

	client.s_addr = localhost.s_addr = hostid();
	cmdstr = "operation=spindown_host\nname=%s\n";

	/*
	 * check for debugging option
	 */
	if (argc > 1 && ! strcmp(argv[1], "-d")) {
		++debug;
		--argc;
		++argv;
	}

	/*
	 * check argument count
	 */
	if (argc != 2 && argc != 3) {
		fprintf(stderr, "usage: %s [-d] server [client]\n", myname);
		exit(1);
	}


	/* If present, verify client name.  if not local, first try to do
	 * an authenticated spindown_host.  If that fails, get a password.
	 */
	if (argc == 3) {
		if ((fh = resolve_host(argv[2])) == NULL) {
			fprintf(stderr, "%s: %s: host unknown\n", myname,
			  argv[2]);
			exit(2);
		}
		if (fh->sin_addr.s_addr != localhost.s_addr) {
#ifdef	KERBEROS
			sprintf(sbuf, "operation=spindown_host\n");
			cp = sbuf + strlen(sbuf);
			sprintf(cp, "name=%s\npassword=\n", 
				inet_ntoa(fh->sin_addr));

			if (gethostname(server, NAMLEN) != NULL) {
				perror(myname);
				exit(1);
			}
			if ( get_auth(sbuf, server, myname, debug) &&
			     ctl_init_send_close(sbuf, argv[1], debug) == NULL)
				exit(NULL);
#endif	KERBEROS
			pass = getpass("Password: ", VD_CAPAB_LEN);
			cmdstr =
			  "operation=spindown_host\nname=%s\npassword=%s\n";
		}
		client = fh->sin_addr;
	}

	sprintf(sbuf, cmdstr, inet_ntoa(client), pass);

	exit(ctl_init_send_close(sbuf, argv[1], debug));
}
