/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:getpass.c 12.0$ */
/* $ACIS:getpass.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/rvd/lib/RCS/getpass.c,v $ */

#ifndef lint
static char *rcsid = "$Header:getpass.c 12.0$";
#endif

#ifndef lint
static char sccsid[] = "@(#)getpass.c	5.1 (Berkeley) 6/5/85";
#endif not lint

#include <stdio.h>
#include <signal.h>
#include <sgtty.h>

char *
getpass(prompt, nchar)
char *prompt;
{
	struct sgttyb ttyb;
	int flags;
	register char *p, *ep;
	register c;
	FILE *fi;
	static char pbuf[40];
	int (*signal())();
	int (*sig)();

	if(nchar > 40)
		nchar = 40;
	ep = &pbuf[nchar - 1];

	if ((fi = fdopen(open("/dev/tty", 2), "r")) == NULL)
		fi = stdin;
	else
		setbuf(fi, (char *)NULL);
	sig = signal(SIGINT, SIG_IGN);
	ioctl(fileno(fi), TIOCGETP, &ttyb);
	flags = ttyb.sg_flags;
	ttyb.sg_flags &= ~ECHO;
	ioctl(fileno(fi), TIOCSETP, &ttyb);
	fprintf(stderr, "%s", prompt); fflush(stderr);
	for (p=pbuf; (c = getc(fi))!='\n' && c!=EOF;) {
		if (p < ep)
			*p++ = c;
	}
	*p = '\0';
	fprintf(stderr, "\n"); fflush(stderr);
	ttyb.sg_flags = flags;
	ioctl(fileno(fi), TIOCSETP, &ttyb);
	signal(SIGINT, sig);
	if (fi != stdin)
		fclose(fi);
	return(pbuf);
}
