/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:obj.c 12.0$ */
/* $ACIS:obj.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/rvd/lib/RCS/obj.c,v $ */

#ifndef lint
static char *rcsid = "$Header:obj.c 12.0$";
#endif


#ifndef lint
static char rcsid_obj_c[] = "$Header:obj.c 12.0$";
#endif lint

/* Copyright 1984 by the Massachusetts Institute of Technology */
/* See permission and disclaimer notice in the file "notice.h" */
#include "notice.h"

/* This file includes the general-purpose routines to allocate and
 * free "objects" in the standard object format for the RVD program.
 * The standard format is:
 *	forward queue link (one longword)
 *	backward queue link (one longword)
 *	object type code (one longword, mostly for debugging)
 *	<object data>
 */

#include	<sys/types.h>
#include	<stdio.h>

#include	"rvd_types.h"
#include	"obj.h"
#include	"queue.h"
#include	"extern.h"


char *
obj_alloc(size, kind)

/* Allocate space for one object of the specified size and return a
 * pointer to it.  The only fields initiallized in the objects are
 * the queue links (initialized to point to the object itself) and
 * the type field, set to the specified object type.  The remaining
 * contents of the object are undefined.
 */

int	size;				/* object size in bytes */
obj_type	kind;			/* object type */
{
	register struct	object	*new_obj; /* newly allocated object */

	if (size < sizeof(struct object)) /* sanity */
		bughalt("obj_alloc: bad object size");

	if ((new_obj = (struct object *)malloc((unsigned)size)) == NULL)
		bughalt("obj_alloc: out of storage");

	q_init(new_obj);		/* init the links */
	new_obj->o_type = kind;		/* and the type field */
	return((char *)new_obj);
}


obj_free(obj)

/* Free the specified object.  It must have been allocated using obj_alloc
 * or chaos will result.
 */

char	*obj;				/* object to free */
{
	free(obj);
}
