/* $Header:opcodtab.c 12.0$ */
/* $ACIS:opcodtab.c 12.0$ */
/* $Source: /ibm/acis/usr/src/lib/c2_ca/RCS/opcodtab.c,v $ */

#ifndef lint
static char *rcsid = "$Header:opcodtab.c 12.0$";
#endif

#include "opt.h"
#include "inst.h"
#include "instps.h"

/* basic types */
#define  CBR   type_cbranch      /* Conditional branch           */
#define  UCBR  type_ucbranch     /* Unconditional branch         */
#define  LD    type_load         /* Load or immediate load       */
#define  ST    type_store        /* Store into memory            */
#define  UNIMP type_unimportant  /* Totally unimportant          */
#define  OPS   type_optpseudo    /* Optimizer Pseudo Op          */
#define  PS    type_pseudo       /* Any Pseudo Op                */

/* following can be added to basic types above */
#define  EX    type_execute   /* Execute form of branch/balr          */
#define  BaL   type_bal       /* Branch & Link type branch            */
#define  CC    type_ccset     /* Sets condition code                  */
#define  CCREF type_ccref     /* Sets condition code                  */
#define  SETR  type_setreg    /* Changes/sets value in register       */
#define  REFR  0              /* Refers to some value in a register   */
#define  LAB   type_btlab     /* Some operand could be label used as  */
                              /* a branch target or refers to a label */
                              /* of the same form (e.g. GET, ST)      */

/* Dangerous instructions have unspecified effects which are not considered */
#define  DANGER type_unknown

/* load/store types */
#define  WD    lds_full          /* Fullword             */
#define  HW    lds_half          /* Halfword             */
#define  HWA   lds_ahalf         /* Halfword arithmetic  */
#define  CHAR  lds_char          /* Character            */
#define  IMMED lds_immed         /* Immediate            */

/* List of ibm032 op codes */

struct opStat OpTab[] = {

/*                 run  opcode       ld/st                   */
/* opcode  length time  number        type  attributes       */
/* ------- ------ ----  ------        ----  -------------    */
  {"a",        2,   1,    i_a,           0, CC+SETR+REFR},
/*{"add",      2,   1,    i_a,           0, CC+SETR+REFR},  /* synonym */
  {"abs",      2,   1,    i_abs,         0, CC+SETR+REFR},
  {"ae",       2,   1,    i_ae,          0, CC+CCREF+SETR+REFR},
  {"aei",      4,   1,    i_aei,         0, CC+CCREF+SETR+REFR},
  {"ai",       4,   1,    i_ai,          0, CC+SETR+REFR},
  {"ais",      2,   1,    i_ais,         0, CC+SETR},
  {"bala",     4,   2,    i_bala,        0, SETR+UCBR+BaL},
  {"balax",    4,   2,    i_balax,       0, SETR+UCBR+BaL+EX},
  {"bali",     4,   2,    i_bali,        0, SETR+UCBR+BaL},
  {"balix",    4,   2,    i_balix,       0, SETR+UCBR+BaL+EX},
  {"balr",     2,   2,    i_balr,        0, SETR+REFR+BaL+UCBR},
  {"balrx",    2,   2,    i_balrx,       0, SETR+REFR+BaL+UCBR+EX},
  {"bb",       4,   2,    i_bb,          0, CBR+CCREF+LAB+REFR},
  {"bbr",      2,   2,    i_bbr,         0, CBR+CCREF+LAB+REFR},
  {"bbrx",     2,   2,    i_bbrx,        0, CBR+CCREF+LAB+REFR+EX},
  {"bbx",      4,   2,    i_bbx,         0, CBR+CCREF+LAB+EX},
  {"bnb",      4,   2,    i_bnb,         0, CBR+CCREF+LAB},
  {"bnbr",     2,   2,    i_bnbr,        0, CBR+CCREF+LAB+REFR},
  {"bnbrx",    2,   2,    i_bnbrx,       0, CBR+CCREF+LAB+REFR+EX},
  {"bnbx",     4,   2,    i_bnbx,        0, CBR+CCREF+LAB+EX},
  {"c",        2,   1,    i_c,           0, CC+REFR},
/*{"comp",     2,   1,    i_c,           0, CC+REFR},  /* synonym */
  {"cal",      4,   1,    i_cal,         0, SETR+REFR+LAB},
  {"cal16",    4,   1,    i_cal16,       0, SETR+REFR},
  {"cas",      2,   1,    i_cas,         0, SETR+REFR},
  {"cau",      4,   1,    i_cau,         0, SETR+REFR},
  {"ca16",     2,   1,    i_ca16,        0, SETR+REFR},
  {"ci",       4,   1,    i_ci,          0, CC+REFR},
  {"cis",      2,   1,    i_cis,         0, CC+REFR},
  {"cl",       2,   1,    i_cl,          0, CC+REFR},
  {"cli",      4,   1,    i_cli,         0, CC+REFR},
/*{"compli",   4,   1,    i_compli,      0, CC+REFR},    /* syn */
  {"clrbl",    2,   1,    i_clrbl,       0, CC+SETR+REFR},
  {"clrbu",    2,   1,    i_clrbu,       0, CC+SETR+REFR},
  {"clrsb",    2,   1,    i_clrsb,       0, DANGER},
  {"clz",      2,   1,    i_clz,         0, SETR+REFR},
  {"d",        2,   1,    i_d,           0, DANGER},
  {"dec",      2,   1,    i_dec,         0, SETR+REFR},
  {"exts",     2,   1,    i_exts,        0, CC+SETR+REFR},
  {"inc",      2,   1,    i_inc,         0, SETR},
  {"ior",      4,   1,    i_ior,         0, DANGER},
  {"iow",      4,   1,    i_iow,         0, DANGER},
  {"jb",       2,   2,    i_jb,          0, CBR+CCREF+LAB},
  {"jnb",      2,   2,    i_jnb,         0, CBR+CCREF+LAB},
  {"l",        4,   3,    i_l,          WD, SETR+REFR+LD+LAB},
  {"lc",       4,   3,    i_lc,       CHAR, SETR+REFR+LD+LAB},
  {"lcs",      2,   3,    i_lcs,      CHAR, SETR+REFR+LD+LAB},
  {"lh",       4,   3,    i_lh,         HW, SETR+REFR+LD+LAB},
  {"lha",      4,   3,    i_lha,       HWA, SETR+REFR+LD+LAB},
  {"lhas",     2,   3,    i_lhas,      HWA, SETR+REFR+LD+LAB},
  {"lhs",      2,   3,    i_lhs,        HW, SETR+REFR+LD+LAB},
  {"lis",      2,   3,    i_lis,     IMMED, SETR+LD},
  {"lm",       4,   4,    i_lm,          0, DANGER},
  {"lps",      4,   1,    i_lps,         0, DANGER},
  {"ls",       2,   3,    i_ls,         WD, SETR+REFR+LD+LAB},
  {"m",        2,   1,    i_m,           0, DANGER},
  {"mc03",     2,   1,    i_mc03,        0, SETR+REFR},
  {"mc13",     2,   1,    i_mc13,        0, SETR+REFR},
  {"mc23",     2,   1,    i_mc23,        0, SETR+REFR},
  {"mc30",     2,   1,    i_mc30,        0, SETR+REFR},
  {"mc31",     2,   1,    i_mc31,        0, SETR+REFR},
  {"mc32",     2,   1,    i_mc32,        0, SETR+REFR},
  {"mc33",     2,   1,    i_mc33,        0, SETR+REFR},
  {"mfs",      2,   1,    i_mfs,         0, DANGER},
  {"mftb",     2,   1,    i_mftb,        0, SETR+CCREF},
  {"mftbil",   2,   1,    i_mftbil,      0, SETR+CCREF},
  {"mftbiu",   2,   1,    i_mftbiu,      0, SETR+CCREF},
  {"mts",      2,   1,    i_mts,         0, DANGER},
  {"mttb",     2,   1,    i_mttb,        0, CC+REFR},
  {"mttbil",   2,   1,    i_mttbil,      0, CC+REFR},
  {"mttbiu",   2,   1,    i_mttbiu,      0, CC+REFR},
  {"n",        2,   1,    i_n,           0, CC+SETR+REFR},
  {"nilo",     4,   1,    i_nilo,        0, CC+SETR+REFR},
  {"nilz",     4,   1,    i_nilz,        0, CC+SETR+REFR},
  {"niuo",     4,   1,    i_niuo,        0, CC+SETR+REFR},
  {"niuz",     4,   1,    i_niuz,        0, CC+SETR+REFR},
  {"o",        2,   1,    i_o,           0, CC+SETR+REFR},
  {"oil",      4,   1,    i_oil,         0, CC+SETR+REFR},
  {"oiu",      4,   1,    i_oiu,         0, CC+SETR+REFR},
  {"onec",     2,   1,    i_onec,        0, CC+SETR+REFR},
  {"s",        2,   1,    i_s,           0, CC+SETR+REFR},
/*{"sub",      2,   1,    i_s,           0, CC+SETR+REFR}, /* synonym */
  {"sar",      2,   1,    i_sar,         0, CC+SETR+REFR},
  {"sari",     2,   1,    i_sari,        0, CC+SETR+REFR},
  {"sari16",   2,   1,    i_sari16,      0, CC+SETR+REFR},
  {"se",       2,   1,    i_se,          0, CC+SETR+REFR+CCREF},
  {"setbl",    2,   1,    i_setbl,       0, CC+SETR+REFR},
  {"setbu",    2,   1,    i_setbu,       0, CC+SETR+REFR},
  {"setsb",    2,   1,    i_setsb,       0, DANGER},
  {"sf",       2,   1,    i_sf,          0, CC+SETR+REFR},
  {"sfi",      4,   1,    i_sfi,         0, CC+SETR+REFR},
  {"sis",      2,   1,    i_sis,         0, CC+SETR+REFR},
  {"sl",       2,   1,    i_sl,          0, CC+SETR+REFR},
  {"sli",      2,   1,    i_sli,         0, CC+SETR+REFR},
  {"sli16",    2,   1,    i_sli16,       0, CC+SETR+REFR},
  {"slp",      2,   1,    i_slp,         0, CC+SETR+REFR},
  {"slpi",     2,   1,    i_slpi,        0, CC+SETR+REFR},
  {"slpi16",   2,   1,    i_slpi16,      0, CC+SETR+REFR},
  {"sr",       2,   1,    i_sr,          0, CC+SETR+REFR},
  {"sri",      2,   1,    i_sri,         0, CC+SETR+REFR},
  {"sri16",    2,   1,    i_sri16,       0, CC+SETR+REFR},
  {"srp",      2,   1,    i_srp,         0, CC+SETR+REFR},
  {"srpi",     2,   1,    i_srpi,        0, CC+SETR+REFR},
  {"srpi16",   2,   1,    i_srpi16,      0, CC+SETR+REFR},
  {"st",       4,   3,    i_st,         WD, ST+LAB+REFR},
  {"stc",      4,   3,    i_stc,      CHAR, ST+LAB+REFR},
  {"stcs",     2,   3,    i_stcs,     CHAR, ST+LAB+REFR},
  {"sth",      4,   3,    i_sth,        HW, ST+LAB+REFR},
  {"sths",     2,   3,    i_sths,       HW, ST+LAB+REFR},
  {"stm",      4,   3,    i_stm,         0, DANGER},
  {"sts",      2,   3,    i_sts,        WD, ST+LAB+REFR},
  {"svc",      4,   1,    i_svc,         0, DANGER},
  {"tgte",     2,   1,    i_tgte,        0, DANGER},
  {"ti",       4,   1,    i_ti,          0, DANGER},
  {"tlt",      2,   1,    i_tlt,         0, DANGER},
  {"tsh",      4,   1,    i_tsh,         0, DANGER},
  {"twoc",     2,   1,    i_twoc,        0, CC+SETR+REFR},
  {"wait",     2,   1,    i_wait,        0, DANGER},
  {"x",        2,   1,    i_x,           0, CC+SETR+REFR},
  {"xil",      4,   1,    i_xil,         0, CC+SETR+REFR},
  {"xiu",      4,   1,    i_xiu,         0, CC+SETR+REFR},

  /* extended opcodes */

  {"clrckm",    2,   1,    i_clrckm,     0, DANGER},
  {"clrim",     2,   1,    i_clrim,      0, DANGER},
  {"clrtb",     2,   1,    i_clrtb,      0, DANGER},
  {"setckm",    2,   1,    i_setckm,     0, DANGER},
  {"setim",     2,   1,    i_setim,      0, DANGER},
  {"settb",     2,   1,    i_settb,      0, DANGER},

/*{"mr",        2,   1,    i_mr,         0, SETR+REFR},	  tjm */

/*{"lil",       4,   1,    i_lil,        0, SETR+REFR},   /* cal */
/*{"liu",       4,   1,    i_liu,        0, SETR+REFR},   /* cau */

  {"mfcks",     2,   1,    i_mfcks,      0, DANGER},
  {"mfcs",      2,   1,    i_mfcs,       0, DANGER},
  {"mfia",      2,   1,    i_mfia,       0, DANGER},
  {"mfics",     2,   1,    i_mfics,      0, DANGER},
  {"mfirb",     2,   1,    i_mfirb,      0, DANGER},
  {"mfstr",     2,   1,    i_mfstr,      0, DANGER},
  {"mtcks",     2,   1,    i_mtcks,      0, DANGER},
  {"mtcs",      2,   1,    i_mtcs,       0, DANGER},
  {"mtics",     2,   1,    i_mtics,      0, DANGER},
  {"mtirb",     2,   1,    i_mtirb,      0, DANGER},
  {"mtstr",     2,   1,    i_mtstr,      0, DANGER},

  {"b",         4,   2,    i_b,          0, UCBR+LAB},
  {"nop",       4,   1,    i_nop,        0, UNIMP},
  {"btb",       4,   2,    i_btb,        0, CBR+CCREF+LAB},
  {"bntb",      4,   2,    i_bntb,       0, CBR+CCREF+LAB},
  {"bc0",       4,   2,    i_bc0,        0, CBR+CCREF+LAB},
  {"bnc0",      4,   2,    i_bnc0,       0, CBR+CCREF+LAB},
  {"bl",        4,   2,    i_bl,         0, CBR+CCREF+LAB},
  {"bnl",       4,   2,    i_bnl,        0, CBR+CCREF+LAB},
  {"bhe",       4,   2,    i_bhe,        0, CBR+CCREF+LAB},
  {"bm",        4,   2,    i_bm,         0, CBR+CCREF+LAB},
  {"bnm",       4,   2,    i_bnm,        0, CBR+CCREF+LAB},
  {"bh",        4,   2,    i_bh,         0, CBR+CCREF+LAB},
  {"bnh",       4,   2,    i_bnh,        0, CBR+CCREF+LAB},
  {"ble",       4,   2,    i_ble,        0, CBR+CCREF+LAB},
  {"bp",        4,   2,    i_bp,         0, CBR+CCREF+LAB},
  {"bnp",       4,   2,    i_bnp,        0, CBR+CCREF+LAB},
  {"be",        4,   2,    i_be,         0, CBR+CCREF+LAB},
  {"beq",       4,   2,    i_beq,        0, CBR+CCREF+LAB},
  {"bne",       4,   2,    i_bne,        0, CBR+CCREF+LAB},
  {"bz",        4,   2,    i_bz,         0, CBR+CCREF+LAB},
  {"bnz",       4,   2,    i_bnz,        0, CBR+CCREF+LAB},
  {"bo",        4,   2,    i_bo,         0, CBR+CCREF+LAB},
  {"bno",       4,   2,    i_bno,        0, CBR+CCREF+LAB},

  {"bx",        4,   2,    i_bx,         0, UCBR+LAB},
  {"nopx",      4,   2,    i_nopx,       0, UNIMP},
  {"btbx",      4,   2,    i_btbx,       0, CBR+CCREF+LAB},
  {"bntbx",     4,   2,    i_bntbx,      0, CBR+CCREF+LAB},
  {"bc0x",      4,   2,    i_bc0x,       0, CBR+CCREF+LAB},
  {"bnc0x",     4,   2,    i_bnc0x,      0, CBR+CCREF+LAB},
  {"blx",       4,   2,    i_blx,        0, CBR+CCREF+LAB},
  {"bnlx",      4,   2,    i_bnlx,       0, CBR+CCREF+LAB},
  {"bhex",      4,   2,    i_bhex,       0, CBR+CCREF+LAB},
  {"bmx",       4,   2,    i_bmx,        0, CBR+CCREF+LAB},
  {"bnmx",      4,   2,    i_bnmx,       0, CBR+CCREF+LAB},
  {"bhx",       4,   2,    i_bhx,        0, CBR+CCREF+LAB},
  {"bnhx",      4,   2,    i_bnhx,       0, CBR+CCREF+LAB},
  {"blex",      4,   2,    i_blex,       0, CBR+CCREF+LAB},
  {"bpx",       4,   2,    i_bpx,        0, CBR+CCREF+LAB},
  {"bnpx",      4,   2,    i_bnpx,       0, CBR+CCREF+LAB},
  {"bex",       4,   2,    i_bex,        0, CBR+CCREF+LAB},
  {"beqx",      4,   2,    i_beqx,       0, CBR+CCREF+LAB},
  {"bnex",      4,   2,    i_bnex,       0, CBR+CCREF+LAB},
  {"bzx",       4,   2,    i_bzx,        0, CBR+CCREF+LAB},
  {"bnzx",      4,   2,    i_bnzx,       0, CBR+CCREF+LAB},
  {"box",       4,   2,    i_box,        0, CBR+CCREF+LAB},
  {"bnox",      4,   2,    i_bnox,       0, CBR+CCREF+LAB},

  {"br",        2,   2,    i_br,         0, UCBR+REFR},
  {"nopr",      2,   2,    i_nopr,       0, DANGER},
  {"btbr",      2,   2,    i_btbr,       0, CBR+CCREF+REFR},
  {"bntbr",     2,   2,    i_bntbr,      0, CBR+CCREF+REFR},
  {"bc0r",      2,   2,    i_bc0r,       0, CBR+CCREF+REFR},
  {"bnc0r",     2,   2,    i_bnc0r,      0, CBR+CCREF+REFR},
  {"blr",       2,   2,    i_blr,        0, CBR+CCREF+REFR},
  {"bnlr",      2,   2,    i_bnlr,       0, CBR+CCREF+REFR},
  {"bher",      2,   2,    i_bher,       0, CBR+CCREF+REFR},
  {"bmr",       2,   2,    i_bmr,        0, CBR+CCREF+REFR},
  {"bnmr",      2,   2,    i_bnmr,       0, CBR+CCREF+REFR},
  {"bhr",       2,   2,    i_bhr,        0, CBR+CCREF+REFR},
  {"bnhr",      2,   2,    i_bnhr,       0, CBR+CCREF+REFR},
  {"bler",      2,   2,    i_bler,       0, CBR+CCREF+REFR},
  {"bpr",       2,   2,    i_bpr,        0, CBR+CCREF+REFR},
  {"bnpr",      2,   2,    i_bnpr,       0, CBR+CCREF+REFR},
  {"ber",       2,   2,    i_ber,        0, CBR+CCREF+REFR},
  {"beqr",      2,   2,    i_beqr,       0, CBR+CCREF+REFR},
  {"bner",      2,   2,    i_bner,       0, CBR+CCREF+REFR},
  {"bzr",       2,   2,    i_bzr,        0, CBR+CCREF+REFR},
  {"bnzr",      2,   2,    i_bnzr,       0, CBR+CCREF+REFR},
  {"bor",       2,   2,    i_bor,        0, CBR+CCREF+REFR},
  {"bnor",      2,   2,    i_bnor,       0, CBR+CCREF+REFR},

  {"brx",       2,   2,    i_brx,        0, UCBR+REFR+EX},
  {"noprx",     2,   2,    i_noprx,      0, DANGER},
  {"btbrx",     2,   2,    i_btbrx,      0, CBR+CCREF+REFR+EX},
  {"bntbrx",    2,   2,    i_bntbrx,     0, CBR+CCREF+REFR+EX},
  {"bc0rx",     2,   2,    i_bc0rx,      0, CBR+CCREF+REFR+EX},
  {"bnc0rx",    2,   2,    i_bnc0rx,     0, CBR+CCREF+REFR+EX},
  {"blrx",      2,   2,    i_blrx,       0, CBR+CCREF+REFR+EX},
  {"bnlrx",     2,   2,    i_bnlrx,      0, CBR+CCREF+REFR+EX},
  {"bherx",     2,   2,    i_bherx,      0, CBR+CCREF+REFR+EX},
  {"bmrx",      2,   2,    i_bmrx,       0, CBR+CCREF+REFR+EX},
  {"bnmrx",     2,   2,    i_bnmrx,      0, CBR+CCREF+REFR+EX},
  {"bhrx",      2,   2,    i_bhrx,       0, CBR+CCREF+REFR+EX},
  {"bnhrx",     2,   2,    i_bnhrx,      0, CBR+CCREF+REFR+EX},
  {"blerx",     2,   2,    i_blerx,      0, CBR+CCREF+REFR+EX},
  {"bprx",      2,   2,    i_bprx,       0, CBR+CCREF+REFR+EX},
  {"bnprx",     2,   2,    i_bnprx,      0, CBR+CCREF+REFR+EX},
  {"berx",      2,   2,    i_berx,       0, CBR+CCREF+REFR+EX},
  {"beqrx",     2,   2,    i_beqrx,      0, CBR+CCREF+REFR+EX},
  {"bnerx",     2,   2,    i_bnerx,      0, CBR+CCREF+REFR+EX},
  {"bzrx",      2,   2,    i_bzrx,       0, CBR+CCREF+REFR+EX},
  {"bnzrx",     2,   2,    i_bnzrx,      0, CBR+CCREF+REFR+EX},
  {"borx",      2,   2,    i_borx,       0, CBR+CCREF+REFR+EX},
  {"bnorx",     2,   2,    i_bnorx,      0, CBR+CCREF+REFR+EX},

  {"j",         2,   2,    i_j,          0, UCBR+LAB},
  {"jnop",      2,   2,    i_jnop,       0, UNIMP},
  {"jtb",       2,   2,    i_jtb,        0, CBR+CCREF+LAB},
  {"jntb",      2,   2,    i_jntb,       0, CBR+CCREF+LAB},
  {"jc0",       2,   2,    i_jc0,        0, CBR+CCREF+LAB},
  {"jnc0",      2,   2,    i_jnc0,       0, CBR+CCREF+LAB},
  {"jl",        2,   2,    i_jl,         0, CBR+CCREF+LAB},
  {"jnl",       2,   2,    i_jnl,        0, CBR+CCREF+LAB},
  {"jhe",       2,   2,    i_jhe,        0, CBR+CCREF+LAB},
  {"jm",        2,   2,    i_jm,         0, CBR+CCREF+LAB},
  {"jnm",       2,   2,    i_jnm,        0, CBR+CCREF+LAB},
  {"jh",        2,   2,    i_jh,         0, CBR+CCREF+LAB},
  {"jnh",       2,   2,    i_jnh,        0, CBR+CCREF+LAB},
  {"jle",       2,   2,    i_jle,        0, CBR+CCREF+LAB},
  {"jp",        2,   2,    i_jp,         0, CBR+CCREF+LAB},
  {"jnp",       2,   2,    i_jnp,        0, CBR+CCREF+LAB},
  {"je",        2,   2,    i_je,         0, CBR+CCREF+LAB},
  {"jeq",       2,   2,    i_jeq,        0, CBR+CCREF+LAB},
  {"jne",       2,   2,    i_jne,        0, CBR+CCREF+LAB},
  {"jz",        2,   1,    i_jz,         0, CBR+CCREF+LAB},
  {"jnz",       2,   1,    i_jnz,        0, CBR+CCREF+LAB},
  {"jo",        2,   1,    i_jo,         0, CBR+CCREF+LAB},
  {"jno",       2,   1,    i_jno,        0, CBR+CCREF+LAB},

  {"tlti",      4,   1,    i_tlti,       0, DANGER},
  {"tnei",      4,   1,    i_tnei,       0, DANGER},
  {"tgti",      4,   1,    i_tgti,       0, DANGER},
  {"teqi",      4,   1,    i_teqi,       0, DANGER},
  {"tilt",      4,   1,    i_tilt,       0, DANGER},

  {"get",       3,   3,    i_get,       WD, SETR+REFR+LD+LAB},
  {"getc",      3,   3,    i_getc,    CHAR, SETR+REFR+LD+LAB},
  {"geth",      3,   3,    i_geth,      HW, SETR+REFR+LD+LAB},
  {"getha",     3,   3,    i_getha,    HWA, SETR+REFR+LD+LAB},
  {"put",       3,   3,    i_put,       WD, REFR+ST+LAB},
  {"putc",      3,   3,    i_putc,    CHAR, REFR+ST+LAB},
  {"puth",      3,   3,    i_puth,      HW, REFR+ST+LAB},
  {"putha",     3,   3,    i_putha,    HWA, REFR+ST+LAB},
  {"load",	3,   3,	   i_load,      WD, SETR+REFR+LD+LAB},
  {"loadc",	3,   3,	   i_loadc,   CHAR, SETR+REFR+LD+LAB},
  {"loadh",	3,   3,	   i_loadh,     HW, SETR+REFR+LD+LAB},
  {"loadha",	3,   3,	   i_loadha,   HWA, SETR+REFR+LD+LAB},
  {"store",	3,   3,	   i_store,     WD, REFR+ST+LAB},
  {"storec",	3,   3,	   i_storec,  CHAR, REFR+ST+LAB},
  {"storeh",	3,   3,	   i_storeh,    HW, REFR+ST+LAB},
  {"storeha",	3,   3,	   i_storeha,  HWA, REFR+ST+LAB},
  {"shl",       2,   1,    i_shl,        0, CC+SETR+REFR},
  {"shr",       2,   1,    i_shr,        0, CC+SETR+REFR},
  {"shla",      2,   1,    i_shla,       0, CC+SETR+REFR},
  {"shra",      2,   1,    i_shra,       0, CC+SETR+REFR},
  {"sra",       2,   1,    i_sra,        0, CC+SETR+REFR},
  {"sla",       2,   1,    i_sla,        0, CC+SETR+REFR},
/*{"loadi",     5,   1,    i_loadi,  IMMED, LD+SETR+REFR},	tjm */
/*{"addi",      3,   1,    i_addi,       0, CC+SETR+REFR},	tjm */
/*{"subi",      3,   1,    i_subi,       0, CC+SETR+REFR},	tjm */
  {"si",        3,   1,    i_si,         0, CC+SETR+REFR},
/*{"compi",     3,   1,    i_compi,      0, CC+REFR},		tjm */
  {"ni",        4,   1,    i_ni,         0, CC+SETR+REFR},
  {"oi",        5,   1,    i_oi,         0, CC+SETR+REFR},
  {"xi",        5,   1,    i_xi,         0, CC+SETR+REFR},

  /* pseudo   ops */

  {".long",     9,   0,    i_long,       0, PS+DANGER+LAB},
/*{".hword",    9,   0,    i_hword,      0, PS+DANGER+LAB},	tjm */
  {".short",    9,   0,    i_hword,      0, PS+DANGER+LAB},
  {".word",     9,   0,    i_word,       0, PS+DANGER+LAB},
  {".byte",     9,   0,    i_byte,       0, PS+DANGER},
  {".text",     0,   0,    i_text,       0, PS+DANGER},
  {".data",     0,   0,    i_data,       0, PS+DANGER},
/*{".bss",      0,   0,    i_bss,        0, PS+DANGER},		tjm */
  {".globl",    0,   0,    i_globl,      0, PS+UNIMP},
  {".comm",     0,   0,    i_comm,       0, PS+UNIMP},
/*{".even",     9,   0,    i_even,       0, PS+DANGER},		tjm */
  {".align",    9,   0,    i_align,      0, PS+DANGER},
  {".asciz",    9,   0,    i_asciz,      0, PS+DANGER},
  {".ascii",    9,   0,    i_ascii,      0, PS+DANGER+UNIMP},
/*{".zerol",    9,   0,    i_zerol,      0, PS+DANGER},		tjm */
/*{".end",      0,   0,    i_end,        0, PS+DANGER},		tjm */
/*{".cnop",     9,   0,    i_cnop,       0, PS+DANGER},		tjm */
/*{".eject",    0,   0,    i_eject,      0, PS+UNIMP},		tjm */
/*{".title",    0,   0,    i_title,      0, PS+UNIMP},		tjm */
/*{".lspace",   0,   0,    i_lspace,     0, PS+UNIMP},		tjm */
/*{".ascil",    9,   0,    i_ascil,      0, PS+DANGER},		tjm */
  {".ltorg",    9,   0,    i_ltorg,      0, PS+DANGER},
/*{".opsyn",    0,   0,    i_opsyn,      0, PS+DANGER},		tjm */
  {".float",    4,   0,    i_float,      0, PS+DANGER},
  {".double",   8,   0,    i_double,     0, PS+DANGER},
/*{".debug",    0,   0,    i_debug,      0, PS+UNIMP},		tjm */
  {".using",    0,   0,    i_using,      0, PS+DANGER+LAB},
/*{".tusing",   0,   0,    i_tusing,     0, PS+DANGER+LAB},	tjm */
/*{".dusing",   0,   0,    i_dusing,     0, PS+DANGER+LAB},	tjm */
/*{".busing",   0,   0,    i_busing,     0, PS+DANGER+LAB},	tjm */
  {".space",    5,   0,    i_space,      0, PS+DANGER},
  {".abort",    0,   0,    i_abort,      0, PS+DANGER},
  {".file",     0,   0,    i_file,       0, PS+UNIMP},
  {".line",     0,   0,    i_line,       0, PS+UNIMP},
  {".org",      5,   0,    i_org,        0, PS+DANGER+LAB},
  {".fill",     5,   0,    i_fill,       0, PS+DANGER},
  {".set",      0,   0,    i_set,        0, PS+DANGER+UNIMP}, /* tjm */
  {".lsym",     0,   0,    i_lsym,       0, PS+DANGER},
  {".stabs",    0,   0,    i_stabs,      0, PS+UNIMP},
  {".stabn",    0,   0,    i_stabn,      0, PS+UNIMP},
  {".stabd",    0,   0,    i_stabd,      0, PS+UNIMP},
  {".lcomm",    0,   0,    i_lcomm,      0, PS+UNIMP},
  {".int",      5,   0,    i_int,        0, PS+DANGER+LAB},
  {".zerob",    5,   0,    i_zerob,      0, PS+DANGER},
  {"_funct",    0,   0,    i_funct,      0, PS+OPS+UNIMP},
  {"_efunct",   0,   0,    i_efunct,     0, PS+OPS+UNIMP},
  {"_freg",     0,   0,    i_freg,       0, PS+OPS+UNIMP},
  {"_sym",      0,   0,    i_sym,        0, PS+OPS+UNIMP},
  {"",          0,   0,    0,            0, 0}
  };

