/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:rpc.rusersd.c 12.0$ */
/* $ACIS:rpc.rusersd.c 12.0$ */
/* $Source: /ibm/acis/usr/src/nfs/etc/RCS/rpc.rusersd.c,v $ */

#ifndef lint
static char *rcsid = "$Header:rpc.rusersd.c 12.0$";
#endif

#include <sys/nfs_defines.h>

/* @(#)rpc.rusersd.c	1.3 87/08/13 3.2/4.3NFSSRC */
/* @(#)rpc.rusersd.c	1.4 87/03/13 NFSSRC */
#ifndef lint
static  char sccsid[] = "@(#)rpc.rusersd.c 1.1 86/09/25 Copyright 1984, 1987 Sun Microsystems, Inc.";
/*
 *
 * NFSSRC 3.2/4.3 for the VAX*
 * Copyright (C) 1987 Sun Microsystems, Inc.
 * 
 * (*)VAX is a trademark of Digital Equipment Corporation
 *
 */
#endif

/*
 * Copyright (c) 1984, 1987 by Sun Microsystems, Inc.
 */

#include <rpc/rpc.h>
#include <utmp.h>
#include <rpcsvc/rusers.h>
#include <stdio.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <syslog.h>

#define	DIV60(t)	((t+30)/60)    /* x/60 rounded */
#define MAXINT 0x7fffffff
#define min(a,b) ((a) < (b) ? (a) : (b))

struct utmparr utmparr;
struct utmpidlearr utmpidlearr;
int cnt;
int rusers_service();

#define NLNTH 8			/* sizeof ut_name */

/*
 * This is a utmp entry that does not correspond to a genuine user.
 * Could go in utmp.h if desired.
 */
#define nonuser(ut) ((ut).ut_host[0] == 0 && \
        strncmp((ut).ut_line, "tty", 3) == 0 && ((ut).ut_line[3] == 'p' \
        || (ut).ut_line[3] == 'q' || (ut).ut_line[3] == 'r'))

main()
{
	register SVCXPRT * transp;
	struct sockaddr_in addr;
	int len = sizeof(struct sockaddr_in);

#ifdef DEBUG
	{
		int s;
		struct sockaddr_in addr;
		int len = sizeof(struct sockaddr_in);

		if ((s = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP)) < 0) {
			syslog(LOG_ERR, "inet: socket");
			return - 1;
		}
		if (bind(s, &addr, sizeof(addr)) < 0) {
			syslog(LOG_ERR,"bind");
			return - 1;
		}
		if (getsockname(s, &addr, &len) != 0) {
			syslog(LOG_ERR,"inet: getsockname");
			(void)close(s);
			return - 1;
		}
		pmap_unset(RUSERSPROG, RUSERSVERS_ORIG);
		pmap_set(RUSERSPROG, RUSERSVERS_ORIG, IPPROTO_UDP,
		    ntohs(addr.sin_port));
		pmap_unset(RUSERSPROG, RUSERSVERS_IDLE);
		pmap_set(RUSERSPROG, RUSERSVERS_IDLE, IPPROTO_UDP,
		    ntohs(addr.sin_port));
		if (dup2(s, 0) < 0) {
			syslog(LOG_ERR,"dup2");
			exit(1);
		}
	}
#endif	

	if (getsockname(0, &addr, &len) != 0) {
		syslog(LOG_ERR,"rstat: getsockname");
		exit(1);
	}
	if ((transp = svcudp_create(0)) == NULL) {
		syslog(LOG_ERR, "svc_rpc_udp_create: error\n");
		exit(1);
	}
	if (!svc_register(transp, RUSERSPROG, RUSERSVERS_ORIG,
	    rusers_service,0)) {
		syslog(LOG_ERR, "svc_rpc_register: error\n");
		exit(1);
	}
	if (!svc_register(transp, RUSERSPROG, RUSERSVERS_IDLE,
	    rusers_service,0)) {
		syslog(LOG_ERR, "svc_rpc_register: error\n");
		exit(1);
	}
	svc_run();		/* never returns */
	syslog(LOG_ALERT, "run_svc_rpc should never return\n");
}

getutmp(all, idle)
	int all;		/* give all listings? */
	int idle;		/* get idle time? */
{
	struct utmp buf, **p;
	struct utmpidle **q, *console = NULL;
	int minidle;
	FILE *fp;
	char *file;
	char name[NLNTH];
	
	cnt = 0;
	file = "/etc/utmp";
	if ((fp = fopen(file, "r")) == NULL) {
		syslog(LOG_ERR, "can't open %s\n", file);
		exit(1);
	};
	p = utmparr.uta_arr;
	q = utmpidlearr.uia_arr;
	while (fread(&buf, sizeof(buf), 1, fp) == 1) {
		if (buf.ut_line[0] == 0 || buf.ut_name[0] == 0)
			continue;
		/* 
		 * if tty[pqr]? and not remote, then skip it
		 */
		if (!all && nonuser(buf))
			continue;
		/* 
		 * need to free this
		 */
		if (idle) {
			*q = (struct utmpidle *)
			    malloc(sizeof(struct utmpidle));
			if (strncmp(buf.ut_line, "console",
			    strlen("console")) == 0) {
				console = *q;
				strncpy(name, buf.ut_name, NLNTH);
			    }
			bcopy(&buf, &((*q)->ui_utmp), sizeof(buf));
			(*q)->ui_idle = findidle(&buf);
#ifdef DEBUG
			printf("%-10s %-10s %-18s %s; idle %d",
			    buf.ut_line, buf.ut_name,
			    buf.ut_host, ctime(&buf.ut_time),
			    (*q)->ui_idle);
#endif
			q++;
		}
		else {
			*p = (struct utmp *)malloc(sizeof(struct utmp));
			bcopy(&buf, *p, sizeof(buf));
#ifdef DEBUG
			printf("%-10s %-10s %-18s %s",
			    buf.ut_line, buf.ut_name,
			    buf.ut_host, ctime(&buf.ut_time));
#endif
			p++;
		}
		cnt++;
	}
	/* 
	 * if the console and the window pty's are owned by the same
	 * user, take the min of the idle times and associate
	 * it with the console
	 */
	if (idle && console) {
		minidle = MAXINT;
		rewind(fp);
		while (fread(&buf, sizeof(buf), 1, fp) == 1) {
			if (nonuser(buf)
			    && strncmp(buf.ut_name, name, NLNTH) == 0)
				minidle = min(findidle(&buf), minidle);
		}
		console->ui_idle = min(minidle, console->ui_idle);
	}
}

rusers_service(rqstp, transp)
	register struct svc_req *rqstp;
	register SVCXPRT *transp;
{
	switch (rqstp->rq_proc) {
	case 0:
		if (svc_sendreply(transp, xdr_void, 0)  == FALSE) {
			syslog(LOG_ERR, "err: rusersd");
			exit(1);
		    }
		exit(0);
	case RUSERSPROC_NUM:
		utmparr.uta_arr = (struct utmp **)
		    malloc(MAXUSERS*sizeof(struct utmp *));
		getutmp(0, 0);
		if (!svc_sendreply(transp, xdr_u_long, &cnt))
			syslog(LOG_ERR,"svc_rpc_send_results");
		free(utmparr.uta_arr);
		exit(0);
	case RUSERSPROC_NAMES:
	case RUSERSPROC_ALLNAMES:
		if (rqstp->rq_vers == RUSERSVERS_ORIG) {
			utmparr.uta_arr = (struct utmp **)
			    malloc(MAXUSERS*sizeof(struct utmp *));
			getutmp(rqstp->rq_proc == RUSERSPROC_ALLNAMES, 0);
			utmparr.uta_cnt = cnt;
			if (!svc_sendreply(transp, xdr_utmparr, &utmparr))
				syslog(LOG_ERR,"svc_rpc_send_results");
			svc_freeargs(transp, xdr_utmparr, &utmparr);
			free(utmparr.uta_arr);
			exit(0);
		}
		else {
			utmpidlearr.uia_arr = (struct utmpidle **)
			    malloc(MAXUSERS*sizeof(struct utmpidle *));
			getutmp(rqstp->rq_proc == RUSERSPROC_ALLNAMES, 1);
			utmpidlearr.uia_cnt = cnt;
			if (!svc_sendreply(transp, xdr_utmpidlearr,
			    &utmpidlearr))
				syslog(LOG_ERR,"svc_rpc_send_results");
			svc_freeargs(transp, xdr_utmpidlearr, &utmpidlearr);
			free(utmpidlearr.uia_arr);
			exit(0);
		}
	default: 
		svcerr_noproc(transp);
		exit(0);
	}
}

/* find & return number of minutes current tty has been idle */
findidle(up)
	struct utmp *up;
{
	time_t	now;
	struct stat stbuf;
	long lastaction, diff;
	char ttyname[20];

	strcpy(ttyname, "/dev/");
	strncat(ttyname, up->ut_line, sizeof(up->ut_line));
	stat(ttyname, &stbuf);
	time(&now);
	lastaction = stbuf.st_atime;
	diff = now - lastaction;
	diff = DIV60(diff);
	if (diff < 0) diff = 0;
	return(diff);
}

/* 
 * NFSSRC 3.2/4.3 for the VAX*
 * Copyright (C) 1987 Sun Microsystems, Inc.
 * 
 * (*)VAX is a trademark of Digital Equipment Corporation
 */
