/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:hys24.c 12.1$ */
/* $ACIS:hys24.c 12.1$ */
/* $Source: /ibm/acis/usr/src/usr.bin/uucp/aculib/RCS/hys24.c,v $ */

#ifndef lint
static char *rcsid = "$Header:hys24.c 12.1$";
#endif

#ifndef lint
static char sccsid[] = "@(#)hys24.c	1.1 (Berkeley) 1/13/86";
#endif !lint

#include "../condevs.h"

#ifdef HAYES2400
/*
 *	hyspopn24(telno, flds, dev) connect to hayes smartmodem (pulse call)
 *	hystopn24(telno, flds, dev) connect to hayes smartmodem (tone call)
 *	char *flds[], *dev[];
 *
 *	return codes:
 *		>0  -  file number  -  ok
 *		CF_DIAL,CF_DEVICE  -  failed
 */

hyspopn24(telno, flds, dev)
char *telno, *flds[];
struct Devices *dev;
{
	return hysopn24(telno, flds, dev, 0);
}

hystopn24(telno, flds, dev)
char *telno, *flds[];
struct Devices *dev;
{
	return hysopn24(telno, flds, dev, 1);
}

/* ARGSUSED */
hysopn24(telno, flds, dev, toneflag)
char *telno;
char *flds[];
struct Devices *dev;
int toneflag;
{
	int	dh = -1;
	char *ii;
	extern errno;
	char dcname[20];

#ifdef ibm032
	char *cp, cbuf[30];
#endif

	sprintf(dcname, "/dev/%s", dev->D_line);
	DEBUG(4, "dc - %s\n", dcname);
	if (setjmp(Sjbuf)) {
		logent(dcname, "TIMEOUT");
		if (dh >= 0)
			hyscls24(dh);
		return CF_DIAL;
	}
	signal(SIGALRM, alarmtr);
	getnextfd();
	alarm(10);
	dh = open(dcname, 2); /* read/write */
	alarm(0);

	for (ii = telno; *ii; ii++)
		if (*ii == '=')
		    *ii = ',';

	/* modem is open */
	next_fd = -1;
	if (dh >= 0) {
		fixline(dh, dev->D_speed);
		write(dh, "\rATZH\r", 6);
#ifdef ibm032
		/* think this is required on any machine */
		if (expect("OK\r\n", dh) != 0) {
			logent(dcname, "ATZH not OK");
			hyscls24(dh);
			return CF_DIAL;
		}
#endif
		sleep(2);
		if (dochat(dev, flds, dh)) {
			logent(dcname, "CHAT FAILED");
			hyscls24(dh);
			return CF_DIAL;
		}
		write(dh, "AT&F&D3&C1E0X1\r", 15);
		if (expect("OK\r\n", dh) != 0) {
			logent(dcname, "HSM not responding OK");
			hyscls24(dh);
			return CF_DIAL;
		}
#ifdef ibm032
		write(dh, "ATE1\r", 5);
		if (expect("OK\r\n", dh) != 0) {
			logent(dcname, "ATE1 not OK");
			hyscls24(dh);
			return CF_DIAL;
		}
#endif
		if (toneflag)
			write(dh, "\rATDT", 5);
		else
			write(dh, "\rATDP", 5);
#ifdef notdef
		cp = cbuf;
		while(read(dh, cp++ ,1) == 1)
			if ((cp - cbuf) > 4)
				break;
		*cp = '\0';
		DEBUG(4,"\nUSING - %s\n", cbuf);
#endif
#ifdef ibm032
		write(dh, telno, strlen(telno));
		write(dh, ";\r", 2);
		cp = cbuf;
		while(read(dh, cp++ ,1) == 1)
			if ((cp - cbuf) > 9)
				break;
		*cp = '\0';
		DEBUG(4,"\nDIALED - %s\n", cbuf);
		sleep(26);
		write(dh, "\rATO\r", 5);
#else
		write(dh, telno, strlen(telno));
		write(dh, "\r", 1);
#endif

		if (expect("CONNECT 2400\r\n", dh) != 0) {
			logent("HSM no carrier", _FAILED);
			strcpy(devSel, dev->D_line);
			hyscls24(dh);
			return CF_DIAL;
		}

	}
	if (dh < 0) {
		logent(dcname, "CAN'T OPEN");
		return dh;
	}
	DEBUG(4, "hayes ok\n", CNULL);
	return dh;
}

hyscls24(fd)
int fd;
{
	char dcname[20];

	if (fd > 0) {
		sprintf(dcname, "/dev/%s", devSel);
		DEBUG(4, "Hanging up fd = %d\n", fd);
		sleep(1);
/*
 * Since we have a getty sleeping on this line, when it wakes up it sends
 * all kinds of garbage to the modem.  Unfortunatly, the modem likes to
 * execute the previous command when it sees the garbage.  The previous
 * command was to dial the phone, so let's make the last command reset
 * the modem.
 */
		write(fd, "\r+++", 4);
		sleep(2);
		write(fd, "\rATH\rATZ\r", 9);
		sleep(2);
		close(fd);
		delock(devSel);
	}
}
#endif HAYES2400
