/* $Header:_image.c 12.0$ */
/* $ACIS:_image.c 12.0$ */
/* $Source: /ibm/acis/usr/src/usr.lib/libaed/RCS/_image.c,v $ */

#ifndef lint
static char *rcsid = "$Header:_image.c 12.0$";
#endif

#include "whim.h"
/*--------------------------------------------------------------*/
/*  Draw image from memory					*/
/*--------------------------------------------------------------*/

VI_MImage(wd,ht,data)
  INT16 wd,ht;			/* image dimensions */
  unsigned INT16 *data; 	/* image data */

  begin
#include "whimdcl.h"
    INT16 fullht;		/* full height of image */
    INT16 nwords;		/* number of words in image scanline */
    INT16 nbytes;		/* 2*nwords */
    INT16 maxht;		/* maximum height of a slice */
    INT16 outht;		/* height of a slice */
    INT16 outlen;		/* number of words in slice */

    /* figure number of words in image */
    nwords = (wd+15)/16;
    nwords = ht*nwords;
    nbytes = nwords + nwords;

    if (saving) { JOURNL(V_MIMAGE);
		  JOURNL(wd);
		  JOURNL(ht);
		  JOURNL(nbytes);
		  write(savefile,data,nbytes);
		}

    /* figure number of words in a scanline */
    nwords = (wd+15)/16;
    maxht = 2000/nwords;

    fullht = ht;  /* record height for ending move */

    /* process image in slices until done */
    while (ht > 0) begin
      /* figure height of slice */
      outht = min(ht,maxht);
      outlen = outht*nwords;

      /* make room for image order */
      clear(3+outlen);

      /* build image order */
      vikint[vikoff++] = 9;	/* draw image */
      vikint[vikoff++] = wd;	/* slice width */
      vikint[vikoff++] = outht; /* slice height */

      copy(data,outlen);   /* place in buffer */

      data += outlen;

      /* position for next buffer */
      VI_RMove(0,outht);   /* down by slice height */

      ht = ht-outht;
    end;

    /* move back to top of image */
    VI_RMove(0,-fullht);
  end

/*--------------------------------------------------------------*/
/*  Draw image from file					*/
/*--------------------------------------------------------------*/

VI_FImage(name)
  char *name;			/* name of image file */

  begin
#include "whimdcl.h"
    INT16 wd,ht;			/* image dimensions */
    INT16 fullht;		/* full height of image */
    INT16 nwords;		/* number of words in image scanline */
    INT16 maxht;			/* maximum height of a slice */
    INT16 outht;			/* height of a slice */
    INT16 outlen;		/* number of words in slice */
    INT_PURE image;			/* image file descriptor */

    if (saving) { JOURNL(V_FIMAGE);
		  strjour(name);}

    /* open the image file */
    image = open(name,BREAD);
    if (image == -1) { fprintf(stderr,"Error opening file %s\n",name);
		       return;
		     }

    /* get the width and height from the first two words */
    read(image,&wd,2);
    wd = wd;
    read(image,&ht,2);
    ht = ht;

    /* figure number of words in a scanline */
    nwords = (wd+15)/16;
    maxht = 2000/nwords;

    fullht = ht;  /* record height for ending move */

    /* process image in slices until done */
    while (ht > 0) begin
      /* figure height of slice */
      outht = min(ht,maxht);
      outlen = outht*nwords;

      /* make room for image order */
      clear(3+outlen);

      /* build image order */
      vikint[vikoff++] = 9;	 /* draw image */
      vikint[vikoff++] = wd;	 /* slice width */
      vikint[vikoff++] = outht;  /* slice height */

      /* copy image data */
      read(image,&vikint[vikoff],outlen*2);
      vikoff+= outlen;

      /* position for next buffer */
      VI_RMove(0,outht);   /* down by slice height */

      ht-= outht;
    end;

    /* move back to top of image */
    VI_RMove(0,-fullht);

    /* close image file */
    close(image);
  end
