/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:encrypt.c 12.1$ */
/* $ACIS:encrypt.c 12.1$ */
/* $Source: /ibm/acis/usr/sys/afs/RCS/encrypt.c,v $ */

#ifndef lint
static char *rcsid = "$Header:encrypt.c 12.1$";
#endif

/* all this just to get r.h */
#include "../h/types.h"
#include "../h/socket.h"
#include "../h/file.h"
#include "../h/stat.h"
#include "../netinet/in.h"
#include "../h/time.h"
#include "../rpc/types.h"
#include "../rpc/xdr.h"

#define R_INTERNALS	1
#include "../afs/osi.h"
#include "../afs/r.h"

void Encrypt(FromBuffer, ToBuffer, HowManyBytes, WhichKey)
char *FromBuffer;		/* Input string*/
char *ToBuffer;		/* Output string. Can be equal to input */
long  HowManyBytes;		/* The number of bytes FromBuffer.  */
struct r_encryptionKey *WhichKey;	/* The encryption key to be used. */ {

/* Does a trivial Exclusive-OR of FromBuffer, cycling through  bytes in Key.
*/
    
    register unsigned char *p, *q, *r, *s;
    register long i;
    
    p = (unsigned char *)FromBuffer;		/* ptr to next input char */
    q = (unsigned char *)WhichKey;		/* ptr to next key char */
    r = q + RKEYSIZE;			/* right limit of q */
    s = (unsigned char *)ToBuffer;		/* ptr to next output char */
    for (i = HowManyBytes; i > 0; i--) {
	*s++ = (*p++) ^ (*q);
	if (++q >= r) q = (unsigned char *)WhichKey;
    }
}

void Decrypt(FromBuffer, ToBuffer,  HowManyBytes, WhichKey)
char *FromBuffer;		/* Input string */
char *ToBuffer;		/* Output string. Can be equal to input */
long  HowManyBytes;	/* The number of bytes in Buffer */
struct r_encryptionKey *WhichKey;	/* The decryption key to be used */
{
    Encrypt(FromBuffer, ToBuffer, HowManyBytes, WhichKey);
}
