/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:rvice.h 12.0$ */
/* $ACIS:rvice.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/afsint/RCS/rvice.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidrvice = "$Header:rvice.h 12.0$";
#endif


struct ViceFid {
	u_long Volume;
	u_long Vnode;
	u_long Unique;
};
typedef struct ViceFid ViceFid;


struct AFSFid {
	u_long Volume;
	u_long Vnode;
	u_long Unique;
};
typedef struct AFSFid AFSFid;


typedef long ViceDataType;

#define Invalid 0
#define File 1 
#define Directory 2 
#define SymbolicLink 3 

struct BD {
	long host;
	long portal;
	long session;
};
typedef struct BD BD;


struct RBD {
	long host;
	long portal;
	long session;
};
typedef struct RBD RBD;


struct ViceStatus {
	u_long InterfaceVersion;
	long VnodeType;
	long LinkCount;
	u_long Length;
	u_long DataVersion;
	u_long Date;
	u_long Author;
	u_long Owner;
	u_long CallBackTime;
	u_long MyAccess;
	u_long AnyAccess;
	u_long Mode;
};
typedef struct ViceStatus ViceStatus;


struct AFSFetchStatus {
	u_long InterfaceVersion;
	u_long FileType;
	u_long LinkCount;
	u_long Length;
	u_long DataVersion;
	u_long Author;
	u_long Owner;
	u_long CallerAccess;
	u_long AnonymousAccess;
	u_long UnixModeBits;
	u_long ParentVnode;
	u_long ParentUnique;
	u_long SegSize;
	u_long ClientModTime;
	u_long ServerModTime;
	u_long Group;
};
typedef struct AFSFetchStatus AFSFetchStatus;


struct AFSStoreStatus {
	u_long Mask;
	u_long ClientModTime;
	u_long Owner;
	u_long Group;
	u_long UnixModeBits;
	u_long SegSize;
};
typedef struct AFSStoreStatus AFSStoreStatus;

#define	AFS_SETMODTIME	0x1
#define	AFS_SETOWNER	0x2
#define	AFS_SETGROUP		0x4
#define	AFS_SETMODE		0x8
#define	AFS_SETSEGSIZE	0x10

struct AFSCallBack {
	u_long CallBackVersion;
	u_long ExpirationTime;
	u_long CallBackType;
};
typedef struct AFSCallBack AFSCallBack;

#define	EXCLUSIVE	1
#define	SHARED	2
#define	DROPPED	3


typedef long ViceVolumeType;

#define ReadOnly 0
#define ReadWrite 1

typedef char DiskName[32];


struct ViceDisk {
	long BlocksAvailable;
	long TotalBlocks;
	DiskName Name;
};
typedef struct ViceDisk ViceDisk;


struct ViceStatistics {
	u_long CurrentMsgNumber;
	u_long OldestMsgNumber;
	u_long CurrentTime;
	u_long BootTime;
	u_long StartTime;
	long CurrentConnections;
	u_long TotalViceCalls;
	u_long TotalFetchs;
	u_long FetchDatas;
	u_long FetchedBytes;
	long FetchDataRate;
	u_long TotalStores;
	u_long StoreDatas;
	u_long StoredBytes;
	long StoreDataRate;
	u_long TotalRPCBytesSent;
	u_long TotalRPCBytesReceived;
	u_long TotalRPCPacketsSent;
	u_long TotalRPCPacketsReceived;
	u_long TotalRPCPacketsLost;
	u_long TotalRPCBogusPackets;
	long SystemCPU;
	long UserCPU;
	long NiceCPU;
	long IdleCPU;
	long TotalIO;
	long ActiveVM;
	long TotalVM;
	long EtherNetTotalErrors;
	long EtherNetTotalWrites;
	long EtherNetTotalInterupts;
	long EtherNetGoodReads;
	long EtherNetTotalBytesWritten;
	long EtherNetTotalBytesRead;
	long ProcessSize;
	long WorkStations;
	long ActiveWorkStations;
	long Spare1;
	long Spare2;
	long Spare3;
	long Spare4;
	long Spare5;
	long Spare6;
	long Spare7;
	long Spare8;
	ViceDisk Disk1;
	ViceDisk Disk2;
	ViceDisk Disk3;
	ViceDisk Disk4;
	ViceDisk Disk5;
	ViceDisk Disk6;
	ViceDisk Disk7;
	ViceDisk Disk8;
	ViceDisk Disk9;
	ViceDisk Disk10;
};
typedef struct ViceStatistics ViceStatistics;


struct VolumeStatus {
	long Vid;
	long ParentId;
	char Online;
	char InService;
	char Blessed;
	char NeedsSalvage;
	long Type;
	long MinQuota;
	long MaxQuota;
	long BlocksInUse;
	long PartBlocksAvail;
	long PartMaxBlocks;
};
typedef struct VolumeStatus VolumeStatus;


struct VolumeInfo {
	u_long Vid;
	long Type;
	u_long Type0;
	u_long Type1;
	u_long Type2;
	u_long Type3;
	u_long Type4;
	u_long ServerCount;
	u_long Server0;
	u_long Server1;
	u_long Server2;
	u_long Server3;
	u_long Server4;
	u_long Server5;
	u_long Server6;
	u_long Server7;
};
typedef struct VolumeInfo VolumeInfo;


typedef long ViceFetchType;

#define FetchNoData 0
#define FetchData 1

typedef long ViceStoreType;

#define StoreNeither 0
#define StoreData 1
#define StoreStatus 2
#define StoreStatusData 3

typedef long ViceLockType;

#define LockRead 0
#define LockWrite 1

typedef long ViceOfflineType;

#define NoSalvage 0
#define Salvage 1
#define	FIDS_MAXSIZE			50
#define	FIDS_ARRAY_MAXSIZE		50
#define	CALLBACKS_ARRAY_MAXSIZE	50

struct CBS {
	long SeqLen;
	char *SeqBody;
};
typedef struct CBS CBS;


struct BBS {
	long MaxSeqLen;
	long SeqLen;
	char *SeqBody;
};
typedef struct BBS BBS;


struct AFSAccessList {
	long MaxSeqLen;
	long SeqLen;
	char *SeqBody;
};
typedef struct AFSAccessList AFSAccessList;

bool_t xdr_ViceFid();
bool_t xdr_AFSFid();
bool_t xdr_ViceDataType();
bool_t xdr_BD();
bool_t xdr_RBD();
bool_t xdr_ViceStatus();
bool_t xdr_AFSFetchStatus();
bool_t xdr_AFSStoreStatus();
bool_t xdr_AFSCallBack();
bool_t xdr_ViceVolumeType();
bool_t xdr_DiskName();
bool_t xdr_ViceDisk();
bool_t xdr_ViceStatistics();
bool_t xdr_VolumeStatus();
bool_t xdr_VolumeInfo();
bool_t xdr_ViceFetchType();
bool_t xdr_ViceStoreType();
bool_t xdr_ViceLockType();
bool_t xdr_ViceOfflineType();
bool_t xdr_CBS();
bool_t xdr_BBS();
bool_t xdr_AFSAccessList();
