; USC-ACSC OS/2 Monitor: $Header:as.asm 12.1$
;
; 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1987,1988
; LICENSED MATERIALS - PROPERTY OF IBM
; REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
;
;
; Copyright University of Southern California, 1988
; $Header:as.asm 12.1$
; $ACIS:as.asm 12.1$
;
;***********************************************
;
;    Assembler routines for use by the PC Code 
;
;

        TITLE   AS.ASM
;       .286


_TEXT   SEGMENT  BYTE PUBLIC 'CODE'
_TEXT   ENDS

_IOCODE SEGMENT  BYTE PUBLIC 'IOCODE'
	EXTRN	ZYP_Service_Entry:far
	EXTRN	ZYPHER_Main:far
	EXTRN	ZYP_Reset_Entry:far
_IOCODE ENDS

_DATA   SEGMENT WORD PUBLIC 'DATA'
_DATA   ENDS

CONST   SEGMENT  WORD PUBLIC 'CONST'
CONST   ENDS

_BSS    SEGMENT  WORD PUBLIC 'BSS'
_BSS    ENDS

_UB_RAM	SEGMENT WORD PUBLIC
_UB_RAM	ENDS

DGROUP  GROUP   CONST,  _BSS,   _DATA
        ASSUME  CS: _TEXT, DS: DGROUP, SS: DGROUP, ES: DGROUP

PARAM1  EQU 4                      ; Small model
PARAM2  EQU   PARAM1 + 2
PARAM3  EQU   PARAM1 + 4
PARAM4  EQU   PARAM1 + 6
PARAM5  EQU   PARAM1 + 8
PARAM6  EQU   PARAM1 + 10
PARAM7  EQU   PARAM1 + 12
PARAM8  EQU   PARAM1 + 14
PARAM9  EQU   PARAM1 + 16

_TEXT   SEGMENT
	PUBLIC	_pcif_copy
        PUBLIC  _exchw
	PUBLIC	_exchl
	PUBLIC	_inp
	PUBLIC	_outp
	PUBLIC	_outw
	PUBLIC	_cli
	PUBLIC	_sti
	PUBLIC	_fci
	PUBLIC	_run_fci_main
	PUBLIC	_reset_ub_card

;*********************************************************
;
; pcif_copy(addr1,addr2,count) - fast copy, copies count bytes from
;					addr1 to addr2 (far pointers)
;	char	far *addr1,far *addr2;
;	unsigned	count;
;
_pcif_copy	PROC	near
		push	BP
		mov	BP,SP
		push	SI
		push	DI
		mov	bx,DS
		lDS	SI,PARAM1[BP]	;addr1 (source = DS:[SI])
		lES	DI,PARAM3[BP]	;addr2 (dest = ES:[DI])
		mov	CX,PARAM5[BP]	; count ( = CX);
		cld			; clear the direction flag
		clc
		ror	cx,1
		rep	movsw
		jnc	copy_done
		movsb
copy_done:
		mov	DS,BX
		pop	DI
		pop	SI
		pop	BP
		ret
_pcif_copy	ENDP

;*********************************************************
;
; long exchl(val)   - swap bytes within the lower and upper half
;      long val;      of a long, then swap the upper and lower
;                     words
;
; Returns long values in AX DX
;
;

_exchl	PROC	NEAR
        push    BP
        mov     BP,SP
        mov     AX,[BP+PARAM1]
        mov     DX,[BP+PARAM2]
        xchg    AL,AH
        xchg    DL,DH
        xchg    AX,DX
        mov     SP,BP
        pop     BP
        ret
_exchl  ENDP

_exchw	PROC	NEAR
        PUSH    BP
        MOV     BP,SP

        MOV     AX,[BP+PARAM1]
        XCHG    AL,AH

        MOV     SP,BP
        POP     BP
        RET
_exchw  ENDP

;
; write out a word
; NOTE: for the next four functions, PARAMx is off by one because
; there is no stack frame.
;
_outw	PROC	NEAR
	MOV	BX,SP
	MOV	DX,SS:[BX+PARAM1-2]	; address (far call parameter 1)
	MOV	AX,SS:[BX+PARAM2-2]	; data (far call parameter 2)
	CALL	far ptr outw
	RET
_outw	ENDP
;
; write out a byte
;
_outp	PROC	NEAR
	MOV	BX,SP
	MOV	DX,SS:[BX+PARAM1-2]		; address (far call parameter 1)
	MOV	AX,SS:[BX+PARAM2-2]		; data (far call parameter 2)
	CALL	far ptr outp
	RET
_outp	ENDP
;
; read in a byte
;
_inp	PROC	NEAR
	MOV	BX,SP
	MOV	DX,SS:[BX+PARAM1-2]		; address (far call parameter 1)
	XOR	AX,AX
	CALL	far ptr inp
	RET
_inp	ENDP
;
; read in a word
;
_inw	PROC	NEAR
	MOV	BX,SP
	MOV	DX,SS:[BX+PARAM1-2]		; address (far call parameter 1)
	CALL	far ptr inw
	RET
_inw	ENDP

_cli	PROC	NEAR
	CALL	far ptr clip
	RET
_cli	ENDP

_sti	PROC	NEAR
	CALL	far ptr stip
	RET
_sti	ENDP

; ***************************************************************************
; FCI Service Entry
; Call: fci(rom_selector, ram_selector, zcb_selector, zcb_offset);
; bp + ->	4		6		8	10
; ***************************************************************************
_fci	PROC	NEAR
	push	bp
	mov	bp, sp

	push	ds
	push	bx
	push	es
	mov	ax, WORD PTR [bp+6]	; RAM selector
	mov	bx, ds			; save our ds temporarily
	mov	ds, ax			; point to RAM

	; write our ds at RAM 4 so that we can access _DATA from
	; the FCI code
	push	si
	xor	si, si
	mov	WORD PTR [si+4], bx
	; write the ROM selector at RAM 2 so that we can copy the
	; ethernet address from the ROM to the RAM
	mov	ax, WORD PTR [bp+4]
	mov	WORD PTR [si+2], ax
	pop	si

	; set up es
	mov	ax, WORD PTR [bp+8]
	mov	es, ax
	; set up bx
	mov	bx, WORD PTR [bp+10] 
	cld				; clear direction flag

	call	FAR PTR	ZYP_Service_Entry

	pop	es
	pop	bx
	pop	ds
	xor	ax, ax

	mov	sp, bp
	pop	bp
	ret
_fci	ENDP

; ***************************************************************************
; This function runs the fci interface for a given card
; Call: run_fci_main(rom_selector, ram_selector);
; bp + ->		4		6		
; ***************************************************************************
_run_fci_main	PROC	near
		push	bp
		mov	bp, sp

		push	ds
		push	es
		push	bx

		mov	ax, WORD PTR [bp+6]	; RAM selector
		mov	bx, ds			; save ds in bx
		mov	ds, ax			; point to RAM
		mov	es, ax			; Point es to RAM too

		; write our ds at RAM 4 so that we can access _DATA from
		; the FCI code
		push	si
		xor	si, si
		mov	WORD PTR [si+4], bx
		; write the ROM selector at RAM 2 so that we can copy the
		; ethernet address from the ROM to the RAM
		mov	ax, WORD PTR [bp+4]
		mov	WORD PTR [si+2], ax
		pop	si

		cld				; clear direction flag

		push	bp
		call	FAR PTR	ZYPHER_Main
		pop	bp

		pop	bx
		pop	es
		pop	ds

		mov	sp, bp
		pop	bp
		ret
_run_fci_main	ENDP

; ***************************************************************************
; Reset a ub card.
; Call: reset_ub_card(ram_selector);
; ***************************************************************************
_reset_ub_card	PROC	near
		push	bp
		mov	bp, sp

		push	ds
		mov	ax, WORD PTR [bp+4]	; RAM selector
		mov	ds, ax			; point to RAM
		cld				; clear direction flag

		call	FAR PTR	ZYP_Reset_Entry

		pop	ds
		xor	ax, ax

		mov	sp, bp
		pop	bp
		ret
_reset_ub_card	ENDP

_TEXT   ENDS

; ***************************************************************************
_IOCODE	SEGMENT
        ASSUME  CS: _IOCODE, DS: DGROUP, SS: DGROUP, ES: DGROUP
;
outw	PROC	FAR
	OUT	DX,AX
	JMP	SHORT $+2
	RET
outw	ENDP
;
outp	PROC	FAR
	OUT	DX,AL
	JMP	SHORT $+2
	RET
outp	ENDP
;
inw	PROC	FAR
	IN	AX,DX
	JMP	SHORT $+2
	RET
inw	ENDP
;
inp	PROC	FAR
	IN	AL,DX
	JMP	SHORT $+2
	RET
inp	ENDP
;
clip	PROC	FAR
	CLI
	RET
clip	ENDP
;
stip	PROC	FAR
	STI
	RET
stip	ENDP

_IOCODE  ENDS
        END
