/*
 * USC-ACSC UNIX Monitor
 *
 * $Header:sem.h 12.1$
 * $ACIS:sem.h 12.1$
 * $Source: /ibm/acis/usr/sys/os2code/RCS/sem.h,v $
 * Copyright University of Southern California, 1988
 */

/* Header file for Semaphores and shared segments */

#define GETSHAREDSEG(name,sel)	while(DOSGETSHRSEG(name,&(sel)) ) \
					DOSSLEEP(1000L)

#define GETSEGPTR(seg,off)	((char far *)(((unsigned long) seg << 16) \
						 + (unsigned) (off)))

#define WAIT(sem)	DOSSEMREQUEST((unsigned long)((long far *)&(sem)),-1L)
#define SIGNAL(sem)	DOSSEMCLEAR((unsigned long)((long far *)&(sem)))

#define ENTER_CS()	DOSENTERCRITSEC()
#define EXIT_CS()	DOSEXITCRITSEC()

#define SEM_SHARED 	1	/* shared between processes */
#define RAM_SEM(sem) ((unsigned long) (long far *) & sem)
