/*
 * USC-ACSC UNIX Monitor: $Header: pos.c,v 1.2 88/12/08 09:29:02 relyea Exp $
 * Copyright University of Southern California, 1988
 */

/*
 * This file contains code that reads the POS (Programmable Option Select)
 * information out of the static RAM in the PS/2.
 */
#ifdef DOS
#include "pcparam.h"
#endif

#include "rb.h"

/* Adapter POS data structure */
struct pos_data slot[NO_PS_2_SLOTS];

int
get_adapter_pos()
{
	int	i,j;
	int	ncpu = 0;

	cli(); 	/* disable the interrupt while we are accessing the POS data */
	
	/* disable VGA and system board set up signals */
	outp(0x94, 0xff);

	/* read in the POS data from each slot */
	for( i=0; i<NO_PS_2_SLOTS; i++) {
		/* enable the adapter POS set up */
		outp(0x96, 0x08 + i);
		for( j=0; j< 8; j++) {
			slot[i].pos[j] = inp(0x100+j);
		}
		if ((slot[i].pos[0] == 0xf7) && (slot[i].pos[1] == 0x8f)) {
			ncpu++;
		} 
	}
	
	/* disable the adapter setup before return */
	outp(0x96,0);

	sti();	/* enable the interrupt */

#ifdef POS_DEBUG
	/* print out the POS data */
	for( i=0; i<NO_PS_2_SLOTS; i++) {
		printf(" SLOT %d: ",i);
		for( j=0; j< 8; j++) {
			printf(" %02x ", (unsigned short) slot[i].pos[j]);
		}
		printf("\n");
	}	
	printf("There are %d cpu(s)\n",ncpu);
#endif
	return(ncpu);
	
}
