/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:tape.h 12.0$ */
/* $ACIS:tape.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/pc_code/RCS/tape.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidtape = "$Header:tape.h 12.0$";
#endif

#define TAPE_NAME	"TAPE"		/* string to check for */
#define MAXDRIVES 4			/* max number of drives supported */
#define MAXWORK	64			/* work area size */
#define MAXEXTRA 64			/* expansion size */
#define MAXTAPEMSG	80		/* max errmsg length */
#define MAXFILENAME	255		/* max length of filename */

struct tapeinfo {
	u_short	op;			/* op code */
#define TAPE_IDLE	0		/* driver not busy */
#define TAPE_INIT	1		/* initialize driver */
#define TAPE_TERM	2		/* terminate driver */
#define TAPE_OPEN	3		/* open file on tape */
#define TAPE_CLOSE	4		/* close file on tape */
#define TAPE_READ	5		/* read file on tape */
#define TAPE_IOCTL	6		/* control function (see info) */
#define TAPE_NOP	7		/* do nothing */
#define TAPE_WAIT	8		/* wait for async operation (optional) */
#define TAPE_WRITE	9		/* tape write */
	u_short	drive;			/* driver number (0-3) */
	char far *buffer;		/* buffer (also file name where appropriate */
	u_long	block;			/* block number */
	void huge * (far *alloc)	/* space allocator (like halloc) */
		(long,u_short);		/*	 (long*u_short) bytes */
	void (far *free)(void huge *);	/* space free */
	void (far *done) (/* struct tapeinfo far * */);
					/* async completion (optional) */
	u_long	time;			/* date/time in seconds since 1970 (optional) */
	long	size;			/* size of current file (optional) */
	char far *errmsg;		/* error message ptr (if not NULL) */
	u_short	count;			/* count (number blocks to xfer etc.) */
	u_short	xcount;			/* amount actually transfered */
	u_short blocksize;		/* number of bytes/block (set by initialize) */
	u_short	maxcount;		/* max number of blocks per xfer ( " " " ) */
	u_short	info;			/* additional info for open etc */
	u_short	errno;			/* error number */
	u_short	rc;			/* return code */
#define TAPE_RC_OK	0		/* operation done ok */
#define TAPE_RC_ERROR	1		/* operation failed */
#define TAPE_RC_BUSY	2		/* operation in progress */
	u_short	status;			/* tape status */
#define TAPE_BOT	0x01		/* tape is at BOT */
#define TAPE_READY	0x02		/* tape drive is READY */
#define TAPE_CHANGE	0x04		/* tape cartridge changed */
#define TAPE_WRTPROT	0x08		/* tape is write protected */
#define TAPE_EOT	0x10		/* tape is at EOT */
	char	extra[MAXEXTRA];	/* room for expansion */
	char	work[MAXWORK];		/* driver work area */
};

/* OPEN type codes (open sub-function passed in "info") */
#define TAPE_OPEN_READ	1
#define TAPE_OPEN_WRITE	2
#define TAPE_OPEN_RW	3

/* IOCTL's (ioctl sub-function passed in "info") */
#define TAPE_REWIND	1
#define TAPE_RETENTION	2
#define TAPE_ERASE	3
#define TAPE_FORMAT	4
#define TAPE_GET_STATUS	5
#define TAPE_FIND_FIRST	6
#define TAPE_FIND_NEXT	7
#define TAPE_DELETE	8

#define FIRST_USER_INT 0x60
#define LAST_USER_INT 0x67
