/* $Header:ls.c 12.0$ */
/* $ACIS:ls.c 12.0$ */
/* $Source: /ibm/acis/usr/sys/standca/RCS/ls.c,v $ */

#ifndef lint
static char *rcsid = "$Header:ls.c 12.0$";
#endif

/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986,1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/*	ls.c	6.1	83/07/29	*/
#ifdef STANDALONE
#include "param.h"
#include "dir.h"
#define perror(x) printf("perror:%s\n", x)
#else
#include "sys/param.h"
#include "sys/dir.h"
#endif

main(argc, argv)
	char **argv;
{
	int j;
	char *line;
	char buff[512];

	for (j = 1; j < argc; ++j) {
		line = argv[j];
		dols(line);
	}
	if (argc < 2)
		for (;;) {
			printf("Directory: ");
			gets(buff);
			if (buff[0] == 0)
				break;
			dols(buff);
		}
}


dols(line)
	register char *line;
{
	int i;
	printf("ls of %s\n", line);
	i = open(line, 0);
	if (i < 0)
		perror(line);
	else {
		ls(i);
		close(i);
	}
}


ls(io)
	register io;
{
	struct direct *d;
	char buff[DIRBLKSIZ];
	register i, l;

	while ((l = read(io, buff, DIRBLKSIZ)) > 0) {
		if (l != DIRBLKSIZ)
			printf("warning: got read of %d bytes instead of %d\n",
			    l, DIRBLKSIZ);
		for (i = 0; i < l; i += d->d_reclen) {
			d = (struct direct *)(buff + i);
			if (d->d_reclen <= 0) {
				printf("help reclen=%d\n", d->d_reclen);
				exit(1);
			}
			if (d->d_ino == 0 || d->d_namlen == 0)
				continue;
			printf("%d\t", d->d_ino);
			printf("%s", d->d_name);
			printf("\n");
		}
	}
	if (l < 0)
		perror("got error on directory read");
}
