/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:kern_exec.c 12.0$ */
/* $ACIS:kern_exec.c 12.0$ */
/* $Source: /ibm/acis/usr/sys/sys/RCS/kern_exec.c,v $ */

#if !defined(lint) && !defined(NO_RCS_HDRS)
static char *rcsid = "$Header:kern_exec.c 12.0$";
#endif

/* 
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)kern_exec.c	7.1 (Berkeley) 6/5/86
 */

#include "../machine/reg.h"
#include "../machine/pte.h"
#ifndef ibm032
#include "../machine/psl.h"
#else
#include "../machine/scr.h"
#endif

#include "param.h"
#include "systm.h"
#include "map.h"
#include "dir.h"
#include "user.h"
#include "kernel.h"
#include "proc.h"
#include "buf.h"
#ifndef VFS
#include "inode.h"
#else !VFS
#include "socketvar.h"
#include "vnode.h"
#include "pathname.h"
#endif !VFS
#include "seg.h"
#include "vm.h"
#include "text.h"
#include "file.h"
#include "uio.h"
#include "acct.h"
#include "exec.h"
#if     defined(ibm032)
#include "../machine/debug.h"
#endif  /* defined(ibm032) */
#ifdef VFS
#include "../h/vfs.h"
#endif VFS

#ifdef vax
#include "../vax/mtpr.h"
#endif
#if     defined(ibm370)
#include "../ibm370/frame.h"
#endif  /* defined(ibm370) */

#ifdef VFS
/*
 * texts below this size will be read in (if there is enough free memory)
 * even though the file is ZMAGIC
 */
size_t pgthresh = clrnd(btoc(PGTHRESH));

#endif VFS
/* 
 * exec system call, with and without environments.
 */
struct execa {
	char	*fname;
	char	**argp;
	char	**envp;
};

execv()
{
	((struct execa *)u.u_ap)->envp = NULL;
	execve();
}

#ifdef ibm032

long min_zsize = 0;

exect() /* New RXTUnix system call for execve with single step active */
{
        execve();
        if( u.u_error );
        else u.u_ar0[ICSCS] |= ICSCS_INSTSTEP;
}

ushort	wargmap = 0;	/* # procs waiting on argmap allocation */

#endif ibm032

execve()
{
	register nc;
	register char *cp;
	register struct buf *bp;
	register struct execa *uap;
	int na, ne, ucp, ap, cc;
	unsigned len;
	int indir, uid, gid;
	char *sharg;
#ifndef VFS
	struct inode *ip;
#ifdef VICE
	struct file *fp;
#endif
#else !VFS
	char *execnamep;
	struct vnode *vp;
	struct vattr vattr;
	struct pathname pn, tpn;
#endif !VFS
	swblk_t bno;
	char cfname[MAXCOMLEN + 1];
#define	SHSIZE	32
	char cfarg[SHSIZE];
	union {
		char	ex_shell[SHSIZE];	/* #! and name of interpreter */
		struct	exec ex_exec;
	} exdata;
#ifndef VFS
	register struct nameidata *ndp = &u.u_nd;
#endif !VFS
	int resid, error;

#ifndef VFS
#ifdef VICE
	indir = 0;
	ndp->ni_dirp = ((struct execa *)u.u_ap)->fname;
again:
	ndp->ni_nameiop = LOOKUP | FOLLOW;
	ndp->ni_segflg = indir? UIO_SYSSPACE : UIO_USERSPACE;
	if ((fp = fnamei(ndp, 0, 1)) == NULL)
		return;
	ip = (struct inode *) fp->f_data;
	ip->i_count++;		/* To reflect the fact that fp points to the inode also */
#else
	ndp->ni_nameiop = LOOKUP | FOLLOW;
	ndp->ni_segflg = UIO_USERSPACE;
	ndp->ni_dirp = ((struct execa *)u.u_ap)->fname;
	if ((ip = namei(ndp)) == NULL)
		return;
	bno = 0;
	bp = 0;
	indir = 0;
#endif
#ifdef VICE
	if (!indir) {
#endif
#else !VFS
	uap = (struct execa *)u.u_ap;
	u.u_error = pn_get(uap->fname, UIO_USERSPACE, &pn);
	if (u.u_error) {
		return;
	}
	u.u_error = lookuppn(&pn, FOLLOW_LINK, (struct vnode **)0, &vp);
	if (u.u_error) {
		pn_free(&pn);
		return;
	}
	bno = 0;
	bp = 0;
	indir = 0;
#endif !VFS
	uid = u.u_uid;
	gid = u.u_gid;
#ifndef VFS
	if (ip->i_mode & ISUID)
		uid = ip->i_uid;
	if (ip->i_mode & ISGID)
		gid = ip->i_gid;

#ifdef VICE
	bno = 0;
	bp = 0;
	}
#else
  again:
#endif
#ifdef VICE
	if (fp->f_type == DTYPE_INODE) {
#endif
	if (access(ip, IEXEC))
		goto bad;
	if ((u.u_procp->p_flag&STRC) && access(ip, IREAD))
		goto bad;
	if ((ip->i_mode & IFMT) != IFREG ||
	   (ip->i_mode & (IEXEC|(IEXEC>>3)|(IEXEC>>6))) == 0) {
		u.u_error = EACCES;
		goto bad;
	}
#ifdef VICE
	}
#endif
#else !VFS
	if (u.u_error = VOP_GETATTR(vp, &vattr, u.u_cred))
		goto bad;
	if ((vp->v_vfsp->vfs_flag & VFS_NOSUID) == 0) {
		if (vattr.va_mode & VSUID)
			uid = vattr.va_uid;
		if (vattr.va_mode & VSGID)
			gid = vattr.va_gid;
#ifndef VFS
	} else {
#else !VFS
	} else if ((vattr.va_mode & VSUID) || (vattr.va_mode & VSGID)) {
#endif !VFS
		struct pathname tmppn;
		u.u_error = pn_get(uap->fname, UIO_USERSPACE, &tmppn);
		if (u.u_error)
#ifndef VFS
			return;
#else !VFS
			goto bad; /* this used to be return; this causes a
					pn_free when pn_get fails  */
#endif !VFS
		printf("%s: Setuid execution not allowed\n", tmppn.pn_buf);
		pn_free(&tmppn);
	}
again:
	/*
	 * XXX should change VOP_ACCESS to not let super user always have it
	 * for exec permission on regular files.
	 */
	if (u.u_error = VOP_ACCESS(vp, VEXEC, u.u_cred))
		goto bad;
	if ((u.u_procp->p_flag&STRC)
		&& (u.u_error = VOP_ACCESS(vp, VREAD, u.u_cred)))
			goto bad;
	if (vp->v_type != VREG ||
		(vattr.va_mode & (VEXEC|(VEXEC>>3)|(VEXEC>>6))) == 0) {
		u.u_error = EACCES;
		goto bad;
	}
#endif !VFS
	/* 
	 * Read in first few bytes of file for segment sizes, magic number:
	 *	407 = plain executable
	 *	410 = RO text
	 *	413 = demand paged RO text
	 * Also an ASCII line beginning with #! is
	 * the file name of a ``shell'' and arguments may be prepended
	 * to the argument list if given here.
	 *
	 * SHELL NAMES ARE LIMITED IN LENGTH.
	 *
	 * ONLY ONE ARGUMENT MAY BE PASSED TO THE SHELL FROM
	 * THE ASCII LINE.
	 */
	exdata.ex_shell[0] = '\0';	/* for zero length files */
#ifndef VFS
	u.u_error = rdwri(UIO_READ, ip, (caddr_t)&exdata, sizeof (exdata),
	    (off_t)0, 1, &resid);
#else !VFS
	u.u_error = vn_rdwr(UIO_READ, vp, (caddr_t)&exdata, sizeof (exdata),
	    0, UIO_SYSSPACE, IO_UNIT, &resid);
#endif !VFS
	if (u.u_error)
		goto bad;
#if !defined(lint)
	if (resid > sizeof(exdata) - sizeof(exdata.ex_exec) &&
	    exdata.ex_shell[0] != '#') {
		u.u_error = ENOEXEC;
		goto bad;
	}
#endif
	switch ((int)exdata.ex_exec.a_magic) {

	case 0407:
		exdata.ex_exec.a_data += exdata.ex_exec.a_text;
		exdata.ex_exec.a_text = 0;
		break;

	case 0413:
#if     defined(ibm370)
                u.u_error = ENOEXEC;    /* Current 370 version can't handle */
                goto bad;
#endif  /* defined(ibm370) */
	case 0410:
		if (exdata.ex_exec.a_text == 0) {
			u.u_error = ENOEXEC;
			goto bad;
		}
		break;

	default:
		if (exdata.ex_shell[0] != '#' ||
		    exdata.ex_shell[1] != '!' ||
		    indir) {
			u.u_error = ENOEXEC;
			goto bad;
		}
		cp = &exdata.ex_shell[2];		/* skip "#!" */
		while (cp < &exdata.ex_shell[SHSIZE]) {
			if (*cp == '\t')
				*cp = ' ';
			else if (*cp == '\n') {
				*cp = '\0';
				break;
			}
			cp++;
		}
		if (*cp != '\0') {
			u.u_error = ENOEXEC;
			goto bad;
		}
		cp = &exdata.ex_shell[2];
		while (*cp == ' ')
			cp++;
#ifndef VFS
		ndp->ni_dirp = cp;
#else !VFS
		execnamep = cp;
#endif !VFS
		while (*cp && *cp != ' ')
			cp++;
		cfarg[0] = '\0';
		if (*cp) {
			*cp++ = '\0';
			while (*cp == ' ')
				cp++;
			if (*cp)
				bcopy((caddr_t)cp, (caddr_t)cfarg, SHSIZE);
		}
		indir = 1;
#ifndef VFS
		iput(ip);
#ifdef VICE
		closef(fp);
#else
		ndp->ni_nameiop = LOOKUP | FOLLOW;
		ndp->ni_segflg = UIO_SYSSPACE;
		ip = namei(ndp);
		if (ip == NULL)
			return;
#endif
		bcopy((caddr_t)ndp->ni_dent.d_name, (caddr_t)cfname,
		    MAXCOMLEN);
		cfname[MAXCOMLEN] = '\0';
#ifdef UCBFIX
 /* This is UCBFIX 1.59, there are no other UCBFIX ifdef's in this file. */
 		uid = u.u_uid;		/* shell scripts can't be setuid */
 		gid = u.u_gid;
#endif UCBFIX
#else !VFS
		VN_RELE(vp);
		vp = (struct vnode *)0;
		if (u.u_error = pn_set(&pn, execnamep))
			goto bad;
		u.u_error = lookuppn(&pn, FOLLOW_LINK, (struct vnode **)0, &vp);
		if (u.u_error)
			goto bad;
		if (u.u_error = VOP_GETATTR(vp, &vattr, u.u_cred))
			goto bad;
#endif !VFS
		goto again;
	}

	/* 
	 * Collect arguments on "file" in swap space.
	 */
	na = 0;
	ne = 0;
	nc = 0;
	cc = 0;
	uap = (struct execa *)u.u_ap;
#ifdef	ibm032
	while ((bno = rmalloc(argmap, (long)ctod(clrnd((int)btoc(NCARGS))))) == 0) {
		wargmap++;
		sleep((caddr_t)argmap, PZERO - 1);
	}
#else	ibm032
#if     !defined(ibm370)
	bno = rmalloc(argmap, (long)ctod(clrnd((int)btoc(NCARGS))));
#else   /* !defined(ibm370) */
        bno = rmalloc(argmap, (long)1);
#endif  /* !defined(ibm370) */
	if (bno == 0) {
#if     !defined(ibm370)
		swkill(u.u_procp, "exec: no swap space");
#endif  /* !defined(ibm370) */
		goto bad;
	}
#endif	ibm032
#if     !defined(ibm370)
	if (bno % CLSIZE)
		panic("execa rmalloc");
#endif  /* !defined(ibm370) */
	/* 
	 * Copy arguments into file in argdev area.
	 */
	if (uap->argp) for (;;) {
		ap = NULL;
		sharg = NULL;
		if (indir && na == 0) {
#ifndef VFS
			sharg = cfname;
#else !VFS
			sharg = pn.pn_buf;
#endif !VFS
			ap = (int)sharg;
			uap->argp++;		/* ignore argv[0] */
		} else if (indir && (na == 1 && cfarg[0])) {
			sharg = cfarg;
			ap = (int)sharg;
		} else if (indir && (na == 1 || na == 2 && cfarg[0]))
			ap = (int)uap->fname;
		else if (uap->argp) {
			ap = fuword((caddr_t)uap->argp);
			uap->argp++;
		}
		if (ap == NULL && uap->envp) {
			uap->argp = NULL;
			if ((ap = fuword((caddr_t)uap->envp)) != NULL)
				uap->envp++, ne++;
		}
		if (ap == NULL)
			break;
		na++;
		if (ap == -1) {
			u.u_error = EFAULT;
			break;
		}
		do {
			if (cc <= 0) {
				/* 
				 * We depend on NCARGS being a multiple of
				 * CLSIZE*NBPG.  This way we need only check
				 * overflow before each buffer allocation.
				 */
				if (nc >= NCARGS-1) {
					error = E2BIG;
					break;
				}
#if     !defined(ibm370)
				if (bp)
					bdwrite(bp);
				cc = CLSIZE*NBPG;
#ifndef VFS
				bp = getblk(argdev, bno + ctod(nc/NBPG), cc);
#else !VFS
				bp = getblk(argdev_vp, (daddr_t)(bno + ctod(nc/NBPG)), cc);
#endif !VFS
				cp = bp->b_un.b_addr;
#else   /* !defined(ibm370) */
                                cc = NCARGS;
                                cp = amxtob(bno);
#endif  /* !defined(ibm370) */

			}
			if (sharg) {
				error = copystr(sharg, cp, (unsigned)cc, &len);
				sharg += len;
			} else {
				error = copyinstr((caddr_t)ap, cp, (unsigned)cc,
				    &len);
				ap += len;
			}
#if     defined(DEBUGF)
                        DEBUGF((svdebug&0x40) || (u.u_procp->p_flag & STRACE), strdebug(cp, len, ' '));
#endif  /* defined(DEBUGF) */
			cp += len;
			nc += len;
			cc -= len;
		} while (error == ENOENT);
		if (error) {
			u.u_error = error;
			if (bp)
				brelse(bp);
			bp = 0;
			goto badarg;
		}
	}
	if (bp)
		bdwrite(bp);
	bp = 0;
	nc = (nc + NBPW-1) & ~(NBPW-1);
#ifndef VFS
	getxfile(ip, &exdata.ex_exec, nc + (na+4)*NBPW, uid, gid);
#else !VFS
	getxfile(vp, &exdata.ex_exec, nc + (na+4)*NBPW, uid, gid);
#endif !VFS
	if (u.u_error) {
badarg:
#if     !defined(ibm370)
		for (cc = 0; cc < nc; cc += CLSIZE*NBPG) {
#ifndef VFS
			bp = baddr(argdev, bno + ctod(cc/NBPG), CLSIZE*NBPG);
#else !VFS
			bp = baddr(argdev_vp, (daddr_t)(bno + ctod(cc/NBPG)), CLSIZE*NBPG);
#endif !VFS
			if (bp) {
				bp->b_flags |= B_AGE;		/* throw away */
				bp->b_flags &= ~B_DELWRI;	/* cancel io */
				brelse(bp);
				bp = 0;
			}
		}
#endif  /* !defined(ibm370) */
		goto bad;
	}
#ifndef VFS
#ifdef VICE
        iput(ip);               /* This must happen before closef of 
				 * u.u_textfile, because it could
                                 * be the same inode (and it's locked here) */
        ip = NULL;
        if (u.u_textfile)
                closef(u.u_textfile);
        u.u_textfile = fp;
        fp = NULL;
#endif
#else !VFS
	VN_RELE(vp);
	vp = NULL;
#endif !VFS

	/* 
	 * Copy back arglist.
	 */
#ifndef ibm032
	ucp = USRSTACK - nc - NBPW;
#else ibm032
	ucp = USER_FPM - nc - NBPW;	/* Stack is right before FPM */
#endif ibm032
#if     !defined(ibm370)
	ap = ucp - na*NBPW - 3*NBPW;
	u.u_ar0[SP] = ap;
#else   /* !defined(ibm370) */
        ap = (ucp - na*NBPW - 3*NBPW) & ~0x07;  /* Downward double align */
        u.u_ar0[SP] = ap - (int) AP(0); /* User's args on stack */
#endif  /* !defined(ibm370) */
	(void) suword((caddr_t)ap, na-ne);
	nc = 0;
	cc = 0;
	for (;;) {
		ap += NBPW;
		if (na == ne) {
			(void) suword((caddr_t)ap, 0);
			ap += NBPW;
		}
		if (--na < 0)
			break;
		(void) suword((caddr_t)ap, ucp);
		do {
#if     !defined(ibm370)
			if (cc <= 0) {
				if (bp)
					brelse(bp);
				cc = CLSIZE*NBPG;
#ifndef VFS
				bp = bread(argdev, bno + ctod(nc / NBPG), cc);
#else !VFS
				bp = bread(argdev_vp, (daddr_t)(bno + ctod(nc / NBPG)), cc);
#endif !VFS
				bp->b_flags |= B_AGE;		/* throw away */
				bp->b_flags &= ~B_DELWRI;	/* cancel io */
				cp = bp->b_un.b_addr;
			}
#else   /* !defined(ibm370) */
                       if (dc <= 0) {
                                cp = amxtob(bno);
                                cc = NCARGS;
                        }
#endif   /* !defined(ibm370) */
			error = copyoutstr(cp, (caddr_t)ucp, (unsigned)cc,
			    &len);
			ucp += len;
			cp += len;
			nc += len;
			cc -= len;
		} while (error == ENOENT);
		if (error == EFAULT)
			panic("exec: EFAULT");
	}
	(void) suword((caddr_t)ap, 0);

	/* 
	 * Reset caught signals.  Held signals
	 * remain held through p_sigmask.
	 */
	while (u.u_procp->p_sigcatch) {
		nc = ffs((long)u.u_procp->p_sigcatch);
		u.u_procp->p_sigcatch &= ~sigmask(nc);
		u.u_signal[nc] = SIG_DFL;
	}
	/* 
	 * Reset stack state to the user stack.
	 * Clear set of signals caught on the signal stack.
	 */
	u.u_onstack = 0;
	u.u_sigsp = 0;
	u.u_sigonstack = 0;

	for (nc = u.u_lastfile; nc >= 0; --nc) {
#ifdef VFS
		register struct file *f;
		/* close all Close-On-Exec files */
#endif VFS
		if (u.u_pofile[nc] & UF_EXCLOSE) {
#ifndef VFS
			closef(u.u_ofile[nc]);
#else !VFS
			f = u.u_ofile[nc];
			/* Release all System-V style record locks, if any */
			(void) vno_lockrelease(f);
			closef(f);
#endif !VFS
			u.u_ofile[nc] = NULL;
			u.u_pofile[nc] = 0;
		}
		u.u_pofile[nc] &= ~UF_MAPPED;
	}
	while (u.u_lastfile >= 0 && u.u_ofile[u.u_lastfile] == NULL)
		u.u_lastfile--;
#ifndef ibm032
	setregs(exdata.ex_exec.a_entry);
#else
#ifndef VFS
#ifdef VICE
/*  KAZAR-RA: Note that this setregs call may close some files, and thus may
 *  be responsible for sending a message to venus.  To prevent deadlock, the iput
 *  done above must never be moved below this setregs call.  This happened in
 *  4.2 and I figured I'd better add this comment just in case someone tries it again.
 *  Mike Kazar -- CMU/ITC
 */
#endif
	setregs(exdata.ex_exec.a_entry,ndp->ni_dent.d_name);
#else !VFS
	setregs(exdata.ex_exec.a_entry,pn.pn_buf);
#endif !VFS
#endif
	/* 
	 * Remember file name for accounting.
	 */
	u.u_acflag &= ~AFORK;
	if (indir)
		bcopy((caddr_t)cfname, (caddr_t)u.u_comm, MAXCOMLEN);
	else {
#ifndef VFS
		if (ndp->ni_dent.d_namlen > MAXCOMLEN)
			ndp->ni_dent.d_namlen = MAXCOMLEN;
		bcopy((caddr_t)ndp->ni_dent.d_name, (caddr_t)u.u_comm,
		    (unsigned)(ndp->ni_dent.d_namlen + 1));
#else !VFS
		if (pn.pn_pathlen > MAXCOMLEN)
			pn.pn_pathlen = MAXCOMLEN;
		bcopy((caddr_t)pn.pn_buf, (caddr_t)u.u_comm,
			(unsigned)(pn.pn_pathlen + 1));
#endif !VFS
	}
#if defined(ibm370)
	cxacopy();
#endif
bad:
#ifdef VFS
	pn_free(&pn);
#endif VFS
	if (bp)
		brelse(bp);
	if (bno) {
#if     !defined(ibm370)
		rmfree(argmap, (long)ctod(clrnd((int) btoc(NCARGS))), bno);
#else   /* !defined(ibm370) */
                rmfree(argmap, (long)1, bno);
#endif  /* !defined(ibm370) */
#ifdef	ibm032
		if (wargmap) {
			wargmap = 0;
			wakeup((caddr_t)argmap);
		}
#endif	ibm032
	}
#ifndef VFS
	if (ip)
		iput(ip);
#ifdef VICE
	if (fp)
		closef(fp);
#endif
#else !VFS
	if (vp)
		VN_RELE(vp);
#endif !VFS
}

/* 
 * Read in and set up memory for executed file.
 */
#ifndef VFS
getxfile(ip, ep, nargc, uid, gid)
	register struct inode *ip;
#else !VFS
int execwarn = 1;

getxfile(vp, ep, nargc, uid, gid)
	register struct vnode *vp;
#endif !VFS
	register struct exec *ep;
	int nargc, uid, gid;
{
#ifndef VFS
	size_t ts, ds, ids, uds, ss;
#else !VFS
	register size_t ts, ds, ids, uds, ss;
#endif !VFS
	int pagi;
#ifndef VFS
#ifdef VICE
	long offset;		/* generic? */
#endif
#endif !VFS

	if (ep->a_magic == 0413
#ifdef ibm032
                && (ep->a_text + ep->a_data > min_zsize)
#endif
			)
		pagi = SPAGI;
	else
		pagi = 0;
#ifdef VICE
	/* KAZAR-RA */
	if (ip->i_flag & IFILLING) pagi = 0;
#endif
#ifndef VFS
	if (ip->i_text && (ip->i_text->x_flag & XTRC)) {
#else !VFS
	/*
	 * Check to make sure nobody is modifying the text right now
	 */
	if ((vp->v_flag & VTEXTMOD) != 0) {
#endif !VFS
		u.u_error = ETXTBSY;
		goto bad;
	}
#ifndef VFS
	if (ep->a_text != 0 && (ip->i_flag&ITEXT) == 0 &&
	    ip->i_count != 1) {
#else !VFS
	if ((ep->a_text != 0 && (vp->v_flag&VTEXT) ==0) &&
		(vp->v_count != 1)) {
#endif !VFS
		register struct file *fp;

		for (fp = file; fp < fileNFILE; fp++) {
#ifndef VFS
#ifdef VICE
			if ((fp->f_type == DTYPE_INODE || fp->f_type == DTYPE_REMOTE) &&
#else
			if (fp->f_type == DTYPE_INODE &&
#endif
#else !VFS
			if (fp->f_type == DTYPE_VNODE &&
#endif !VFS
			    fp->f_count > 0 &&
#ifndef VFS
			    (struct inode *)fp->f_data == ip &&
#ifdef VICE
			    /* KAZAR-RA */
			    ((fp->f_flag&FWRITE) && !(fp->f_flag & FFILL))) {
#else
			    (fp->f_flag&FWRITE)) {
#endif
#else !VFS
			    (struct vnode *)fp->f_data == vp &&
			    (fp->f_flag&FWRITE)) {
#endif !VFS
				u.u_error = ETXTBSY;
				goto bad;
			}
		}
	}

	/* 
	 * Compute text and data sizes and make sure not too large.
	 * NB - Check data and bss separately as they may overflow 
	 * when summed together.
	 */
	ts = clrnd(btoc(ep->a_text));
	ids = clrnd(btoc(ep->a_data));
	uds = clrnd(btoc(ep->a_bss));
	ds = clrnd(btoc(ep->a_data + ep->a_bss));
	ss = clrnd(SSIZE + btoc(nargc));
	if (chksize((unsigned)ts, (unsigned)ids, (unsigned)uds, (unsigned)ss))
		goto bad;

	/*
	 * Make sure enough space to start process.
	 */
	u.u_cdmap = zdmap;
	u.u_csmap = zdmap;
	if (swpexpand(ds, ss, &u.u_cdmap, &u.u_csmap) == NULL)
		goto bad;

	/* 
	 * At this point, committed to the new image!
	 * Release virtual memory resources of old process, and
	 * initialize the virtual memory of the new process.
	 * If we resulted from vfork(), instead wakeup our
	 * parent who will set SVFDONE when he has taken back
	 * our resources.
	 */
	if ((u.u_procp->p_flag & SVFORK) == 0)
		vrelvm();
	else {
		u.u_procp->p_flag &= ~SVFORK;
		u.u_procp->p_flag |= SKEEP;
		wakeup((caddr_t)u.u_procp);
		while ((u.u_procp->p_flag & SVFDONE) == 0)
			sleep((caddr_t)u.u_procp, PZERO - 1);
		u.u_procp->p_flag &= ~(SVFDONE|SKEEP);
	}
	u.u_procp->p_flag &= ~(SPAGI|SSEQL|SUANOM|SOUSIG);
	u.u_procp->p_flag |= pagi;
	u.u_dmap = u.u_cdmap;
	u.u_smap = u.u_csmap;
	vgetvm(ts, ds, ss);

#ifndef VFS
#ifdef VICE
	/* generic? */
	offset = (ep->a_magic == 0413) ? (long) NBPG*CLSIZE : (long) sizeof (struct exec);
#endif
#endif !VFS
	if (pagi == 0)
		u.u_error =
#ifndef VFS
		    rdwri(UIO_READ, ip,
#else !VFS
		    vn_rdwr(UIO_READ, vp,
#endif !VFS
			(char *)ctob(dptov(u.u_procp, 0)),
			(int)ep->a_data,
#ifndef VFS
#ifdef VICE
			/* generic? */
			(off_t)(offset + ep->a_text),
#else
			(off_t)((long) sizeof(struct exec) + ep->a_text),
#endif
			0, (int *)0);
#ifdef VICE
	/* generic */
	xalloc(ip, ep, pagi, offset);
#else
	xalloc(ip, ep, pagi);
#endif
#else !VFS
			(off_t)(sizeof (struct exec) + ep->a_text),
			UIO_USERSPACE, IO_UNIT, (int *)0);
	xalloc(vp, ep, pagi);
#endif !VFS
	if (pagi && u.u_procp->p_textp) {
#ifdef	ibm032
		/*
		 * We need to prevent swaps in vinifod.  (Possible via a sleep
		 * in bmap.)  If we don't prevent swapping, our ptes might move
		 * and vinifod would init the old ptes.  See MtXinu 4.3 buglist.
		 */
		u.u_procp->p_flag |= SKEEP;
#endif
		vinifod((struct fpte *)dptopte(u.u_procp, 0),
#ifndef VFS
		    PG_FTEXT, u.u_procp->p_textp->x_iptr,
#else !VFS
		    PG_FTEXT, u.u_procp->p_textp->x_vptr,
#endif !VFS
		    (long)(1 + ts/CLSIZE), (size_t)btoc(ep->a_data));
#ifdef	ibm032
		u.u_procp->p_flag &= ~SKEEP;
#endif
	}

#ifdef vax
	/* THIS SHOULD BE DONE AT A LOWER LEVEL, IF AT ALL */
	mtpr(TBIA, 0);
#endif

	if (u.u_error)
		swkill(u.u_procp, "exec: I/O error mapping pages");
	/* 
	 * set SUID/SGID protections, if no tracing
	 */
	if ((u.u_procp->p_flag&STRC)==0) {
#ifdef VFS
		if (uid != u.u_uid || gid != u.u_gid)
			u.u_cred = crcopy(u.u_cred);
#endif VFS
		u.u_uid = uid;
		u.u_procp->p_uid = uid;
		u.u_gid = gid;
	} else
		psignal(u.u_procp, SIGTRAP);
	u.u_tsize = ts;
	u.u_dsize = ds;
	u.u_ssize = ss;
	u.u_prof.pr_scale = 0;
bad:
	return;
}
