/*
 * Epoch 4.0 - abstract screen/window data used for ASCII or X operation.
 *	       This includes a lot of data which used to be emacs global
 *	       vars.  Note that an ASCII "pixel" = 1 character.  "Screen"
 *	       is abstracted to have text drawing space of pixw x pixh
 *	       pixels, with a border/offset of in_border pixels.
 *
 * Source code copyright 1989 by Alan M. Carroll, all rights reserved.
 * This code may be freely distributed as long as the copyright is preserved.
 *
 * $Revision: 1.1.1.1 $
 * $Source: /bsdi/MASTER/BSDI_OS/contrib/emacs/epoch-src/screenW.h,v $
 * $Date: 1992/07/28 00:45:30 $
 * $Author: polk $
 */

struct W_Screen
    {
    /* character size of the screen */
    int width,height;           
    
    /* Size of text area in pixels/ASCII characters */
    int pixw,pixh;
    int in_border;
    
    /* Size change pending? */    
    int size_change_pending;	/* got a size change request during update */
    int new_width,new_height;	/* what to change to when we have a chance */

    /* Fast access to current cursor position */
    struct window *cur_w;
    struct line_header *cur_line; 
    struct char_block *cur_char;
    int vis_xpos,vis_ypos;    
    
    /* Fast access to new cursor position */
    struct window *new_cur_w;
    struct line_header *new_cur_line;
    struct char_block *new_cur_char;
    int cursor_x,cursor_y;

    /* Has size changed? */
    char size_change;

    char replot_lines;
    } ;

/* - - */
extern struct W_Screen *cur_Wscreen;

#define XWSCREEN(a)  ((struct W_Screen *)XPNTR(a))
#define WS	cur_Wscreen
#define WS_DEF	struct W_Screen *ws = XWSCREEN(rb->win)

/* Maximum abstract pixel dimensions for screens.
 */
#define MScreenLength	2000
#define MScreenWidth	2000
