--{{{  front end header
--{{{  error number tags
VAL err.lexer         IS 1000 :
VAL err.syntax        IS 2000 :
VAL err.struct        IS 3000 :
VAL err.type          IS 4000 :
VAL err.trans         IS 5000 :
--}}}  
--{{{  buffer sizes
VAL maxfolddepth      IS   50 :  -- defined by system
VAL max.lex.depth     IS  100 :  -- maximum lex level
VAL size.line         IS  400 :  -- doesn't include table sizes
VAL max.dimen         IS   10 :  -- max array dimensions
VAL size.stack        IS   50 :  -- process stacks
VAL size.exp          IS  150 :  -- limit on expression nodes
VAL size.lexhash      IS  256 :  -- this must be a power of 2
--}}}  
--{{{  name sizes
VAL size.predefnames  IS  200 :  -- names reserved for predefines
VAL size.lexname      IS 3500 :  -- names for user (includes predefines)
--}}}  

--{{{  lexemes
--{{{  internal structural lexemes
VAL l.profilenextitem IS -29 :
VAL l.profile         IS -28 :
VAL l.endlib          IS -27 :
VAL l.startlib        IS -26 :
VAL l.id              IS  -7 :  -- id tag from back end
--                    IS  -6 :
VAL l.endfold         IS  -5 :  -- end existing fold
VAL l.nextitem        IS  -4 :  -- next item/line in fold
VAL l.startfold       IS  -3 :  -- start new fold
VAL l.startprog       IS  -2 :  -- start of program
VAL l.endprog         IS  -1 :  -- end of program (must be > others)
--}}}  
--{{{  commonly used tokens
VAL l.esc             IS   0 :  -- number follows
VAL l.error           IS   1 :  -- message follows
VAL l.esc2            IS   2 :  -- double length number follows
VAL l.warning         IS   3 :  -- like error but only a warning
--}}}  
--{{{  type declarations and convertors
VAL l.port            IS  4 :  -- type
VAL l.chan            IS  5 :  -- type
VAL l.timer           IS  6 :  -- type
VAL l.bool            IS  7 :  -- type op mop datatype
VAL l.byte            IS  8 :  -- type op mop datatype
VAL l.int             IS  9 :  -- type op mop datatype arith
VAL l.int16           IS 10 :  -- type op mop datatype arith extended
VAL l.int32           IS 11 :  -- type op mop datatype arith extended
VAL l.int64           IS 12 :  -- type op mop datatype arith extended
VAL l.real32          IS 13 :  -- type op mop datatype arith extended
VAL l.real64          IS 14 :  -- type op mop datatype arith extended
--}}}  
--{{{  monadics
VAL l.neg             IS  20 :  --      op mop inst
VAL l.mneg            IS  21 :  --      op mop inst
VAL l.not             IS  22 :  --      op mop inst
VAL l.bitnot          IS  23 :  --      op mop inst
VAL l.size            IS  24 :  --      op mop inst
VAL l.trunc           IS  25 :  --      op mop inst
VAL l.round           IS  26 :  --      op mop inst
--}}}  
--{{{  dyadics
VAL l.add             IS  30 :  --      op dop inst cop
VAL l.mul             IS  31 :  --      op dop inst cop
VAL l.plus            IS  32 :  --      op dop inst cop
VAL l.bitand          IS  33 :  --      op dop inst cop
VAL l.bitor           IS  34 :  --      op dop inst cop
VAL l.xor             IS  35 :  --      op dop inst cop
VAL l.and             IS  36 :  --      op dop inst cop
VAL l.or              IS  37 :  --      op dop inst cop
VAL l.sub             IS  38 :  --      op dop inst
VAL l.div             IS  39 :  --      op dop inst
VAL l.rem             IS  40 :  --      op dop inst
VAL l.times           IS  41 :  --      op dop inst
VAL l.minus           IS  42 :  --      op dop inst
VAL l.lshift          IS  43 :  --      op dop inst
VAL l.rshift          IS  44 :  --      op dop inst
--}}}  
--{{{  relationals
VAL l.eq              IS  50 :  --      op dop rel
VAL l.ne              IS  51 :  --      op dop rel
VAL l.ls              IS  52 :  --      op dop rel
VAL l.le              IS  53 :  --      op dop rel
VAL l.gr              IS  54 :  --      op dop rel
VAL l.ge              IS  55 :  --      op dop rel
VAL l.after           IS  56 :  --      op dop rel
--}}}  
--{{{  array access
VAL l.slice           IS 60 :  --      op dop
VAL l.from            IS 61 :  --      op dop
VAL l.subscr          IS 62 :  --      op dop
VAL l.count           IS 63 :  --      op dop
--}}}  
--{{{  procs, instances and more processes
VAL l.instance        IS 70 :  --      op dop
VAL l.param           IS 71 :  --      op dop
VAL l.const           IS 81 :
VAL l.constitem       IS 82 :
VAL l.endconst        IS 83 :
VAL l.proc            IS 84 :  -- must be less than 256
VAL l.endproc         IS 85 :
VAL l.static          IS 86 :
VAL l.abbrev          IS 87 :
VAL l.endparams       IS 90 :
VAL l.blockmove       IS 91 :
VAL l.outputbyte      IS 92 :
VAL l.outputword      IS 93 :
VAL l.timeafter       IS 95 :
VAL l.guard           IS 96 :
VAL l.endguard        IS 97 :
VAL l.wait            IS 98 :
VAL l.endwait         IS 99 :
VAL l.scalar          IS 100 :
VAL l.check           IS 101 :
VAL l.chkequal        IS 102 :
VAL l.checkoverlap    IS 103 :
--}}}  
--{{{  structure brackets
VAL l.scope            IS 105 :
VAL l.endscope         IS 106 :

VAL l.seq              IS 107 :
VAL l.endseq           IS 108 :

VAL l.if               IS 109 :
VAL l.inif             IS 110 :
VAL l.endif            IS 111 :

VAL l.while            IS 112 :
VAL l.endwhile         IS 113 :

VAL l.par              IS 114 :
VAL l.inpar            IS 115 :
VAL l.endpar           IS 116 :

VAL l.alt              IS 117 :
VAL l.inalt            IS 118 :
VAL l.endalt           IS 119 :

VAL l.replseq          IS 125 :
VAL l.endreplseq       IS 126 :

VAL l.replif           IS 127 :
VAL l.endreplif        IS 128 :

VAL l.replpar          IS 129 :
VAL l.endreplpar       IS 130 :

VAL l.replalt          IS 131 :
VAL l.endreplalt       IS 132 :

VAL l.placedpar        IS 135 :
VAL l.inplacedpar      IS 136 :
VAL l.endplacedpar     IS 137 :

VAL l.replplacedpar    IS 138 :
VAL l.endreplplacedpar IS 139 :

VAL l.pripar           IS 145 :
VAL l.inpripar         IS 146 :
VAL l.endpripar        IS 147 :

VAL l.prialt           IS 148 :
VAL l.inprialt         IS 149 :
VAL l.endprialt        IS 150 :

VAL l.replpripar       IS 155 :
VAL l.endreplpripar    IS 156 :

VAL l.replprialt       IS 157 :
VAL l.endreplprialt    IS 158 :

VAL l.processor        IS 159 :
VAL l.endprocessor     IS 160 :
--}}}  
--{{{  basic processes
VAL l.input           IS 170 :
VAL l.output          IS 171 :
VAL l.assign          IS 172 :
VAL l.skip            IS 173 :
VAL l.stop            IS 174 :
--}}}  
--{{{  function support
VAL l.function        IS 180 :  -- must be less than 256
VAL l.result          IS 181 :
VAL l.multiassign     IS 182 :
VAL l.valof           IS 183 :
--}}}  
--{{{  SC and PD tags
VAL l.desc            IS 190 :
VAL l.sc              IS 191 :
VAL l.pd              IS 192 :
VAL l.scbe            IS 193 :  -- tags for SC lines
VAL sc.code           IS 194 :
VAL sc.entry          IS 195 :
--}}}  
--{{{  labels and jumps
VAL l.jump            IS 200 :
VAL l.jfalse          IS 201 :
VAL l.setlab          IS 202 :
--}}}  
--{{{  alt stuff
VAL l.pause           IS 204 :
VAL l.enable          IS 205 :
VAL l.disable         IS 206 :
VAL l.disablerepl     IS 207 :
VAL l.preparealt      IS 210 :
VAL l.waitalt         IS 211 :
VAL l.altjump         IS 212 :
VAL l.preparetimealt  IS 213 :
VAL l.waittimealt     IS 214 :
--}}}  
--{{{  declaration keywords
VAL l.is              IS 215 :
VAL l.retypes         IS 216 :
VAL l.refer           IS 217 :
VAL l.place           IS 218 :
VAL l.protocol        IS 219 :
--}}}  
--{{{  new tokens
VAL l.vector          IS 230 :
VAL l.eval            IS 231 :
VAL l.guy             IS 232 :
VAL l.guydef          IS 233 :
VAL l.step            IS 234 :
VAL l.link            IS 235 :
VAL l.lib             IS 236 :
VAL l.chkrange        IS 237 :
VAL l.check1          IS 238 :
VAL l.mostpos         IS 239 :
VAL l.mostneg         IS 240 :
VAL l.check0          IS 241 :
VAL l.checkalign      IS 242 :
VAL l.checknot0       IS 243 :
VAL l.setconst        IS 244 :
--}}}  
--{{{  case support
VAL l.case            IS 250 :
VAL l.else            IS 251 :
VAL l.caseinput       IS 252 :
VAL l.casetag         IS 253 :
VAL l.incase          IS 254 :
VAL l.endcase         IS 255 :
VAL l.taginput        IS 256 :
VAL l.any             IS 257 :
VAL l.caseselector    IS 258 :
VAL l.casedef         IS 259 :
VAL l.endcaseinput    IS 260 :
VAL l.checkedinput    IS 261 :
--}}}  
--{{{  punctuation
VAL l.dot             IS 270 :
VAL l.boxes           IS 271 :
VAL l.lparen          IS 272 :
VAL l.rparen          IS 273 :
VAL l.lbox            IS 274 :
VAL l.rbox            IS 275 :
VAL l.comma           IS 276 :
VAL l.semicolon       IS 277 :
VAL l.colon           IS 278 :
VAL l.ampersand       IS 279 :
--}}}  
--{{{  less common keywords
VAL l.of              IS 290 :
VAL l.pri             IS 291 :
VAL l.val             IS 292 :
VAL l.for             IS 294 :
VAL l.false           IS 295 :
VAL l.true            IS 296 :
VAL l.at              IS 297 :
VAL l.in              IS 298 :
VAL l.workspace       IS 300 :
VAL l.placed          IS 301 :
VAL l.vecspace        IS 302 :
--}}}  
--{{{  layout
VAL l.indent          IS 310 :
VAL l.outdent         IS 311 :
VAL l.endline         IS 312 :
--}}}  
--{{{  config lexemes
VAL l.t2   IS 320 :  --do not change this order without changing tables
VAL l.t4   IS 321 :  --giving bytes per word, etc.
VAL l.t8   IS 322 :
VAL l.t425 IS 323 :
VAL l.minprocessor IS l.t2 :
VAL l.maxprocessor IS l.t425 :
--}}}  
--{{{  special tokens
VAL l.printname       IS 380 :
VAL l.printnum        IS 381 :
VAL l.printhex        IS 382 :

-- back end lexemes start here
VAL l.totalcode       IS 390 :
VAL l.entry           IS 391 :
VAL l.code            IS 392 :
VAL l.debug           IS 393 :
VAL l.nil             IS 394 :
VAL l.genbase         IS 400 :
--}}}  
--}}}  
--{{{  lexeme ranges
VAL l.mintype         IS l.port :    -- types
VAL l.datatype        IS l.bool :    -- data (assignable) types
VAL l.maxtype         IS l.real64 :

VAL l.minop           IS l.bool :    -- operators
VAL l.maxop           IS l.param :

VAL l.minmop          IS l.bool :    -- monadic operators
VAL l.maxmop          IS l.round :

VAL l.minarith        IS l.int :     -- arithmetic types
VAL l.maxarith        IS l.real64 :

VAL l.minextended     IS l.int16 :   -- extended types
VAL l.maxextended     IS l.real64 :

VAL l.mininst         IS l.neg :     -- instructions
VAL l.maxinst         IS l.rshift :

VAL l.mincop          IS l.add :     -- commutative operators
VAL l.maxcop          IS l.or :

VAL l.mindop          IS l.add :     -- dyadic operators
VAL l.maxdop          IS l.param :

VAL l.minrelop        IS l.eq :      -- relational operators
VAL l.maxrelop        IS l.after:
--}}}  
--{{{  lexemes for names
VAL l.predefs         IS 1000 :  -- internal predefine representation
VAL l.name            IS 2000 :  -- names start here
VAL l.maxname         IS 9998 :
VAL l.initname        IS 9999 :  -- used to introduce abbrev vars
VAL l.pdoffset        IS l.name - l.predefs :

VAL l.consname        IS 10000 :
VAL l.maxconsname     IS l.consname + 10000 :

VAL l.expname         IS l.maxconsname :
VAL l.maxexpname      IS l.expname + 10000 :

VAL l.transname       IS l.maxexpname :
VAL l.maxtransname    IS l.transname + 10000 :

VAL l.protname        IS l.maxtransname :
VAL l.maxprotname     IS l.protname + 10000 :

VAL l.configname      IS l.maxprotname :
VAL l.maxconfigname   IS l.configname + 10000 :

VAL l.genname         IS l.maxconfigname :  -- first name for back end
--}}}  
--{{{  lexemes for labels
VAL l.label           IS 1000000 :

VAL l.guylabel        IS l.label :
VAL l.maxguylabel     IS l.guylabel + 10000 :

VAL l.translabel      IS l.maxguylabel :
VAL l.maxtranslabel   IS l.translabel + 10000 :

VAL l.genlabel        IS l.maxtranslabel :  -- first label for back end
--}}}  
--{{{  predefine names

-- these values are based on the keywords being added to the start
-- of the name tables

VAL l.longadd           IS l.name +  0 :
VAL l.longsum           IS l.name +  1 :
VAL l.longsub           IS l.name +  2 :
VAL l.longdiff          IS l.name +  3 :
VAL l.longprod          IS l.name +  4 :
VAL l.longdiv           IS l.name +  5 :
VAL l.shiftright        IS l.name +  6 :
VAL l.shiftleft         IS l.name +  7 :
VAL l.normalise         IS l.name +  8 :
VAL l.fracmul           IS l.name +  9 :
VAL l.ashiftright       IS l.name + 10 :
VAL l.ashiftleft        IS l.name + 11 :
VAL l.rotateright       IS l.name + 12 :
VAL l.rotateleft        IS l.name + 13 :
VAL l.unpacksn          IS l.name + 14 :
VAL l.roundsn           IS l.name + 15 :
VAL l.causeerror        IS l.name + 16 :
VAL l.kernelrun         IS l.name + 17 :
VAL l.loadinputchannel  IS l.name + 18 :
VAL l.loadoutputchannel IS l.name + 19 :
VAL l.loadinputvector   IS l.name + 20 :
VAL l.loadoutputvector  IS l.name + 21 :
VAL l.loadbytevector    IS l.name + 22 :
VAL l.bitcount          IS l.name + 23 :
VAL l.crcword           IS l.name + 24 :
VAL l.crcbyte           IS l.name + 25 :
VAL l.move2d            IS l.name + 26 :
VAL l.draw2d            IS l.name + 27 :
VAL l.clip2d            IS l.name + 28 :
VAL l.bitrevword        IS l.name + 29 :
VAL l.bitrevnbits       IS l.name + 30 :
VAL l.abs               IS l.name + 31 :
VAL l.isnan             IS l.name + 32 :
VAL l.notfinite         IS l.name + 33 :
VAL l.ordered           IS l.name + 34 :
VAL l.mulby2            IS l.name + 35 :
VAL l.divby2            IS l.name + 36 :
VAL l.sqrt              IS l.name + 37 :
VAL l.dabs              IS l.name + 38 :
VAL l.disnan            IS l.name + 39 :
VAL l.dnotfinite        IS l.name + 40 :
VAL l.dordered          IS l.name + 41 :
VAL l.dmulby2           IS l.name + 42 :
VAL l.ddivby2           IS l.name + 43 :
VAL l.dsqrt             IS l.name + 44 :
VAL l.int16add          IS l.name + 45 :
VAL l.int16plus         IS l.name + 46 :
VAL l.int16sub          IS l.name + 47 :
VAL l.int16minus        IS l.name + 48 :
VAL l.int16times        IS l.name + 49 :
VAL l.int16bitand       IS l.name + 50 :
VAL l.int16bitor        IS l.name + 51 :
VAL l.int16xor          IS l.name + 52 :
VAL l.int16rshift       IS l.name + 53 :
VAL l.int16lshift       IS l.name + 54 :
VAL l.int16bitnot       IS l.name + 55 :
VAL l.int16gt           IS l.name + 56 :
VAL l.int16eq           IS l.name + 57 :
VAL l.int16mul          IS l.name + 58 :
VAL l.int16div          IS l.name + 59 :
VAL l.int16rem          IS l.name + 60 :
VAL l.int32mul          IS l.name + 61 :
VAL l.int32div          IS l.name + 62 :
VAL l.int32rem          IS l.name + 63 :
VAL l.int64add          IS l.name + 64 :
VAL l.int64plus         IS l.name + 65 :
VAL l.int64sub          IS l.name + 66 :
VAL l.int64minus        IS l.name + 67 :
VAL l.int64times        IS l.name + 68 :
VAL l.int64bitand       IS l.name + 69 :
VAL l.int64bitor        IS l.name + 70 :
VAL l.int64xor          IS l.name + 71 :
VAL l.int64rshift       IS l.name + 72 :
VAL l.int64lshift       IS l.name + 73 :
VAL l.int64bitnot       IS l.name + 74 :
VAL l.int64gt           IS l.name + 75 :
VAL l.int64eq           IS l.name + 76 :
VAL l.int64mul          IS l.name + 77 :
VAL l.int64div          IS l.name + 78 :
VAL l.int64rem          IS l.name + 79 :
VAL l.real32op          IS l.name + 80 :
VAL l.real32rem         IS l.name + 81 :
VAL l.real32gt          IS l.name + 82 :
VAL l.real32eq          IS l.name + 83 :
VAL l.real64op          IS l.name + 84 :
VAL l.real64rem         IS l.name + 85 :
VAL l.real64gt          IS l.name + 86 :
VAL l.real64eq          IS l.name + 87 :
VAL l.int16toint64      IS l.name + 88 :
VAL l.int32toint64      IS l.name + 89 :
VAL l.int16toreal32     IS l.name + 90 :
VAL l.int32toreal32     IS l.name + 91 :
VAL l.int16toreal64     IS l.name + 92 :
VAL l.int32toreal64     IS l.name + 93 :
VAL l.int64toint16      IS l.name + 94 :
VAL l.int64toint32      IS l.name + 95 :
VAL l.int64toreal32     IS l.name + 96 :
VAL l.int64toreal64     IS l.name + 97 :
VAL l.real32toint16     IS l.name + 98 :
VAL l.real32toint32     IS l.name + 99 :
VAL l.real32toint64     IS l.name + 100 :
VAL l.real32toreal64    IS l.name + 101 :
VAL l.real64toint16     IS l.name + 102 :
VAL l.real64toint32     IS l.name + 103 :
VAL l.real64toint64     IS l.name + 104 :
VAL l.real64toreal32    IS l.name + 105 :
VAL l.fpint             IS l.name + 106 :
VAL l.dfpint            IS l.name + 107 :
VAL l.ieeecompare       IS l.name + 108 :
VAL l.dieeecompare      IS l.name + 109 :
VAL l.minusx            IS l.name + 110 :
VAL l.dminusx           IS l.name + 111 :
VAL l.maxpredefname     IS l.dminusx :
--}}}  
--{{{  special values
VAL nil               IS  -1 :  -- nil pointer in tree
VAL nameterminator    IS 255 :  -- end of name for name table (0 < n <= 255)

VAL bool.false        IS   0 :
VAL bool.true         IS   1 :
--}}}  
--}}}  
