# Filename: cat.awk
#
# Input file 
# 	sorted and generated by devinfo.awk
#
#   CABINET <cabNum> BP <A|B|C|D> S <slotNum> <DeviceDescription>
#   Sample entries:
#
#  			 Fields
#	   1      2    3    4   5   6     7        8
# 
#	CABINET   00   BP   A   S   00   RAID5 
#	CABINET   00   BP   A   S   02   MIO      I04
#	CABINET   00   BP   A   S   07   ENET 
#	CABINET   00   BP   D   S   03   DISK      MAXTOR1240
#	CABINET   00   BP   D   S   03   RAID5 
#	CABINET   00   BP   D   S   03   TAPE      DAT
#
# Output file format
#	Concatenates multiple device names for a given slot on a bp
#	and outputs them one per cabinet
#
# Modification History:
#
# $Log: cat.awk,v $
# Revision 1.2  1993/03/18  21:23:36  mouli
# 1. Modified to output cable label numbers instead of backplane numbers.
# 2. Added outputting the 8th field of the input file which could be one of
#    {device brand name, fab-rev, symbolic name}
#
# Revision 1.1  1993/03/12  01:31:18  mouli
# Initial revision
#
# 	03/09/93	mouli	Initial version
#
BEGIN {
	lastcab = -1
	lastbp = ""
	lasts = -1
	first = 1
}
{
	if ($1 == "CABINET")
	{
		curcab = int($2)
		curbp = $4
		curs = int($6)
		if ((curcab == lastcab) && (curbp  == lastbp)  && (curs   == lasts))
		{
			printf " %s %s", $7, $8
		}
		else 
		{
			if (first == 1) 
			{
				printf "%s %s %s %s %s %s %s %s", $1,$2,$3,$4,$5,$6,$7, $8
				first = 0
			}
			else printf "\n%s %s %s %s %s %s %s %s", $1,$2,$3,$4,$5,$6,$7,$8
		}
		lastcab = curcab
		lastbp = curbp
		lasts = curs
	}
}
END {
	printf "\n"
}
