* Configuration for Santa Clara 8/32 A5.

************************************************************
* System has 512 devices- requires NDEV set to 512 in L.s  *
************************************************************

cpu	832		* processor type
memory	512K		* up to 512 K memory
* float   hard          * hardware single-precision floating point
* dfloat        hard    * hardware double-precision floating point

* Real devices

* Pertec disks - Only one controller supported at this time
* dsk	dev	0xC2 0xC3 
* 	cntl	0xB2
* 	selch	0xF0
* 	size	10M	* 10 megabyte
 

* Pertec disks
dsk	dev	0xC6 0xC7 0xD6 0xD7 
	cntl	0xB6
	selch	0xF0
	size	10M	* 10 megabyte

* CDC 'MSM 80' disk
msm	dev	0xFC
	cntl	0xFB
	selch	0xF1
	size	67m			* 67 megabyte capacity
	map     0               9600           * map for logical subdisks
		9600            9600
		19200		9600
		28800		51200
		80000           51200
		0               0
		0		0
		0		131520

* 800 bpi magnetic tape
mt      dev     0x85 0xC5
	selch  	0xF0
* PALS
vdu     dev     0x10 0x12 0x14 0x16 0x18 0x1A 0x1C 0x1E
		* really at 0x120 -0x12E - over 8 bits so cannot talk to.  
		* need kernel mod to keep index in short not char.
		0x20 0x22 0x24 0x26 0x28 0x2A 0x2C 0x2E
		0x70 0x72
	speeds  300     1200    2400    4800    * 10
		300     1200    2400    4800    * 12
		300     1200    2400    4800    * 14
		300     1200    2400    4800    * 16
		300     1200    2400    4800    * 18
		300     1200    2400    4800    * 1A
		300     1200    2400    4800    * 1C
		300     1200    2400    4800    * 1E
		300     1200    2400    4800    * x20
		300     1200    2400    4800    * x22
		300     1200    2400    4800    * x24
		300     1200    2400    4800    * x26
		300     1200    2400    4800    * x28
		300     1200    2400    4800    * x2A
		300     1200    2400    4800    * x2C
		300     1200    2400    4800    * x2E
		300     1200    2400    4800    * 70
		300     1200    2400    4800    * 72

* Precision clock
clock	dev	0x6C

* Software devices

mem		* memory
tty		* process's controlling terminal
* mx            * multiplexed files
*pack		* packet switch driver

* Special device assignments

cons	vdu	0	* console
root    msm     0       * root filesystem
swap    msm     1       * swap device
	swaplo  100     * origin of swap area
	nswap   9500    * number of blocks in swap area
pipe    msm     0       * device to allocate pipes
dump    mt              * device for post-panic dumps
