/*
 * Memory special file
 * minor device 0 is physical memory
 * minor device 1 is kernel memory
 * minor device 2 is EOF/BITBUCKET
 */

/*** Rewritten for Interdata 7-8/32
 *** Code is made simpler (and less portable!) by the assumption
 *** that all physical memory is contiguous and directly addressable.
 ***/

#include "../h/param.h"
#include "../h/systm.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/conf.h"
#include "../h/seg.h"

mmread(dev)
dev_t dev;
{
	caddr_t addr;

	if(minor(dev) == 2)
		return;
	do {
		addr = u.u_offset;
		if ((minor(dev) == 1 && lraddr(&addr, kisa))
		    || addr >= memtop)
			break;
	} while(u.u_error==0 && passc(*addr) >= 0);
}

mmwrite(dev)
dev_t dev;
{
	caddr_t addr;
	register c;

	if(minor(dev) == 2) {
		c = u.u_count;
		u.u_count = 0;
		u.u_base += c;
		u.u_offset += c;
		return;
	}
	for (;;) {
		addr = u.u_offset;
		if ((c=cpass())<0 || u.u_error!=0)
			break;
		if ((minor(dev) == 1 && lraddr(&addr, kisa))
		    || addr >= memtop)
			break;
		*addr = c;
	}
}
