/*
 *	$Source: /u1/X/DECToolkit/src/RCS/TextDisplay.h,v $
 *	$Header: TextDisplay.h,v 1.1 86/12/17 09:04:56 swick Exp $
 */

/*
 *			  COPYRIGHT 1986
 *		   DIGITAL EQUIPMENT CORPORATION
 *		       MAYNARD, MASSACHUSETTS
 *			ALL RIGHTS RESERVED.
 *
 * THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
 * SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.
 * DIGITAL MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR
 * ANY PURPOSE.  IT IS SUPPLIED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *
 * IF THE SOFTWARE IS MODIFIED IN A MANNER CREATING DERIVATIVE COPYRIGHT RIGHTS,
 * APPROPRIATE LEGENDS MAY BE PLACED ON THE DERIVATIVE WORK IN ADDITION TO THAT
 * SET FORTH ABOVE.
 *
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting documentation,
 * and that the name of Digital Equipment Corporation not be used in advertising
 * or publicity pertaining to distribution of the software without specific, 
 * written prior permission.
 */

/* File: TextDisplay.h - included in all TextSW related files */
/* weissman:	14-Jul-86 09:55 */
/* Smokey:	12-Jun-86 16:25 */
/* larson: 	11-Nov-86 */

#define LF	0x0a
#define CR	0x0d
#define TAB	0x09
#define BS	0x08
#define SP	0x20
#define DEL	0x7f

enum ScanDirection {left, right};
enum InsertionType {none, append, edit};

typedef struct _Selection {
    TTextPosition left, 	/* Positions of where selection starts */
    		  right;	/* and stops. */
    unsigned short time;	
    enum SelectionType type;	/* what type of things to select */
    char *not_in_word;		/* symbols to delimit a word */
    int mutual_exclusion; 	/* on if selection is mutually exclusive */
    } Selection, *SelectionPtr;

/*
 * this structure describe the source object associated with at text window 
 */
typedef struct _TTextSource {
    int (*read)();			/* procedure to read source */
    int (*replace)();			/* procedure to write source */
    TTextPosition (*getLastPos)(); 	/* procedure to get last position of 
					   source */
    int (*setLastPos)();		/* procedure to set last position */
    enum InsertionType (*getEditType)();/* procedure to determine type of 
					   source editable allowed */
    TTextPosition (*scan)();		/* procedure to scan through source */
    int *data;				
    } TTextSource, *TextSourcePtr;

/*
 * This structure describes the sink object associated with a text subwindow.
 */
typedef struct _TTextSink {
    int (*display)();
    int (*findPosition)();
    int (*findDistance)();
    int (*resolve)();
    int (*maxLines)();
    int (*maxHeight)();
    int *data;
    } TTextSink, *TextSinkPtr;
