/*
 *	$Source: /u1/Xr/src/Xrlib/Editor/RCS/textUtil.c,v $
 *	$Header: textUtil.c,v 1.1 86/12/17 09:07:25 swick Exp $
 */

#ifndef lint
static char *rcsid_textUtil_c = "$Header: textUtil.c,v 1.1 86/12/17 09:07:25 swick Exp $";
#endif	lint


#include <Xr/xr-copyright.h>

/* $Header: textUtil.c,v 1.1 86/12/17 09:07:25 swick Exp $ */
/* Copyright 1986, Hewlett-Packard Company */
/* Copyright 1986, Massachussetts Institute of Technology */

static char rcsid[] = "$Header: textUtil.c,v 1.1 86/12/17 09:07:25 swick Exp $";
/*************************************<+>*************************************
 *****************************************************************************
 **
 **   File:        textUtil.c
 **
 **   Project:     X-ray Toolbox
 **
 **   Description: 
 **         This file contains several text/font manipulation routines
 **         which are useful to field editors which do any text handling.
 **         Any of the text displaying routines supplied here will use
 **         a graphics context to obtain the drawing environment.
 **
 **
 **   ------------------------ MODIFICATION RECORD   ------------------------
 *
 * $Log:	textUtil.c,v $
 * Revision 1.1  86/12/17  09:07:25  swick
 * Initial revision
 * 
 * Revision 7.0  86/11/13  08:31:14  08:31:14  fred ()
 * Final QA Release
 * 
 * Revision 6.0  86/11/10  15:39:51  15:39:51  fred ()
 * QA #2 release
 * 
 * Revision 5.1  86/11/07  14:27:46  14:27:46  fred ()
 * Added new copyright message.
 * 
 * Revision 5.0  86/10/28  08:41:53  08:41:53  fred ()
 * QA #1.1 release
 * 
 * Revision 4.0  86/10/20  12:17:27  12:17:27  fred ()
 * QA #1 release
 * 
 * Revision 3.1  86/10/16  09:25:04  09:25:04  fred ()
 * Performance enhanced: added use of register variables.
 * 
 * Revision 3.0  86/10/02  16:08:41  16:08:41  fred ()
 * Alpha release set to 3.0
 * 
 * Revision 2.3  86/09/24  07:13:47  07:13:47  fred ()
 * Add calculation of avgWidth to _XrTextInfo().
 * 
 * Revision 2.2  86/09/23  07:14:43  07:14:43  fred ()
 * Changed font leading from (height / 3) to (ascent / 3).
 * 
 * Revision 2.1  86/09/16  12:15:43  12:15:43  fred ()
 * Filled in the procedure headers.
 * 
 * Revision 2.0  86/09/16  08:17:57  08:17:57  fred ()
 * No change; upgraded to revision 2.0 to match other source.
 * 
 * Revision 1.1  86/09/03  14:01:12  14:01:12  fred ()
 * Initial revision
 * 
 *
 *****************************************************************************
 *************************************<+>*************************************/



#include <X/Xlib.h>
#include <Xr/defs.h>
#include <Xr/types.h>



/*************************************<->*************************************
 *
 *  _XrImageText8 (windowId, GC, len, x, y, string)
 *
 *     Window  windowId;
 *     INT32   GC;
 *     INT32   len;
 *     INT16   x, y;
 *     STRING8 string;
 *
 *   Description:
 *   -----------
 *     This routine will display the specified text string at the specified
 *     (x,y) location, using the drawing environment contained in the
 *     specified graphics context.  The background area of the text is
 *     filled using the background color, while the text itself is drawn
 *     using the foreground color.
 *
 *
 *   Inputs:
 *   ------
 *     windowId = Window Id of window in which text is to be drawn.
 *
 *     GC = Index of the graphics context structure to use to draw the
 *          text string.  The fields of importance are:
 *  
 *          XrFONTVAL       = The font to be used to draw the text.
 *          XrFOREGROUNDVAL = The color to draw the text with.
 *          XrBACKGROUNDVAL = The color to use as the background.
 *          XrALUVAL        = The replacement rule.
 *
 *     len = The length of the text string, or XrNULLTERMINATED, if the
 *           string is NULL terminated.
 *
 *     x, y = The window location of where the string is to be drawn.
 *
 *     string = The text string.
 * 
 *   Outputs:
 *   -------
 *
 *   Procedures Called
 *   -----------------
 *   XTextPad()  [libX.a]
 *
 *************************************<->***********************************/

_XrImageText8 (windowId, GC, len, x, y, string)

   Window  windowId;
   INT32   GC;
   INT32   len;
   INT16   x;
   INT16   y;
   STRING8 string;

{
   int i;

   if (len == XrNULLTERMINATED)
      i = strlen (string);
   else
      i = len;

   XTextPad (windowId, x, y, string, i, xr_GCList[GC][XrFONTVAL], 0, 0,
             xr_GCList[GC][XrFOREGROUNDVAL], xr_GCList[GC][XrBACKGROUNDVAL],
             xr_GCList[GC][XrALUVAL], AllPlanes);
}


/*************************************<->*************************************
 *
 *  _XrTextInfo (fontInfo, textInfo)
 *
 *     FontInfo   * fontInfo;
 *     xrTextInfo * textInfo;
 *
 *   Description:
 *   -----------
 *     This routine takes a font, specified by the 'fontInfo' parameter,
 *     and returns an xrTextInfo structure; this provides the application
 *     with some extra data about the font, such as the ascent, descent,
 *     maximum character width, and the leading.
 *
 *
 *   Inputs:
 *   ------
 *     fontInfo = This is a pointer to a structure which describes
 *                the font for which additional information is desired.
 * 
 *   Outputs:
 *   -------
 *     textInfo = This is a pointer to the structure into which the
 *                additional font information will be placed.
 *
 *   Procedures Called
 *   -----------------
 *   XrStringWidth [utilities.c]
 *
 *************************************<->***********************************/

_XrTextInfo (fontInfo, textInfo)
   register FontInfo   * fontInfo;
   register xrTextInfo * textInfo;

{
   textInfo->fontInfo = fontInfo;
   textInfo->descent = fontInfo->height - fontInfo->baseline;
   textInfo->ascent = fontInfo->height - textInfo->descent;
   textInfo->avgWidth = fontInfo->width;
   textInfo->maxWidth = XrStringWidth (fontInfo, "W", 1, 0, 0);
   textInfo->leading = textInfo->ascent / 3;
   if (textInfo->leading < 2) textInfo->leading = 2;
}

