.TH XBIFF 1 "1 March 1988" "X Version 11"
.SH NAME
xbiff - mailbox flag for X
.SH SYNOPSIS
.B xbiff
[-\fItoolkitoption\fP ...] [-option ...]
.SH DESCRIPTION
The
.I xbiff
program displays a little image of a mailbox.  When there is no mail, the flag
on the mailbox is down.  When arrives, the flag goes up and the mailbox beeps.
This program is nothing more than a wrapper around the Athena Mailbox widget.
.SH OPTIONS
.I Xbiff
accepts all of the standard X Toolkit command line options along with the
additional options listed below:
.TP 8
.B \-help
This option indicates that a brief summary of the allowed options should be
printed on the standard error.
.TP 8
.B \-update \fIseconds\fP
This option specifies the frequency in seconds at which \fIxbiff\fP
should update its display.  If the mailbox is obscured and then exposed,
it will be updated immediately.
.TP 8
.B \-file \fIfilename\fP
This option specifies the name of the file which should be monitored.  By
default, it watches /usr/spool/mail/\fIusername\fP, where \fIusername\fP
is your login name.
.PP
The following standard X Toolkit command line arguments are commonly used with 
.I xbiff:
.TP 8
.B \-bg \fIcolor\fP
This option specifies the color to use for the background of the window.  
The default is ``white.''
.TP 8
.B \-bd \fIcolor\fP
This option specifies the color to use for the border of the window.
The default is ``black.''
.TP 8
.B \-bw \fInumber\fP
This option specifies the width in pixels of the border surrounding the window.
.TP 8
.B \-fg \fIcolor\fP
This option specifies the color to use for the foreground of the window.
The default is ``black.''
.TP 8
.B \-rv
This option indicates that reverse video should be simulated by swapping
the foreground and background colors.
.TP 8
.B \-geometry \fIgeometry\fP
This option specifies the prefered size and position of the mailbox window;
see \fIX(1)\fP.
.TP 8
.B \-display \fIdisplay\fP
This option specifies the X server to contact; see \fIX(1)\fP.
.TP 8
.B \-xrm \fIresourcestring\fP
This option specifies a resource string to be used.  This is especially
useful for setting resources that do not have separate command line options.
.SH X DEFAULTS
This program uses the 
.I Mailbox
widget in the X Toolkit.  It understands all of the core resource names and
classes as well as:
.PP
.TP 8
.B file (\fPclass\fB File)
Specifies the name of the file to monitor.  The default is to watch
/usr/spool/mail/\fIusername\fP, where \fIusername\fP is your login name.
.TP 8
.B width (\fPclass\fB Width)
Specifies the width of the mailbox.
.TP 8
.B height (\fPclass\fB Height)
Specifies the height of the mailbox.
.TP 8
.B update (\fPclass\fB Interval)
Specifies the frequency in seconds at which the mail should be checked.
.TP 8
.B foreground (\fPclass\fB Foreground)
Specifies the color for the foreground.
The default is ``black'' since the core default for background is ``white.''
.TP 8
.B reverseVideo (\fPclass\fB ReverseVideo)
Specifies that the foreground and background should be reversed.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH "SEE ALSO"
X(1),
xrdb(1),
stat(2)
.SH BUGS
The mailbox bitmaps are ugly.
.SH COPYRIGHT
Copyright 1988, Massachusetts Institute of Technology.
.br
See \fIX(1)\fP for a full statement of rights and permissions.
.SH AUTHOR
Jim Fulton, MIT X Consortium
