PAGE	60,132
TITLE	SET EQUIPMENT FLAG TO CURRENT VIDEO MODE

;This program sets the BIOS EQUIP_FLG word to reflect
;the current video mode


bios_data_seg	equ	40h		;bios data segment
equip_flg_off	equ	10h		;equip_flg offset
cols_off	equ	04ah		;char columns on screen offset

code	segment
assume	cs:code

begin:	mov	ax,bios_data_seg
	mov	ds,ax			;point ds to bios data segment
	xor	bx,bx			;bx points to beginning of segment

	mov	ax,equip_flg_off[bx]	;get equipment flags
	and	ax,0ffcfh		;clear video bits
	or	ax, 0010h		;set to 40x25 color card
	cmp	byte ptr cols_off[bx],80 ;80 characters per line?
	jne	exit			;no-jump
	xor	ax, 0030h		;set to 80x25 color card

exit:	mov	equip_flg_off[bx],ax	;save new flags
	mov	ax,4c00h
	int	21h			;return to dos

code	ends
end	begin
