/*-------------------------- structures ---------------------------*/
/* registers for callbios */
struct regs {
	int	ax;
	int	bx;
	int	cx;
	int	dx;
	int	si;
	int	di;
	int	ds;
	int	es;
	int	flags;
};
struct xypair {					/* x and y coordinate pair */
	int x;
	int y;
};
struct xyzpoints {				/* x y and z coordinates */
	int x;
	int y;
	int z;
};

/* ida file prefix */
struct	ida_p {
	int	version;				/* file version */
	int	video_mode;				/* display mode */
	int	raster_width;			/* width of raster in bytes */
	struct xypair size;			/* x and y size */
	struct xypair pos;			/* x and y position */
};

/* blt descriptor */
struct	blt_d {
	int	source_off;				/* source raster address */
	int	source_seg;
	int	source_width;			/* source raster width */
	struct xypair from_pos;		/* position within source raster */
	struct xypair to_pos;		/* position within dest raster */
	struct xypair size;			/* x and y size */
	int	mask;					/* color mask */
};
/* blt word descriptor */
struct	bltw_d {
	int color;					/* color mask */
	struct xypair to_pos;		/* position within dest raster */
	struct xypair size;			/* x and y size */
};
/* ellipse descriptor */
struct ell_par {
	struct xypair center;	/* center of ellipse */
	struct xypair radius;	/* radii of ellipse */
	struct xypair begin;	/* points on line connected to center which */
	struct xypair end;		/* point toward start and end of arc */
};
struct ell_d {
	char even_color;		/* color for the ellipses */
	char odd_color;			/* (odd color ignored for hollow) */
	char count;				/* number of parameter sets */
	struct ell_par *coords;	/* pointer to ellipse parameter sets */
};
/* lines descriptor */
struct line_d {
	char color;				/* color for the lines */
	char count;				/* number of points to connect */
	char mode;				/* 0 = chained, 1 = separated */
	struct xypair *coords;	/* list of points */
};
/* points descriptor */
struct pnt_d {
	char color;				/* color for the points */
	char count;				/* number of points */
	struct xypair *coords;	/* list of points */
};
/* polygon descriptor */
struct pgon_d {
	char even_color;		/* even pixel color */
	char odd_color;			/* odd pixel color */
	char count;				/* number of points  to connect */
	struct xypair *coords;	/* coordinates of corners */
};

struct move_d {					/* movement descriptor - posn, speed, accel */
	struct xypair speed;		/* current speec */
	struct xypair maxspeed;		/* maximum speed allowed */
	struct xypair minspeed;		/* minimum speed allowed */
	struct xypair accel;		/* accelleration (change of speed) */
	struct xypair current;		/* current position */
	struct xypair previous;		/* previous position */
};
struct time_d {					/* timing descriptor - when to show & move */
	int firstshow;				/* first frame object shows */
	int firstmove;				/* first frame object moves */
	int lastshow;				/* last frame object shows */
	char posn_frame;			/* whether last detector is frame or posn */
	struct xypair lastmove;		/* last frame or last position */
};
struct parts_d{				/* describes pieces of object of one type */
	char ptype;					/* type - (line, etc) - see equates below */
	int count;					/* # of parts of this type */
	int *point;					/* ptr to data for these parts */
};
struct object_d {				/* whole object descriptor */
	struct move_d *moveptr;		/* movement of this whole object */
	struct time_d *timeptr;		/* timing of this object */
	int partscount;				/* number of parts lists (ptr to follow) */
	struct parts_d *partsptr;	/* pointer to data about what makes object */
};

/* equates for partsptr.ptype */
#define copy 1		/* copy rectangle data */
#define rect 2		/* fill rectangle data */
#define pgon 3		/* polygon data */
#define line 4		/* line data */
#define fell 5		/* filled ellipse data */
#define hell 6		/* hollow ellipse data */
#define pnt  7		/* points data */

/*------------------- equates for flags on stack ----------------------*/
#define carryfl		1
#define zerofl		0x40
#define dirfl		0x400
#define signfl		0x80

/************************************************************************
                         interrupt equates                              *
************************************************************************/

#define dos_int 			0x21	/* interrupt for most dos functions */
#define i_io_int			0x10	/* ibm compatible video io interrupt */
#define i_kb_int			0x16	/* ibm compatible keyboard interrupt */

#define ms_i_int			0xee	/* mindset unique io interrupt */
#define ms_v_int			0xef	/* mindset graphics */
