/*
	dc.c - changes foreground/background colors of screen display

	use:	Invoking dc will result in display of white characters on
			a black background.  To adjust foreground(character) and
			background colors, use cursor arrow keys (up/down, left/right).

			When the desired foreground/background color combination is
			displayed, press the <RETURN> key to exit dc, and set these
			colors.
	
	cursor 
	keys:	up/down		- depressing one of these keys causes color index
						  to increase/decrease index in 16 color palette.
						  Selected color will be displayed as foreground/
					      background color (see left/right keys).

			left/right	- depressing one of these keys causes background/
						  foreground(character) colors to be affected by
						  up/down keys.  These keys act as toggles, pressing
						  the key causes all subsequent up/down colors to
						  display as background/foreground.
*/

#include	<cuser.inc>

#define	black		0x0000 + 0000	/* 16 color palette	*/
#define	dkblue		0x1000 + 0500	/* MINDSET RGB + COMPOSITE bitmasks	*/
#define	dkgreen		0x2000 + 0050
#define	dkcyan		0x3000 + 0550
#define	dkred		0x4000 + 0005
#define	dkmagent 	0x5000 + 0505
#define	dkyellow	0x6000 + 0055
#define	dkwhite		0x7000 + 0555
#define	dkgray		0x8000 + 0222
#define	blue 		0x9000 + 0700
#define	green		0xa000 + 0070
#define	cyan 		0xb000 + 0770
#define	red  		0xc000 + 0007
#define	magenta		0xd000 + 0707
#define	yellow		0xe000 + 0077
#define	white		0xf000 + 0777

#define	FALSE		0				/* left cursor key selected background  */
#define	TRUE		1				/* right cursor key selected foreground */


main()
{

int	key;			/* scan code of key pressed */
int	index;			/* current index into 16 color palette */
int	front;			/* if TRUE, then foreground color, else background */
	
					/* palette is original 16 color palette	*/
static int palette[16] = {
 black,   white,  dkblue,dkgreen, dkcyan, dkred, dkmagent, dkyellow,
 dkwhite,dkgray,    blue,  green,   cyan,   red,  magenta,   yellow
	}; 

					/* newpalette has user selected first two entries	*/
					/* first entry (newplatte[0]) is background color	*/
					/* second entry (newpalette[1]) is foreground color	*/	
static int newpalette[16] = {
 black,   white,  dkblue,dkgreen, dkcyan, dkred, dkmagent, dkyellow,
 dkwhite,dkgray,    blue,  green,   cyan,   red,  magenta,   yellow
	}; 

					/* display program banner and instructions			*/
printf("       *** DC - Display Color selection program ***\n\n");
printf("Use arrow keys: up/down    - select color\n");
printf("                left/right - select background/foreground\n\n");
printf("Press <RETURN> key to exit and retain displayed colors\n");

setpalette(0, 16, 0, &palette);		/* set up 16 color palette			*/

key = 0;			/* initialize key to 0								*/
index = 0;			/* initialize color index							*/
front = TRUE;		/* initialize to foreground							*/

while(key != 28)	/* if key = 28, then user has pressed <RETURN>		*/
	{
	getkey(&key);	/* get key scan code from keyboard					*/
	key = key & 0x0ff;
	
	switch(key)
		{
		case 72:	/* UP arrow, so increment color index				*/
				index = (index + 1) & 0x000f;
				break;
    	case 80:	/* DOWN arrow, so decrement color index				*/
				index = (index - 1) & 0x000f;
				break;
		case 75:	/* LEFT arrow, so set background color				*/
				front = FALSE;
				break;
		case 77:	/* RIGHT arrow, so set foreground color				*/
				front = TRUE;
				break;
		default:
		}
	
					/* set foreground/background color from palette		*/
	newpalette[front] = palette[index];
					/* write new palette to display						*/
	setpalette(0, 16, 0, &newpalette);
	}	

exit();				/* exit with user selected foreground/background	*/
}
