#include <cuser.inc>
/*----------------------- dos_file_create -----------------------------*/
int dos_file_create(offset, segment, attrib)
	int	offset;					/* offset of pointer to name */
    int segment;                /* segment of pointer to name */
	int	attrib;					/* attribute of file */
{
	struct regs myregs;

	myregs.dx = offset;
	myregs.cx = attrib;
	myregs.ax = 0x3c00;
	myregs.ds = segment;    		/* seg for file name pointer */
	callbios(dos_int, &myregs);
	if (myregs.flags & carryfl)
		return(0);					/* return failed */
	else return(-1 * myregs.ax);			/* return the handle */
}

/*----------------------- dos_file_open ------------------------------*/
int dos_file_open(offset, segment, access)
	int offset;					/* ofset of pointer to name */
    int segment;                /* segment of pointer to name */
	int	access;					/* 0=read, 1=write, 2=both */
{
	struct regs myregs;

	myregs.dx = offset;
	myregs.ax = 0x3d00 + access;
	myregs.ds = segment;   
	callbios(dos_int, &myregs);
	if (myregs.flags & carryfl)
		return(0);				/* return failed */
	else return(-1 * myregs.ax);		/* return the handle */
}

/*----------------------- dos_file_close -------------------------------*/
dos_file_close(handle)
	int	handle;					/* file handle returned from open */
{
	struct regs myregs;

	myregs.bx = handle;
	myregs.ax = 0x3e00;
	callbios(dos_int, &myregs);
	return(-1 * myregs.ax);
}

/*----------------------- dos_file_read -------------------------------*/
dos_file_read(handle, offset, segment, nbytes)
	int	handle;				/* file handle returned from open */
	int offset;				/* offset of where to read data to */
	int segment;            /* segment of where to read data to */
	int nbytes;				/* number of bytes to read */
{
	struct regs myregs;

	myregs.ax = 0x3f00;
	myregs.bx = handle;
	myregs.dx = offset;
	myregs.ds = segment;
	myregs.cx = nbytes;
	callbios(dos_int, &myregs);
	return(-1 * myregs.ax);				/* return number of bytes read */
}

/*----------------------- dos_file_write -----------------------------*/
dos_file_write(handle, offset, segment, nbytes)
	int	handle;				/* file handle returned from open */
	int offset;				/* offset of where to write data from */
	int segment;			/* segment of where to write data from */
	int nbytes;				/* number of bytes to write */
{
	struct regs myregs;

	myregs.ax = 0x4000;
	myregs.bx = handle;
	myregs.dx = offset;
	myregs.ds = segment;
	myregs.cx = nbytes;
	callbios(dos_int, &myregs);
	return(-1 * myregs.ax);				/* return number of bytes written */
}

/*----------------------- dos_file_delete -----------------------------*/
dos_file_delete(offset, segment)
	int offset;				/* offset of where to write data from */
	int segment;			/* segment of where to write data from */
{
	struct regs myregs;

	myregs.ax = 0x4100;
	myregs.dx = offset;
	myregs.ds = segment;
	callbios(dos_int, &myregs);
	return(-1 * myregs.ax);				/* return number of bytes written */
}


/*----------------------- dos_file_lseek -----------------------------*/
dos_file_lseek(handle, method, lo_offset, hi_offset)
    int handle;             /* file handle of file to position pointer */
    int method;             /* typew of positioning: 0=abs, 1=rel, 2=end+off*/
	int lo_offset;          /* low 16 bits of 32 bit integer for number */
                            /* of bytes to move pointer */
    int hi_offset;          /* high 16 bits of 32 bit integer to move pointer*/
{
	struct regs myregs;

	myregs.ax = 0x4200 + method;
    myregs.bx = handle;
    myregs.cx = hi_offset;
	myregs.dx = lo_offset;
	callbios(dos_int, &myregs);
	return(-1 * myregs.ax);				/* return number of bytes written */
}
