title EVB routine

name evb

dgroup group data
data segment word public 'data'
	extrn frame_count: word
old_addr	dd	?
data ends


pgroup group prog
prog segment byte public 'prog'
assume cs:pgroup

public vblank, evbinit, stopevb

include macro186.inc

;--------------------------------------------------------------------------
;
;	Vblank routine - 
;
;--------------------------------------------------------------------------
vblank proc far

	push	ax
	push	ds
	push	es

	mov	ax, dgroup
	mov	ds, ax


assume ds:dgroup
	inc	frame_count		;increment frame count

;  call old interrupt address if not 0

	mov	ax, word ptr old_addr
	or	ax, word ptr old_addr + 2
	jz	vb_end1

	call	old_addr
vb_end1:

	pop	es
	pop	ds
	pop	ax
	ret
vblank endp

;--------------------------------------------------------------------------
;
;	Early vblank initialization
;
;--------------------------------------------------------------------------
	assume ds:nothing
evbinit proc near

	push	ds
	push	es

	mov	ax,dgroup
	mov	ds,ax
	assume 	ds:dgroup

;  save existing vblank address

	mov	ah,10h			;ms get display int addr
	int	0efh			;mindset video int
	mov	word ptr old_addr,bx	;store offset
	mov	bx,es
	mov	word ptr old_addr+2, bx	;store segment

;  store new interrupt address

	mov	bx,cs
	mov	es,bx			;code seg in es
	mov	bx,offset vblank	;routine addr in bx
	mov	ah,0fh			;ms set display int addr
	int	0efh			;mindset video int

	pop	es
	pop	ds
	ret

evbinit endp

;--------------------------------------------------------------------------
;
;	Turn off early vblank for clean exit to system.
;
;--------------------------------------------------------------------------
	assume ds:nothing
stopevb proc near

	push	ds
	push	es

;  store zeroes to interrupt address ES:[BX]

	mov	bx,0000H		;store 0 to [bx]
	mov	es,bx			;store 0 to es:
	mov	ah,0fh			;ms set display int addr
	int	0efh			;mindset video int

	pop	es
	pop	ds
	ret

stopevb endp

prog ends
end
