         .WIDTH  130
;
;(***********************************************************************)
;(*									*)
;(*  	Copyright (C) 1981, 1982 by National Semiconductor Corporation	*)
;(*									*)
;(*    	National Semiconductor Corporation				*)
;(*	2900 Semiconductor Drive					*)
;(*	Santa Clara, California 95051					*)
;(*									*)
;(*	All Rights Reserved						*)
;(* 									*)
;(*	This software is furnished under a license and may be used	*)
;(*	and copied only in accordance with the terms of such license  	*)
;(*	and with the inclusion of the above copyright notice. This 	*)
;(* 	software or any other copies thereof may not be provided or 	*)
;(*	otherwise made available to any other person. No title to and 	*)
;(*	ownership of the software is hereby transferred.		*)
;(*									*)
;(*	The information in this software is subject to change without   *)
;(*	notice and should not be construed as a commitment by National  *)
;(*	Semiconductor Corporation.					*)
;(*									*)
;(*	National Semiconductor Corporation assumes no responsibility 	*)
;(*	for the use or reliability of its software on equipment 	*)
;(*	configurations which are not supported by National 		*)
;(*     Semiconductor Corporation.					*)
;(*									*)
;(***********************************************************************)
;
;
;       PROGRAM     MON16
;
;       VERSION     2.00
;
;       DATE        31 - JAN - 1983
;
;
;
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
;
;
;
        .MODULE MONINT
;
;     M O N I T O R    I N T E R R U P T S    &   T R A P S.
;       FILE INT.ASM    31-JAN-83
;	  VERSION 2.00
;
;
;     GLOBAL DEFINITIONS
;
        .IMPORTP	MSGENT,ERENT,GETPUT,SPRINTA,SRDLIN
        .IMPORTP	PRINTA,RDLIN,HXTOBN,BNTOHX,MAINLP
        .IMPORT		HEXAN
;
	.EXPORTP	MNEXIT,BPTRT,TRCRT,NMIRT,ABTRT,NVIRT
        .EXPORTP	FPURT,ILLRT,DVZRT,FLGRT,UNDRT,SVCRT
;       TERMINAL RECORD
        .DSECT
INBUF:  .BLKB   64              ; INPUT BUFER
INLM:   .BLKB   4               ; POINTER TO LAST CHARACTER READ
OUTB:   .EQU    INBUF           ; OUTPUT BUFFER (SAME AS INPUT )
OUTLM:  .EQU    INLM            ; POINTER TO LAST BYTE IN OUTB TO BE PRINTED
TRMRLG: .EQU    *               ; TERMINAL RECORD LENGTH
        .ENDSEG
;
;
;     GLOBAL CONSTANTS
;
STALON: .EQU    0               ; STAND ALONE INDICATOR
TRANSP: .EQU    1               ; TRANSPARENT MODE
TRUE:   .EQU    1               ; DEFINE LOGICAL TRUE
FALSE:  .EQU    0               ; DEFINE LOGICAL FALSE
TRMA:   .EQU    0               ; TERMINAL A
TRMB:   .EQU    1               ; TERMINAL B
NSFBR:  .EQU    14              ; NUMBER OF SOFTWARE BREAK-POINTS
PSR_U:  .EQU    8               ; U BIT IN PSR
PSR_T:  .EQU    1               ; T BIT IN PSR
PSR_S:  .EQU    9               ; S BIT IN PSR
PSR_P:  .EQU    10              ; P BIT IN PSR
PSRS:   .EQU    H'200           ; PSR S NUMBER
PSRT:   .EQU    2               ; PSR T NUMBER
BPR_BE: .EQU    29              ; BE BIT IN BPR REG OF MMU
BPR_FTCH: .EQU	29		; BREAK POINT ON FETCH BIT OF MMU BPR REG
BPR_R:	.EQU	28		; BREAK POINT ON READ
MSR_NT: .EQU    25              ; NT BIT IN MSR
MSR_FT:	.EQU	23		; FT BIT IN MSR
BPTC:   .EQU    H'F2            ; BPT INSTRUCTION
RXPC:	.EQU	H'32		; RXP INSTRUCTION
PUTI:	.EQU	1		; PUT INDICATION FOR GET_PUT PROCEDURE
CFGN:	.EQU	20		; CFG NUMBER IN GET_PUT PROCEDURE
;
;
;     ASCII CHARACTERS
;
;
CNTRA:  .EQU    H'1             ; CNTR/A
CNTRT:  .EQU    H'14            ; CNTR/T
CR:     .EQU    H'0D            ; RETURN
LF:     .EQU    H'0A            ; LINE FEED
DOT:    .EQU    H'2E            ; DOT
COMMA:  .EQU    H'2C            ; COMMA CHARACTER
SPACE:  .EQU    H'20            ; SPACE CHARACTER
;
;
;     GLOBAL VARIABLES
;
STATIC: .EQU    H'8000
        .STATIC                 ; DEFINE STATIC EREA
;
OPMOD:  .BLKB   1               ; OPERATION MODE VARIABLE
OPHND:	.BLKB	1		; OPERATION MODE HAND_SHAKING
MON_USR: .BLKB  1               ; MONITOR/USER TIME FLAG
PNDF:	.BLKB	1		; PENDING INTERRPTS FLAG
DTRM:   .BLKB   4               ; POINTER TO DEFULT TERMINAL BUFFER
NDTRM:  .BLKB   1               ; #  OF DEFULT TERMINAL
SVCPF:	.BLKB	1		; SVC FLAG FOR READ WRITE ROUTINE FOR MOVUS
ERRTYP: .BLKB   1               ; ENTRY TYPE
L:      .BLKB   1	 	; SAVE COMMAND NUMBER
SCRCH1: .BLKB   4               ; SCRACH 1
SCRCH2: .BLKB   4               ; SCRACH 2
STRTADR: .BLKB  4               ; SAVE RESET ADDRESS
ENDADR:  .BLKB  4               ; SAVE END INTERRUPT ROUTINE ADDRESS
SEREA:
SVFP:   .BLKB   4               ; SAVE FP
SVUS:   .BLKB   4               ; SAVE US
SVIS:   .BLKB   4               ; SAVE IS
SVPC:   .BLKB   4               ; SAVE PC
SVMOD:  .BLKB   4               ; SAVE MOD
SVPSR:  .BLKB   4               ; SAVE PSR
SVR7:   .BLKB   4*7             ; SAVE R
SVR0:   .BLKB   4               ; SAVE R0
;
SVMSR:  .BLKB   4               ; SAVE MSR
TMPPSR:
TMPMSR:	.BLKB	4		; TEMPORAY SAVE MSR
SVBPR0: .BLKB   4               ; SAVE BPR0
SVBPR1: .BLKB   4               ; SAVE BPR1
HEAPP:  .BLKB   4               ; HEAP POINTER
HEAPE:  .BLKB   4               ; HEAP END
HEAPS:  .BLKB   4               ; HEAP BEGIN
;
CONFIG: .BLKB   1               ; CONFIGURATION BYTE
MSRWF:	.BLKB	1		; MSR WRITTEN FLAG
;
MNFP:   .BLKB   4               ; SAVE MONITOR FP
MNMSR:	.BLKB	4		; SAVE MONITOR MSR
MNSP:   .BLKB   4               ; SAVE MONITOR SP
MNSPH:	.BLKB	4		; MONITOR HIGH SP
MNPSR:  .BLKB   2               ; MONITOR PSR
BRKAR:  .BLKB   NSFBR*4         ; SOFT-BPR ARRAY
STEPFLG: .BLKB  1               ; STEP FLAG
ACKFLG: .BLKB   1               ; ACKNOLEDGE FLAGE
CXPFLG: .BLKB   1               ; CXP COMMAND COUNTER
	.BLKB	1		; ** FOR ELAINMENT **
STPCNT: .BLKB   4               ; STEP COUNTER
ACTBRK: .BLKB   4               ; # OF CURRENT BREAK
INS:    .BLKB   NSFBR           ; ARRAY OF BRPR INSTRUCTION SAVE
OLDPC:  .BLKB   8               ; SAVE OLD PC,US,IS,MOD IN CXP COMMAND
ENDPC:	.BLKB	4		; PC OF INSERTED BPT ON STACK
ENDPC1:	.BLKB	4		; PC OF BEGIN WHEN CXP ALSO
CNTRLB:	.BLKB	1		; CNTRL/B CHARACTER STARTS EVERY COMMAND
CNTRLL: .BLKB	1		; CNTRL/L CHARACTER START FAST LOAD MESSAGE
CNTRLS: .BLKB	1		; CNTRL/S CHARACTER HOLD SCREEN
CNTRLQ: .BLKB	1		; CNTRL/Q CHARACTER RESUME SCREEN
STUADD: .BLKB   16              ; STU COMMAND VERIABLE ADDRESS
MONUSR1: .BLKB	1		; TEMP SAVE OF MON_USER FLAG
RSTINT:	.BLKD	1		; SAVE RESET VALUE OF INTBASE
JMPRAM: .BLKD	2
;
TERM1:  .BLKB   TRMRLG          ; TERINAL 1 RECORD
TERM2:  .BLKB   TRMRLG          ; TERMINAL 2 RECORD
        .ENDSEG
STACKL: .EQU    H'300           ; STACK EREA END RELATIVE TO BEGIN OF SB
;
;
CNFMMU: .EQU    2               ; MMU BIT IN CONFIGURATION
MONT:   .EQU    0               ; FLAG MONITOR TIME
USERT:  .EQU    1               ; FLAG USER TIME
PNDMOD: .EQU    2               ; FLAG TO DELAY INTERRUPTS
;
;
;       USART  CONSTANTS
;
IOBEG:   .EQU   H'C00000        ;  IO BEGIN ADDRESS
USRTCS:  .EQU   2               ; USRT CONTROL & STATUS PORT
USRTCS2: .EQU   USRTCS+H'40     ; USART # 2
DATAP:   .EQU   0               ; USRT DATA INPUT OUTPUT PORT
OUT_RDY: .EQU   0               ; TX-RDY BIT OF STATUS WORD
IN_RDY:  .EQU   1               ; RX-RDY BIT OF STATUS
SWITCHP: .EQU	IOBEG+H'30	; DIP SWICHES PORT ADDRESS
USRT_BN: .EQU	6		; BIT NUBER THAT SELECT 7 OR 8 BIT PER CHAR
;
;  I C U   R E G.
;
ICUADR:	 .EQU	H'FFFE00	; ICU REGISTER  0 ADDRESS
ICU16:	 .EQU	ICUADR+16*2	; ICU REG 16
ICU22:	 .EQU	ICUADR+22*2	; ICU REG 22
ICU24:	 .EQU	ICUADR+24*2	; ICU REG 24
ICU28:	 .EQU	ICUADR+28*2	; ICU REG 28
SW_MMU:  .EQU	H'20		; MMU EXISTS BIT ON=MMU OFF=NO MMU
SW_FPU:	 .EQU	H'10		; FPU EXISTS BIT ON=FPU OFF=NO FPU
;
;
;   R E S E T    R O U T I N E
;
;
RESET:
MODTB:  .EQU    H'20 	    ; MODULE  TABLE ADDRESS
INTTAB: .EQU    H'1438      ; INTERRUPT TABLE ADDRESS (LINK TABLE ADDRESS OF
			    ; MODULE MONTAB) 
			    ; IF ANY CHANGE IS MADE THAT ADDRESS SHOULD BE
			    ; CHANGED TO THE NEW VALUE OF LINK TABLE ADDRESS
			    ; OF MODULE MONTAB
   	BICPSRW	PSR_S			; {STOP EXECUTION IF PSR_U ON}
        MOVD    MODTB,R1
        LPRW    MOD,R1                  ; INIT MOD REG
        LPRD    SB,0(R1)                ; INIT SB REG
        MOVD    INTTAB,R1
        LPRD    INTBASE,R1              ; INTBASE:=ADDRESS OF INTTAB
	MOVD	R1,RSTINT		; SAVE RESET INTBASE
        ADDR    STACKL(SB),R1           ; SP:=ADDRESS OF STACK EREA
        LPRD    SP,R1                   ;   ( SP:=SB+STACKL)
   	MOVD	R1,MNSPH		; MNSPH := R1 {SET HIGH OF MON SP}
        ADDR    256(R1),SVIS            ; SVIS:=SP+256 INIT USE IS
        ADDR    TERM1,R7                ; DTRM:=TERM1
        MOVD    R7,DTRM
        MOVQW   TRMA,NDTRM              ; NDTRM:=TRMA (* SET TERM A AS DEFAULT
   					; SVCPF := FALSE;
        MOVQD   STALON,OPMOD            ; OPERATION MOD := STAND ALONE
   					; TERM A NO ECHO NO CR LF
   					; MON_USR := MONITOR  PNDF := FALSE
        MOVQD   0,SVPC                  ; USER_PC := 0
   	MOVQD	0,SVPSR			; USER_PSR := 0
	MOVD	H'11130C02,CNTRLB	; INIT CNTRL/B CNTRL/L CNTRL/S CNTRL/Q
        MOVZBD  NSFBR+1,R1              ; INIT SOFTWARE BPR ARRAY
RST1:   MOVQD   0,BRKAR-4[R1:D]         ; FOR I:=1,NSFBR DO BRKAR:=0
        ACBB    -1,R1,RST1
        ADDR    BEGINA:W,STRTADR        ; SAVE START ADDRESS
        ADDR    ENDINT:W,ENDADR         ; SAVE END INTERRUPT ROUTINE ADDRESS
;
;    INIT ICU
;
   	MOVQB	0,@ICU16		; 8 BITS MOD,COUT OUTPUT,SQUARE WAVE
   	MOVQB	0,@ICU22		; COUNTER HALT {ENABLE WRINIG OF
   					;    STARTING VALUE
   	MOVZBD	@SWITCHP,R1		; LOAD SWITCH FOR BAUD RATE
   	ANDB	H'0F,R1
   	MOVB	ICUTB:W[R1:W],@ICU24	; ICU24 := ICUTB[R1],ICU25 := 0; LOAD
    	MOVB	ICUTB+1:W[R1:W],@ICU24+2;     COUNTING VALUE;
   	MOVB	ICUTB:W[R1:W],@ICU28	; ICU28 := ICUTB[R1],ICU29 := 0; INIT
   	MOVB	ICUTB+1:W[R1:W],@ICU28+2;     COUNTING VALUE;
   	MOVB	H'54,@ICU22		; NOT PRESCALED,L COUNTER RUNNIG,
   					;  L COUNTER OUTPUT TO PIN COUT!
;

        MOVD    USRTCS+IOBEG,R1         ; {INIT USARTS}
   	MOVMW	RUSRT:W,TERM1,3
   	TBITB	USRT_BN,@SWITCHP	; IF SUART_BITS/CHAR=7 THEN
;   	BFS	RST2			;   CHANGE MODE WORD
   	BR	RST2			;   *** TEMP FOR I.04 ***
   	MOVB	H'4A,TERM1+4
RST2:   MOVQD   -6,R2                   ; FOR I=1,6 DO
RST8:   MOVB    TERM1+6[R2:B],0(R1)   ;  USRT1_CONTROL:=RUSRT[I];
        MOVB    TERM1+6[R2:B],(USRTCS2-USRTCS):W(R1)
                                        ;  USRT2-CONTROL:=RUSRT[I];
        ACBB    1,R2,RST8               ; END;
        MOVD    H'1B10000,SVMSR         ; INIT SVMSR SET TU BEN UB FT UT
   	MOVD	H'90000,MNMSR		; MONITOR MSR := TU,AO
   	MOVB	@SWITCHP,R1		; GET MMU & FPU BITS FROM SWITCHES
   	COMB	R1,R1			; CONVERT TO CFG BYTE
   	ANDB	SW_MMU+SW_FPU,R1
   	ASHB	-3,R1
   	MOVZBD	CFGN,R2			; PREPARE CALL TP GET_PUT
   	MOVB	PUTI,TOS
   	MOVQD	0,TOS			; GET_PUT (GET,0,CFG);
   	CXP	GETPUT
   	TBITB	CNFMMU,CONFIG		; IF MMU THEN
   	BFC	RST14
   	LMR	MSR,MNMSR		;    LOAD MSR;
RST14:  CXP     MAINLP                  ; TYPE RESET MESSAGE
;
RUSRT:  .BYTE   0,0,0,H'40,H'4E,H'37    ; INIT USRT SEQUENCE
;
;  DIVIDE FACTOR FOR ICU COUNTER TO GENERATE USRT CLOCK
;   N := 1.84MHZ/(BAUD_RATE*16*2)
;          1.84 HZ IS CRYSTAL FREQUENCY (DIVIDE BY 12 TO GET 9600)
;          THE 16 FACTOR BEACUSE USRT DIVIDE BY 16
;	   THE 2 FACTOR BEACUSE THE SQUARE WAVE CHANGES TWICE IN CYCLE
;     N-1 MUST BE WRITTEN TO ICU REG.
ICUTB:  .WORD	2,5,7,11		; 19200,9600,7200,4800
   	.WORD	15,23,28,31		;  3600,2400,2000,1800
   	.WORD	47,95,191,383		;  1200,600,300,150
   	.WORD   429,523,767,1151	;   134,110,75,50
;
;  E R R O R    E X I T
;
ENMI:   .EQU    -8                      ; ERROR NMI
ENVI:   .EQU    -7                      ; ERROR NVI
EFPU:   .EQU    -6                      ; ERROR FPU
EDVZ:   .EQU    -5                      ; ERROR DIVIDE BY ZERO
EUND:   .EQU    -4                      ; ERROR UN-DEFINED INSTRUCTION
EFLG:   .EQU    -3                      ; ERROR FLAG TRAP
EBPT:   .EQU    -2                      ; ERROR BPT
EILL:   .EQU    -1                      ; ERROR ILLEGAL INSTRUCTION
ETRC:   .EQU    0                       ; ERROR TRACE TRAP
EXTR:   .EQU    1                       ; ERROR EXTERNAL ABORT
EPRT:   .EQU    2                       ; ERROR PROTECTION
ENVL:   .EQU    3                       ; ERROR INVALIED
EABT:   .EQU    4                       ; ERROR ABORT
EUSR:   .EQU    5                       ; USER ERROR
ESVC:   .EQU    9                       ; SVC ERROR
EVIO:   .EQU    11                      ; VIO PROTOCOL ERROR
EPND:   .EQU    6                       ; PENNDING INTERRUPT ERROR
ERTS:	.EQU	13			; RUN TIME SYSTEM ERROR.
;
BEGINA:
;
ERROR2: BSR     MNENTR                ; SAVE USER STATUS LOAD MONITOR STATUS
ERROR3:	BSR	BRKRMVA:W		; BRKRMV {BREAK REMOVE ROUTINE}
        MOVXBD  ERRTYP,R1               ; LOAD ERROR PARAMETER
   	MOVD	SVR0-4,R0		; LOAD NUMBER TO BE PRINTED WITH ERROR
ERROR4: CXP     ERENT                   ; JUMP TO ERROR IM COMMAND LOOP
;
;
;   M N E N T R     (* M O N I T O R    E N T E R    R O U T I N E *)
;
;
MNENTR: MOVD    0(SP),SCRCH2            ; SAVE RETURN ADDRESS OF THIS ROUTINE
        CMPQB   MONT,MON_USR            ; IF MON_USER<> MONT THEN
   					;	{ MONITOR TIME  }
        BEQ     MNENTR3:W               ; BEGIN
        MOVZWD    8(SP),SVMOD           ;   SAVE MOD  OF USER PROGRAM
        MOVW    10(SP),SVPSR            ;   SAVE PSR
        MOVD    4(SP),SVPC              ;   SAVE PC
        ADDR    12(SP),SVIS             ;   SAVE IS
        BISPSRW PSRS                    ;   PSR-S :=1
        ADDR    0(SP),SVUS              ;   SAVE US
        SPRD    FP,SVFP                 ;   SAVE FP
        ADDR    SVR0+4,SCRCH1
        LPRD    SP,SCRCH1               ;   SP:= ADDRESS OF SVR0
        SAVE    [R0,R1,R2,R3,R4,R5,R6,R7]       ; SAVE R0-R7
                                        ; END;
        LPRW    PSR,MNPSR               ; LOAD MONITOR PSR
        LPRD    SP,MNSP                 ; LOAD MONITOR SP
        RESTORE [R0,R1,R2,R3,R4,R5,R6,R7] ; LOAD MONITOR R0-R7
        LPRD    FP,MNFP                 ; LOAD MONITOR FP
        MOVD    SCRCH2,0(SP)            ; PUT RETURN ADDRESS ON STACK
   	TBITB	CNFMMU,CONFIG		; IF CNG.MMU ON  THEN
   	BFC	MNENTR3		;   BEGIN
   	CMPQB	TRUE,MSRWF		;     IF MSR WAS NOT SAVED THEN
   	BEQ	MNENTR2		;	BEGIN
   	SMR	MSR,TMPMSR		;	  SAVE MSR;
   	LMR	MSR,MNMSR		;	  MSR := MONITOR MSR;
MNENTR2:				;       END;
   	MOVD	TMPMSR,SVMSR
  	ORB	H'90,SVMSR+2		;     SVMSR.BEN := 1 SVMSR.FT := 1
        CBITB   MSR_NT,SVMSR            ;     MSR.NT := 0
MNENTR3:				;   END;
        ADDR    OUTB(R7),R6             ; INIT DTRM.OUTB
   	MOVQB	FALSE,MSRWF		; MSRWF := FALSE {FOR MONITOR TIME ABT}
        RET     0
;
;
;   M N E X I T     (*  M O N I T O R   E X I T     R O U T I N E  *)
;
;
MNEXIT:
   	MOVQB	FALSE,PNDF			; RESET PENDING INTERRUPT FLAG
        SPRD    FP,MNFP                 ; SAVE MONITOR FP
        SPRW    PSR,MNPSR               ; SAVE MONITOR PSR
   	LPRD	SP,MNSPH		; MON SP := MON.SP HIGH
        SAVE    [R0,R1,R2,R3,R4,R5,R6,R7] ; SAVE MONITOR R0-R7
        SPRD    SP,MNSP                 ; SAVE MONITOR SP
        MOVQB   USERT,MON_USR           ; MON_USR:= USER TIME
        BISPSRW PSRS                    ; SET S BIT IN PSR {LOAD US}
        LPRD    SP,SVUS                 ; LOAD USER  US
        LPRD    FP,SVFP                 ; LOAD FP
        BICPSRW PSRS                    ; PSR-S:=0
        ADDR    SVR7,SCRCH1
        LPRD    SP,SCRCH1               ; SP:= ADDRESS SVR7
        RESTORE [R0,R1,R2,R3,R4,R5,R6,R7] ; LOAD R0-R7
        LPRD    SP,SVIS                 ; LOAD IS
        CBITB   PSR_P,SVPSR             ; CLEAR P BIT IN PSR
        MOVW    SVPSR,TOS               ; PREPARE RETURN PUSH PSR
        MOVW    SVMOD,TOS               ; PUSH MOD
        MOVD    SVPC,TOS                ; PUSH PC
MNEXT2: TBITB   CNFMMU,CONFIG           ; IF CONFIG.MMU THEN
        BFC     MNEXT1		;   BEGIN
   	SMR	MSR,MNMSR		;     MNMSR := MONITOR MSR;
        LMR     MSR,SVMSR		;     MSR := SVMSR {LOAD MSR}
   	MOVQB	FALSE,MSRWF		;     MSRWF := FALSE {SAVE NSR FLAG}
MNEXT1: RETT    0			;   END;
;
;
;   MULTI INTERRUPS CHECK & REMOVE
;
;
MULTICH:
   	CMPQB	MONT,MON_USR		;IF  NOT MONITOR_TIME  AND PSR_U = 0
   	BEQ	MUL3			;THEN
   	TBITB	PSR_U,10(SP)		;BEGIN
   	BFS	MUL3
        CMPD    4(SP),STRTADR           ;   IF USER_PC>=MONITOR BEGIN
        BLT     MUL3                  ;   THEN
        CMPD    4(SP),ENDADR            ;     IF USER_PC<=MONITOR END
        BGT     MUL3                  ;     THEN
MUL2:   ADJSPB  (-4)                    ;       REMOVE LAST INTERRUPT
        RETT    0                       ;       RETURN TRAP
MUL3:   RET     0			;   ELSE ; {RETURN TO CALLER}
;
;  ENTRY TO DELAY INTERRUPTS WHILE SVC TIME
;
MULPND: MOVQB	TRUE,PNDF               ; FLAG PENNDING INTERRUPT
   	CMPQB   PNDMOD,MON_USR          ; IF NOT PENNDING MOD
        BNE     MULTICH                 ; THEN GOTO MULTICH
        BR      MUL2                    ; ELSE  DELETE INTERRUPT
;
;
;
;		   B R E A K    R E M O V E
;
;     REMOVES  BPT INSTRUCTION OF EACH ACTIVE BREAK POINTS
;
;
MESG:   .BYTE   CR,"B"," "	; BREAK POINT MESSAGE
;
;
BRKRMVA:MOVQB	FALSE,R4	; TESTBP := FLASE
   	BR 	RMV0
BRKRMV: MOVQB	TRUE,R4		; TESTBP := TRUE
RMV0:	CMPQB	MONT,MON_USR	; IF MONITOR TIME RETURN
	BEQ	RMVEX
        MOVQB   MONT,MON_USR    ; MON_USER:= MONITOR TIME
   	MOVQD   0,R3            ; BRKN:=0
   	MOVD    SVPC,R1         ; R1:=USE_PC
        MOVZBD  NSFBR,R0        ; FOR I:= NSFBR DOWNTO 1 DO
RMV1:   MOVD    BRKAR-4[R0:D],R2 ;BEGIN
        TBITB   BPR_BE,R2       ;    R2:=BRKAR[I];
        BFC     RMV2          ;    IF BRKAR[I].BE THEN
        ANDD    H'FFFFFF,R2     ;   BEGIN
   	CMPB    BPTC,INS-1[R0:B];    IF BRKAK[I] <> BPT THEN {NOT MULTI BREAK}
        BEQ	RMV15
        MOVSUB    INS-1[R0:B],0(R2);         M(BRKAK[I].ADDR):=INS[I];
                		;    (* RELOAD INSTRUCTION TO MEMORY *)
RMV15:  CMPD    R1,R2           ;     IF BRKAR[I].ADDR=USER_PC THEN
        BNE     RMV2          ;     BEGIN
        MOVD    R0,R3           ;       BRKN:=I
RMV2:   ACBB    -1,R0,RMV1      ; END FOR
   	CMPQB	TRUE,R4		; IF  NOT TESTBP THEN
   	BEQ	RMV3		;   RETURN
RMVEX: 	RET	0
RMV3:  	CMPQB   0,R3            ; IF BESTBP AND BPRN>1 THEN (* SOFTWARE BP *)
        BEQ     RMV4          ; BEGIN
   	MOVD    MESG,0(R6)      ;    OUTB(DTRM.OUTLM):=CR LF B
        MOVB    HEXAN+1[R3:B],3(R6) ;  OUTB(DTRM.OUTLM):= ASCII (BRKN)
        ADDQD   4,R6            ;    DTRM.OUTLM:=DTRM.OUTLM+7
        CXP     MSGENT          ; END (GOTO MESSAGE PRINT)
RMV4:   CMPD	R1,ENDPC	; IF USE_PC = RETURN FROM CXP THEN
        BNE     RMVEX         ; BEGIN
;	CMPB	0(R1),BPTC	; IF 0(SVPC) = BPTC THEN
   	TBITB	PSR_U,SVPSR	;  {DO MOVE OR MONUS ACCORDING TO PSR_U}
   	BFC	RMV4T	
   	MOVUSB	0(R1),SCRCH2
   	BR	RMV4E
RMV4T: 	MOVB	0(R1),SCRCH2
RMV4E:	CMPB	BPTC,SCRCH2	;  {END OF CXP OR END OF PROGRAM}
   	BNE	RMVEX
RMV6:   MOVMD   OLDPC,SVPC,2    ;    SVPC:=OLDPC SVUS:=OLDUS SVIS:=OLDIS SVMOD
        MOVD    " RET",2(R6)    ;    OUTB(DTRM.OUTLM):= " RET"
   	MOVD	ENDPC1,ENDPC	;    RELOAD ENDPC OF BEGIN
        ACBB    -1,CXPFLG,RMV5 ;   CXPFLG:=CXPFLG-1;
        MOVD    " END",2(R6)    ;    IF CXPFLG=0 "B END" {END OF PROGRAM}
RMV5:   MOVW    MESG,0(R6)      ;    OUTB(DTRM.OUTLM):=CR LF B
        ADDQD   6,R6            ;    DTRM.OUTLM:=DTRM.OUTLM+7
        CXP     MSGENT          ; END  (GO TO PRINT MESSAGE )
;
;
;   B P T     ROUTINE
;
;
BPTRT: BSR	MNENTR		; MNENTR {SAVE USER STATUS & LOAD MONITOR }
	BSR	BRKRMV		; BRKRMV {REMOVE BPT'S AND FIND ACTUAL BREAK}
BPTER:  MOVQD   EBPT,R1         ; ELSE
        BR      ERROR4          ;    ERROR(EBPT)
;
;
;   T R A C E    T R A P    R O T I N E
;
;
GETI:   .EQU    0               ; GET PARAMETER FOR GETPUT ROUTINE
NOTRC:  .EQU    0               ; NO TRACE IN STEP_FLAG
STPN:   .EQU    1               ; STEP N FLAG
STU:    .EQU    2               ; STU FLAG
STW:    .EQU    3               ; STW FLAG
STBRK:  .EQU    4               ; TRACE OF GO
TRCRT: MOVQB	PNDMOD,MON_USR	;	PENDING INTERRUPTS FLAG ON.
TBITB   CNFMMU,CONFIG   ; IF MMU THEN
        BFC     TRCM1		;
        CMPQB	TRUE,MSRWF	;   IF NOT MSRWF THEN {MULTI EXCEPTION WRITE}
   	BEQ	TRCM0
   	SMR     MSR,TMPMSR      ;         TMPMSR:=MSR REG OF MMU
   	MOVQB	TRUE,MSRWF	;	  MSRWF := TRUE {MSR WRITTEN FLAG}
TRCM0: 	MOVD	TMPMSR,SVMSR
	LMR	MSR,MNMSR	;    MSR:=MONITOR MSR
   	BSR	MULTICH		; MULTI INTERRUPT CHECK
   	BSR	MMUBR_CH:W	; MMU_BREAK_POINT_CHECK;
   	BR	TRCT1
TRCM1: 	BSR     MULTICH         ; MULTI-INTERRUPT-CHECK
TRCT1:  BSR 	MNENTR		; EMNENTR {SWITCH TO MONITOR TIME}
TRCT2: 	MOVZBD  STEPFLG,R1      ; R1:=STEP_FLAG
TRCCS:  CASEB   TRCCT[R1:B]   ; CASE OF STEP_FLAG
TRCCT:  .BYTE   TRCER-TRCCS     ;  NO MONITOR TRACE
        .BYTE   TRCSTPN-TRCCS   ;  STEP  N
        .BYTE   TRCSTU-TRCCS    ;  STU
        .BYTE   TRCSTU-TRCCS    ;  STW
        .BYTE   TRCGO-TRCCS     ;  TRACE AFTER GO
        .BYTE   TRCGO2-TRCCS    ;  TRACE AFTER STN
        .BYTE   TRCGO2-TRCCS    ;  TRACE AFTER STU
        .BYTE   TRCGO2-TRCCS    ;  TRACE AFTER STW
TRCER:  MOVQB   ETRC,ERRTYP     ; 0 : ERROR_TYPE:=ETRC
        BR      ERROR3
TRCGO:                          ; 1 : TRACE OF GO
        CBITB   PSR_T,SVPSR     ;       PSR_T:=0
TRCGO2: MOVB	BPTC,SCRCH2
   	TBITB	PSR_U,SVPSR	;        MOVE OR MONSU ACCORDING TO PSR_U
   	BFC	TRCGOT
   	MOVSUB  SCRCH2,0(ACTBRK)  ;       M(PC):=BPTC (* BPT INSTRCTION
   	BR	TRCGOE
TRCGOT:	MOVB	BPTC,0(ACTBRK)
TRCGOE: ADDQB   (-STBRK),STEPFLG ;      STEP_FLAG:=NO MONITOR TRACE
        CMPQB   NOTRC,STEPFLG   ;       IF GO & STEP TRACE GOTO TRCT1
        BNE     TRCT2           ;       ELSE
TRC2:   BR	TRC5:W
TRCSTPN:                        ; 2 : TRACE STEP N
        ACBD	-1,STPCNT,TRC5:W ;       STEP_COUNT:=STEP_COUNT-1
   				;       IF STEP_COUNT>0
   				;       THEN RETURN TO USER
   				;       ELSE
TRC3:   MOVD    " TRC",2(R6)    ;            OUTB:=" TRC"
TRC33: 	BSR	BRKRMV		;	     REMOVE B.P. {EXIT TO COMMAND LOOP}
   	BR	RMV5		;	     EXIT TO WRITE MESSAGE
TRCSTU: 			; 3 : STU/STU
        MOVQB   GETI,TOS        ;       MNENTR (* SAVE USER STATUS
        MOVZBD  STUADD+3,R2     ;       GETPUT (GET,STUADD.TYPE,STUADD.NO)
        MOVD    STUADD,TOS
        MOVQB   0,3(SP)
        CXP     GETPUT          ;       (* FIND VARIABLE USING GET-PUT ROUTINE
        ANDD    STUADD+4,R1     ;       VAR:=VAR AND MASK
        CHECKD  R0,STUADD+8,R1  ;       F=VAR>=LIMIT.LOWER AND VAR<=LIMIT.UPPER
        CMPQB   STU,STEPFLG
        BFS     TRC6          ;       IF NOT F THEN
        BEQ     TRC3            ;         IF STEPFLG=STU GOTO TRC3
TRC5:   CMPQB	TRUE,PNDF	;         ELSE IF WAS PENNDING INTERRUPT
   	BNE	TRC55		;           ERROR PENNDING.
   	MOVQB	EPND,ERRTYP	;	
   	BR	ERROR3
TRC55: 	BSR	MNEXIT:W	;	  ELSE RETURN TO USER
TRC6:   BNE     TRC3            ;       ELSE IF STEPFLG<>STU GOTO TRC3
        BR	TRC5		;               ELSE RETURN TO USER
;
;
;  N M I     R O U T I N E
;
;
;
NMIRT: TBITB   CNFMMU,CONFIG   ; IF NO MMU THEN ERROR NMI
        BFC     ERNMI:W
   	CMPQB	MONT,MON_USR	; IF NMI IN MONTIOR TIME THEN ERROR;
   	BEQ	ERNMI:W
        CMPQB	TRUE,MSRWF	;   IF NOT MSRWF THEN {MULTI EXEPTION WRITE}
   	BEQ	NMIM0
   	SMR     MSR,TMPMSR      ; 	MSRT:=MSR REG OF MMU
   	MOVQB	TRUE,MSRWF	;	  MSRWF := TRUE {MSR WRITTEN FLAG}
        LMR     MSR,MNMSR       ; 	MSR:=DISABLE ALL
NMIM0:  CMPD	0(SP),SCRCH1    ; {MMU BREAK TEST }
   	BNE	NMI2		; IF RETURN ADDRESS = SAVED RETURN ADDRESS
   	TBITB	PSR_U,6(SP)	;  AND PSR_U = 0 THEN {WAS MMU BEEAK}
   	BFS	NMI2		;    REMOVE LAST ENTRY FROM STACK
   	ADJSPB  (-12)
   	XORB	H'60,TMPMSR+1	; CONVERT STATUS TO FETCH
   	LMR	BPR0,SVBPR0	; RELOAD BREAK POINTS REG.
   	LMR	BPR1,SVBPR1
	BR	NMI20
NMI2:   BSR     MULPND          ; MULTICH;
NMI20:	CMPQW   0,TMPMSR        ; IF MSR.STSTUS:=0 GOTO ERROR NMI
        BEQ     ERNMI:W
        TBITB   2,TMPMSR        ; IF B.P. GO TO NMI3
        BFS     NMI3
        TBITB   13,TMPMSR       ; IF NOT NS TRACE
        BFC     ERNMI:W        ; THEN GO ERROR NMI
   	BSR	MMUBR_CH:W	; MMU_BREAK_POINT_CHECK;
   	BSR	MNENTR
   	BR      TRC3		; ELSE  GOTO TRCA3
   				;   {REMOVE BPT AND GOTO COMMAND LOOP}
NMI3:   BSR     MNENTR		; MNENTR;
;       EXTSD   TMPMSR,R3,H'C0  ;  GET B.P NUMBER
        EXTSD   TMPMSR,R3,6,1   ;  GET B.P NUMBER
        MOVD    BRMSG[R3:D],2(R6) ;OUTB:=BRMSG[BP] GOTO NMI2
        BSR	BRKRMVA		; REMOVE SOFTWARE B.P.
   	BR	RMV5		; PRINT MESSAGE AND EXIT
BRMSG:  .BYTE   " 0  "
        .BYTE   " 1  "
ERNMI:  BSR     MULPND          ; MULTICH; {CHECK PENNDING MODE}
   	MOVB    ENMI,ERRTYP     ;
        CMPQB   MONT,MON_USR	; IF USET TIME ERROR(NMI)
        BNE     ERROR2
        MOVQB   1,ACKFLG        ; ELSE RESET NMI
        CXP     MAINLP          ; {ACKFLG:=1}
;
;
;  A B O R T   R O U T I N E
;
;
ABTRT: TBITB   CNFMMU,CONFIG   ; IF NO MMU THEN ERROR ABT
        BFC     ERABT:W
        CMPQB	TRUE,MSRWF	;   IF NOT MSRWF THEN {MULTI EXEPTION WRITE}
   	BEQ	ABTM0
        SMR     MSR,TMPMSR      ; TMPMSR:=MSR REG OF MMU
   	MOVQB	TRUE,MSRWF	;	  MSRWF := TRUE {MSR WRITTEN FLAG}
	LMR	MSR,MNMSR	; MSR:=MONITOR MSR
ABTM0:  TBITB	PSR_U,6(SP)	; IF PSR_U = FALSE THEN
   	BFS	ABR1		; BEGIN
	ADDR	MNEXT1,SCRCH1	;   IF ABORT.ADDRESS = RETT OF MONITOR
   	CMPD	0(SP),SCRCH1	;     THEN REMOVE RETURN ADDRESS OF MONITOR;
   	BNE	ABR1
   	ADJSPB  (-8)
ABR1:	BSR	MULTICH		; MULTICH;
	BSR	MNENTR		; ENTR MONITOR TIME
ABR15: 	TBITB	0,TMPMSR	; IF NOT TRANSLATION ERROR
	BFC	ABR4		; THEN GOTO ABR4
	TBITB	4,TMPMSR	; IF NON_VALIED 1 THEN ERROR (INV)
	BFS	ABR2		; ELSE
	TBITB	5,TMPMSR	;   IN NON_VALIED 2 THEN ERROR (INV)
	BFS	ABR2		
	MOVQB	EPRT,ERRTYP	; ELSE  ERROR(PRT)
	BR	ERROR3
ABR2:	MOVQB	ENVL,ERRTYP	
	BR	ERROR3
ABR4:	TBITB	1,TMPMSR	; IF MSR(1)=1
   	BFC	ERABT		; THEN
   	MOVQB	EXTR,ERRTYP	;   ERROR(EXTR)
   	BR	ERROR3		; ELSE
ERABT:	MOVQB	EABT,ERRTYP	;   ERROR(ABT);
	BR	ERROR3
;
;
; E R R O R S    &   T R A P S
;
;
NVIRT:	MOVQB	ENVI,ERRTYP
	BR	ERROR2
FPURT:	MOVQB	EFPU,ERRTYP
	BR	ERROR2
ILLRT:	MOVQB	EILL,ERRTYP
	BR	ERROR2
DVZRT:	MOVQB	EDVZ,ERRTYP
	BR	ERROR2
FLGRT:	MOVQB	EFLG,ERRTYP
	BR	ERROR2
UNDRT:	MOVQB	EUND,ERRTYP
	BR	ERROR2
;
;
; SVC   R O U T I N E S
;
;
SVCLM:	.BYTE	13,3
SVCRT:	MOVB	MON_USR,MONUSR1	; TEMP SAVE MON_USR
	MOVQB	PNDMOD,MON_USR		; FLAG PENNDING MODE:= TRUE
   	MOVW	6(SP),TMPPSR		; SAVE PSR
	SAVE	[R0,R3]
	ANDD	H'FF,R0			; LIMIT R0
	CHECKB	R0,SVCLM,R0
	BFC	SVCS			; IF SVC#> SVCLM ERROR
SVCER:	MOVB	ESVC,ERRTYP
   	RESTORE	[R0,R3]
	BR	ERROR2
SVCS:	CASEW	SVCTB[R0:W]		; BRANCH TO SVC[R0]
SVCTB:	.WORD	SVC3-SVCS
	.WORD	SVC4-SVCS
	.WORD	SVC5-SVCS
	.WORD	SVC6-SVCS
	.WORD	SVC7-SVCS
	.WORD	SVC8-SVCS
   	.WORD	SVC9-SVCS
   	.WORD	SVC10-SVCS
   	.WORD	SVC11-SVCS
   	.WORD	SVC12-SVCS
   	.WORD	SVC13-SVCS
;
ENDINT:
;
;  S V C 3    R E A D N
;
;
SVC3:	TBITB	PSR_U,TMPPSR		; IF PSR_U THEN SVCPF := TRUE
   	BFC	SVC33
   	MOVQB	TRUE,SVCPF
SVC33:	MOVW	R2,TOS
	MOVB	R3,TOS			; RDLIN(R2,R3,R1);
	MOVD	R1,TOS
	CXP	RDLIN
	MOVZWD	TOS,R2			; R2:= # OF READ CHAR
	CMPQB	5,R0			; OF SVC=TERMINAL READ (SVC8)
	BNE	SVCEX			; THEN
;	MOVW	R2,-2(R1)		; BUFFER[0]:=# OF READ CHAR
   	TBITB	PSR_U,TMPPSR
   	BFS	SVCT1
   	MOVW	R2,-2(R1)
   	BR	SVCE1
SVCT1: 	MOVW	R2,SCRCH2
   	MOVSUW	SCRCH2,-2(R1)
SVCE1: 	ADDQD	4,R2			; ADD 4 EXTRA VIO BYTES.
SVCEX:	RESTORE	[R0,R3]
	ADDQD	1,0(SP)			; {SKIP SVC INSTRUCTION. }
SVCEXT:	MOVQB	FALSE,SVCPF
	CMPQB	TRUE,PNDF		; IF PENNDING INTERRUPT EXISTS
	BNE	SVCEX1		; THEN
SVCEX2:	MOVB	EPND,ERRTYP		; ERROR(PND)
	BR	ERROR2			; ELSE
SVCEX1:	MOVB	MONUSR1,MON_USR		; FLAGE USER TIME
	RETT	0
;
;
;  S V C 4   P R I N T N
;
;
SVC4:	TBITB	PSR_U,TMPPSR		; IF PSR_U THEN SVCPF := TRUE
   	BFC	SVC44
   	MOVQB	TRUE,SVCPF
SVC44:	MOVD	R1,TOS			; PRINTA (R1,R1+R2,R3)
	MOVD	R2,TOS
	ADDD	R1,TOS
	MOVB	R3,TOS
	CXP	PRINTA
	BR	SVCEX
;
;
;  S V C 5   V I R T U A L    I / O
;
;
LINLIM:	.EQU	60	; MAX # OF CHARACTERS IN A LINE
NLIN:	.EQU	16	; MAX BYTES TO BE SEND ON ONE LINE
;
;
SVC5:	SAVE	[R1,R4,R5,R6,R7]
	MOVD	DTRM,R7			; REPEAT
VO1:	MOVZBD	NLIN,R3			;   IF N>LINLIM N1:=LINLIM
	CMPD	R3,R2
	BLE	VO2			;   ELSE N1:=N;
	MOVD	R2,R3
VO2:	ADDR	OUTB+1(R7),R6		;   OUTLM:=2;
	MOVB	"V",-1(R6)		;   OUTB[1]:="V"
;	MOVZBD	0(R1),TOS		;   FOR I:=1 TO N1 DO
VO3:	TBITB	PSR_U,TMPPSR
   	BFS	SVCT2
   	MOVB	0(R1),SCRCH2
   	BR	SVCE2
SVCT2:	MOVUSB	0(R1),SCRCH2
SVCE2: 	MOVZBD	SCRCH2,TOS
	MOVW	H'200,TOS		;     BNTOHX (BUFFER(I),2,0);
	CXP	BNTOHX
	ADDQD	1,R1			; {BUFFER POINTER:=BUFFER POINTER+1}
	ADDQD	-1,R2			;     N:=N-1;
	ACBD	-1,R3,VO3		;   END; FOR
	MOVB	CR,0(R6)		;   OUTB[I]:= CR;
	ADDQD	1,R6			;   OUTLM:=OUTLM+1;
	CXP	SPRINTA			;   SPRINTA {PRINT OUTB}
	BSR	RDACK:W			;   READ_ACKNOLEDGE
	CMPQD	0,R2
	BLT	VO1			;   UNTIL N:=0;
	MOVD	16(SP),R1		; {BUFFERR POINTER:=1}
VI1:	ADDR	OUTB+2(R7),R6		; OUTLM:=3;
	MOVW	"V"+CR*H'100,OUTB(R7)	; OUTLM[1]:= "V" CR;
	CXP	SPRINTA			; SPRINTA {WRITELN("V CR"}
	BSR	RDACK:W			; BSR READ_ACKNOLEDGE
	CMPQB	TRUE,R6			; IF ENDF<>1
	BNE	VIOEX:W			; THEN
VI3:	ADJSPB	5			;   REPEAT
	MOVD	R5,TOS			;     HXTOBN (X,INBU[I],2);
	ADDR	1(R5),TOS
	CXP	HXTOBN
	MOVD	TOS,R5			;     {UPDATE SCN}
	CMPQB	TRUE,TOS
;	MOVB	TOS,0(R1)		;     BUFFER[K]:=X
   	TBITB	PSR_U,TMPPSR
   	BFS	SVCT3
   	MOVB	TOS,0(R1)
   	BR	SVCE3
SVCT3: 	MOVB	TOS,SCRCH2
   	MOVSUB	SCRCH2,0(R1)
SVCE3:	ADJSPB	-3
	BEQ	VI1			;     IF ENDF GOTO VI1
	ADDQD	1,R2			;     N:=N+1;
	ADDQD	1,R1			;     K:=K+1
	BR	VI3			; UNTIL ENDF
VIOEX:	RESTORE	[R1,R4,R5,R6,R7]
	BR	SVCEX
;
;	RDACK READ_ACKNOLEDGE ROUTINE.
;	READ INPUT LINE
;	  IF INPUT IS V,CR   ENDF=1 (R6=1)
;	  IF INPUT IS V	     ENDF=0
;	  IF NOT V AT FIRST CHAR ERROR VIO
;
RDACK:	CXP	SRDLIN			; RDLIN(-LINLIM,NRD,NDRTM,INBUF)
	MOVD	INLM(R7),R6		; INLM:=NRD
RDACK1:	CMPB	"V",0(R5)		; FOR I:=1,NRD DO
	ADDQD	1,R5
	BNE	RDACK4		;  IF INBUF[I]= "V"
	MOVQB	1,R6			;  THEN ENDF:=0
	CMPB	CR,0(R5)		;     IF INBUF[I]= V,CR
	BNE	ACKEX			;     THEN ENDF:=1;
	MOVQB	0,R6			;     END;
ACKEX:	RET	0			;   ELSE
RDACK4:	CMPB	-1(R5),SPACE		;     IF INBUF[I]> SPACE
	BGT	RDACK6
	CMPD	R5,R6			;	OR I>NRD
	BLT	RDACK1			;     THEN
RDACK6:	ADJSPB	(-4)			;	ERROR VIO
	RESTORE	[R1,R4,R5,R6,R7]
	MOVB	EVIO,ERRTYP
RDACK7:	RESTORE [R0,R3]
	BR	ERROR2			;  END FOR;
;
;
;   S V C 6    U S E R     E R R O R
;
;
SVC6:	MOVB	ERTS,ERRTYP		; RUN TIME ERROR
   	BR	RDACK7
;
;
;   S V C 7   G E T   H E A P   P A R A M E T E R S
;
;
SVC7:	MOVD	R1,HEAPP	; SAVE HEAP POINTER ADDRESS
   	MOVD	HEAPS,R1	; LOAD HEAP START
   	MOVD	HEAPE,R2	; LOAD HEAP END
	BR	SVCEX
;
;
; S V C 8     T E R M I N A L    I / O
;
;
SVC8:	CMPQB	STALON,OPMOD	; IF OPMOD=STAND ALONE GO VIO
	BEQ	SVC5
;	CMPQB	0,0(R1)		; IF OPERATIN IS READ
   	TBITB	PSR_U,TMPPSR
   	BFC	SVCT4
   	MOVUSB	0(R1),SCRCH2
   	CMPQB	0,SCRCH2
	ADDQD	4,R1
;	MOVZWD	-2(R1),R2	; R2:= N
   	MOVUSW	-2(R1),SCRCH2
   	MOVZWD	SCRCH2,R2
   	BR	SVCE4
SVCT4:	CMPQB	0,0(R1)
   	ADDQD	4,R1
   	MOVZWD	-2(R1),R2
SVCE4: 	MOVQB	TRMA,R3		; IO TO TERM A
	BEQ	SVC3		; THEN SVC3(BUFFER[2],N)
	BR	SVC4		; ELSE SVC4(BUFFER[3],N)
;
;
; S V C 9      U S E R     S V C
;
;   SET PSR(U)=1 ANS RETURNS
;
SVC9:	CMPD	H'55555555,R1
   	BNE	SVCER
   	CBITB	PSR_U,14(SP)	; SET U BIT IN PUSHED PSR
   	BR 	SVCEX
;
;
; S V C  1 0    E M U L A T E   T R A P
;
; TRAP TO DESCRIPTOR R2. RELEASE R3 BYTES FROM STACK
;
;
SVC10:
	CMPD	H'55555555,R1	; IF CODE NOT 5555555 ERROR
	BNE	SVCER
	ADJSPB	-12		; REMOVE SAVE R0,R3 AND RET PC
	MOVD	TOS,SCRCH2	; SAVE RET MODULE & PSR
SVC10A:	ANDW	H'0CFD,SCRCH2+2	; CLEAT S U T BITS IN PSR.
	MOVW	R2,SCRCH2	; STORE RETURN MODULE NUMBER
	MOVZWD	R2,SCRCH1	; GET MODLUE NUMBER
	LSHD	-16,R2		; GET OFFSET
	ADDD	8(SCRCH1),R2	; RET PC :=  START PC+ OFFSET
	MOVD	R2,SCRCH1
	RESTORE	[R0,R1,R2,R3,R4,R5,R6,R7]
	MOVD	SCRCH2,TOS	; PUSH MOD & PSR OF TARGET
	MOVD	SCRCH1,TOS	; PUSH TARGET PC
	BR	SVCEXT
;
;
; S V C 1 1    T R A P  W I T H    O U T   S A V E
;
;
SVC11:	CMPD	H'55555555,R1	; IF CODE NOT 5555555 ERROR
	BNE	SVCER
	ADJSPB	-8		; REMOVE SAVE R0,R3
	ADDB	SVCLM+1,R0	; RESTORE OLD VALUE OF R0
	MOVD	4(SP),SCRCH2
	SAVE	[R0,R1,R2,R3,R4,R5,R6,R7]
	BR 	SVC10A
;
;
; S V C  1 2   C O P Y   I N T E R R U P T     T A B L E
;
;
SVC12:	CMPD	H'55555555,R1	; IF CODE NOT 5555555 ERROR
	BNE	SVCER
	SPRD	INTBASE,R0
	LPRD	INTBASE,R2	; FOR I := 1 TO R3 DO
SVC12A:	MOVD	-4(R0)[R3:D],-4(R2)[R3:D] ; NEW_INTTAB[I] := INTTAB[I]
	ACBD	-1,R3,SVC12A	; END;
	BR	SVCEX
;
;
; S V C  1 3    R E P L A C E    E N T R Y     I N   I N T E R R U P T
;               T A B L E
;
;
SVC13:	CMPD	H'55555555,R1	; IF CODE NOT 5555555 ERROR
	BNE	SVCER
	SPRD	INTBASE,R0	; FOR I := 1 TO R3
	MOVD	R0[R3:D],TOS	; SAVE OLD ENTRY
	MOVD	R2,R0[R3:D]	; REPLACE ENTRY N {N IS IN R3 VALUE IN R2}
	MOVD	TOS,R2		; OLD ENTRY TO R2
	BR	SVCEX
;
;
;
;   TEST IF THERE IS  MMU BREAK POINT ON CURRENT INSTRUCTION.
;
;
;
MMUBR_CH:
   	MOVD	4(SP),SVPC
   	MOVW	10(SP),SVPSR		; SAVE PC AND PSR
   	MOVW	TMPMSR+2,SCRCH1+2	; SCRCH1 := TMPMSR AND H'FFFF0000
   	MOVQW	0,SCRCH1
   	CBITB	MSR_FT,SCRCH1		; CLEAR FT BIT
   	ORB	H'10,SCRCH1+2		; SET BE BIT
   	LMR	MSR,SCRCH1		; LOAD USER MSR DISABLE FLOW TRACE.
   	SMR	BPR0,SVBPR0
   	SMR	BPR1,SVBPR1		; SAVE BEAK POINTS
   	TBITB	BPR_FTCH,SVBPR0		; IF BP0.FETCH OR BP1.FETCH THEN
   	BFS	BRCH2			;  BEGIN
   	TBITB	BPR_FTCH,SVBPR1
   	BFC	BRCHEX:W
BRCH2: 	MOVD	SVBPR0,SCRCH1		;     BP0.R := 1
   	MOVD	SVBPR1,SCRCH2
   	SBITB	BPR_R,SCRCH1
   	SBITB	BPR_R,SCRCH2
   	LMR	BPR0,SCRCH1
   	LMR	BPR1,SCRCH2		;     BP1.R := 1
   	MOVQB	FALSE,MSRWF
   	TBITB	PSR_U,SVPSR		;     IF PSR_U THEN
   	BFC	BRCH4			;       READ FROM USER NEXT INSTRUCTION
   	ADDR	BRCHA,SCRCH1		;
	MOVUSB	0(SVPC),SCRCH2		;     ELSE
BRCHA: 	BR	BRCH5			;       READ FROM SUP NEXT INSTRUCTION
BRCH4:	ADDR	BRCH5,SCRCH1
	MOVB	0(SVPC),SCRCH2
BRCH5: 	LMR	BPR0,SVBPR0		;     IF WAS'NT NMI THEN
   	LMR	BPR1,SVBPR1		;        RELOAD MMU STATUS
   	MOVQB	TRUE,MSRWF
BRCHEX:	LMR	MSR,MNMSR		;   END;
   	RET	0
;
;
;
