/* $NetBSD: ics2101var.h,v 1.1 1995/07/19 19:58:50 brezak Exp $ */
/*
 * Copyright (c) 1994, 1995 Ken Hornstein.  All rights reserved.
 * Copyright (c) 1995 John T. Kohl.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Ken Hornstein.
 * 4. The name of the authors may not be used to endorse or promote products
 *      derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *	$Id: ics2101var.h,v 1.1 1995/07/19 19:58:50 brezak Exp $
 */

#define ICSMIX_LEFT		0		/* Value for left channel */
#define ICSMIX_RIGHT		1		/* Value for right channel */

struct ics2101_softc {
	u_short sc_selio;		/* select I/O address */
	u_short sc_dataio;		/* data I/O address */
	int sc_flags;			/* Various flags */
#define ICS_FLIP	0x01		/* flip channels */
	u_char sc_setting[ICSMIX_CHAN_5+1][2]; /* current settings */
	u_char sc_mute[ICSMIX_CHAN_5+1][2];/* muted? */
};

void ics2101_mix_attenuate __P((struct ics2101_softc *, u_int, u_int, u_int));
void ics2101_mix_mute __P((struct ics2101_softc *, u_int, u_int, u_int));
