/*	$NetBSD: isadmavar.h,v 1.10 1997/08/04 22:13:33 augustss Exp $	*/

/*-
 * Copyright (c) 1997 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Jason R. Thorpe of the Numerical Aerospace Simulation Facility,
 * NASA Ames Research Center.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the NetBSD
 *	Foundation, Inc. and its contributors.
 * 4. Neither the name of The NetBSD Foundation nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#define MAX_ISADMA	65536

#define	DMAMODE_WRITE	0
#define	DMAMODE_READ	1
#define	DMAMODE_LOOP	2

struct proc;

void	   isa_dmacascade __P((struct device *, int));

int	   isa_dmamap_create __P((struct device *, int, bus_size_t, int));
void	   isa_dmamap_destroy __P((struct device *, int));

int	   isa_dmastart __P((struct device *, int, void *, bus_size_t,
	       struct proc *, int, int));
void	   isa_dmaabort __P((struct device *, int));
bus_size_t isa_dmacount __P((struct device *, int));
int	   isa_dmafinished __P((struct device *, int));
void	   isa_dmadone __P((struct device *, int));

int	   isa_dmamem_alloc __P((struct device *, int, bus_size_t,
	       bus_addr_t *, int));
void	   isa_dmamem_free __P((struct device *, int, bus_addr_t, bus_size_t));
int	   isa_dmamem_map __P((struct device *, int, bus_addr_t, bus_size_t,
	       caddr_t *, int));
void	   isa_dmamem_unmap __P((struct device *, int, caddr_t, size_t));
int	   isa_dmamem_mmap __P((struct device *, int, bus_addr_t, bus_size_t,
	       int, int, int));

int	   isa_drq_isfree __P((struct device *, int));

void      *isa_malloc __P((struct device *, int, size_t, int, int));
void	   isa_free __P((void *, int));
int	   isa_mappage __P((void *, int, int));
