/************************************************************
Copyright 1994 by Eduardo Horvath
Copyright 1987 by Sun Microsystems, Inc. Mountain View, CA.

                    All Rights Reserved

Permission  to  use,  copy,  modify,  and  distribute   this
software  and  its documentation for any purpose and without
fee is hereby granted, provided that the above copyright no-
tice  appear  in all copies and that both that copyright no-
tice and this permission notice appear in  supporting  docu-
mentation,  and  that the names of Sun or MIT not be used in
advertising or publicity pertaining to distribution  of  the
software  without specific prior written permission. Sun and
M.I.T. make no representations about the suitability of this
software for any purpose. It is provided "as is" without any
express or implied warranty.

SUN DISCLAIMS ALL WARRANTIES WITH REGARD TO  THIS  SOFTWARE,
INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
NESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL SUN BE  LI-
ABLE  FOR  ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,  DATA  OR
PROFITS,  WHETHER  IN  AN  ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION  WITH
THE USE OR PERFORMANCE OF THIS SOFTWARE.

********************************************************/

#include	"amiga.h"
#include	"keysym.h"

/*
 *	XXX - Its not clear what to map these to for now.
 *	keysyms.h doesn't define enough function key names.
 */


#ifndef	XK_L1
#define	XK_L1	XK_Cancel
#define	XK_L2	XK_Redo
#define	XK_R1	NoSymbol
#define	XK_R2	NoSymbol
#define	XK_R3	NoSymbol
#define	XK_L3	XK_Menu
#define	XK_L4	XK_Undo
#define	XK_R4	NoSymbol
#define	XK_R5	NoSymbol
#define	XK_R6	NoSymbol
#define	XK_L5	XK_Insert
#define	XK_L6	XK_Select
#define	XK_R7	NoSymbol
#define	XK_R8	XK_Up
#define	XK_R9	NoSymbol
#define	XK_L7	XK_Execute
#define	XK_L8	XK_Print
#define	XK_R10	XK_Left
#define	XK_R11	XK_Home
#define	XK_R12	XK_Right
#define	XK_L9	XK_Find
#define	XK_L10	XK_Help
#define	XK_R13	NoSymbol
#define	XK_R14	XK_Down
#define	XK_R15	NoSymbol
#endif

static KeySym AmigaMap[] = {
	NoSymbol,	NoSymbol,		/* 0x00 */
	XK_Escape,	XK_Escape,		/* 0x1 */
	XK_1,		XK_exclam,		/* 0x2 */
	XK_2,		XK_quotedbl,		/* 0x3 */
	XK_3,		XK_numbersign,		/* 0x4 */
	XK_4,		XK_dollar,		/* 0x5 */
	XK_5,		XK_percent,		/* 0x6 */
	XK_6,		XK_asciicircum,		/* 0x7 */
	XK_7,		XK_ampersand,		/* 0x8 */
	XK_8,		XK_asterisk,		/* 0x9 */
	XK_9,		XK_parenleft,		/* 0xa */
	XK_0,		XK_parenright,		/* 0xb */
	XK_minus,	XK_underscore,		/* 0xc */
	XK_equal,	XK_plus,		/* 0xd */
	XK_BackSpace,	XK_BackSpace,		/* 0xe */
	XK_Tab,		NoSymbol,		/* 0xf */
	XK_q,		XK_Q,			/* 0x10 */
	XK_w,		XK_W,			/* 0x11 */
	XK_e,		XK_E,			/* 0x12 */
	XK_r,		XK_R,			/* 0x13 */
	XK_t,		XK_T,			/* 0x14 */
	XK_y,		XK_Y,			/* 0x15 */
	XK_u,		XK_U,			/* 0x16 */
	XK_i,		XK_I,			/* 0x17 */
	XK_o,		XK_O,			/* 0x18 */
	XK_p,		XK_P,			/* 0x19 */
	XK_bracketleft,	XK_braceleft,		/* 0x1a */
	XK_bracketright,XK_braceright,		/* 0x1b */
	XK_Return,	XK_Return,		/* 0x1c */
	NoSymbol,	NoSymbol,		/* 0x1d */
	XK_a,		XK_A,			/* 0x1e */
	XK_s,		XK_S,			/* 0x1f */
	XK_d,		XK_D,			/* 0x20 */
	XK_f,		XK_F,			/* 0x21 */
	XK_g,		XK_G,			/* 0x22 */
	XK_h,		XK_H,			/* 0x23 */
	XK_j,		XK_J,			/* 0x24 */
	XK_k,		XK_K,			/* 0x25 */
	XK_l,		XK_L,			/* 0x26 */
	XK_semicolon,	XK_colon,		/* 0x27 */
	XK_quoteright,	XK_at,			/* 0x28 */
	XK_quoteleft,	XK_underscore,		/* 0x29 */
	XK_Shift_L,	NoSymbol,		/* 0x2a */
	XK_numbersign,	XK_asciitilde,		/* 0x2b */
	XK_z,		XK_Z,			/* 0x2c */
	XK_x,		XK_X,			/* 0x2d */
	XK_c,		XK_C,			/* 0x2e */
	XK_v,		XK_V,			/* 0x2f */
	XK_b,		XK_B,			/* 0x30 */
	XK_n,		XK_N,			/* 0x31 */
	XK_m,		XK_M,			/* 0x32 */
	XK_comma,	XK_less,		/* 0x33 */
	XK_period,	XK_greater,		/* 0x34 */
	XK_slash,	XK_question,		/* 0x35 */
	XK_Shift_R,	NoSymbol,		/* 0x36 */
	NoSymbol,	NoSymbol,		/* 0x37 */
	XK_Alt_L,	NoSymbol,		/* 0x38 */
	XK_space,	NoSymbol,		/* 0x39 */
	XK_Caps_Lock,	NoSymbol,		/* 0x3a */
	XK_F1,		NoSymbol,		/* 0x3b */
	XK_F2,		NoSymbol,		/* 0x3c */
	XK_F3,		NoSymbol,		/* 0x3d */
	XK_F4,		NoSymbol,		/* 0x3e */
	XK_F5,		NoSymbol,		/* 0x3f */
	XK_F6,		NoSymbol,		/* 0x40 */
	XK_F7,		NoSymbol,		/* 0x41 */
	XK_F8,		NoSymbol,		/* 0x42 */
	XK_F9,		NoSymbol,		/* 0x43 */
	XK_F10,		NoSymbol,		/* 0x44 */
	NoSymbol,	NoSymbol,		/* 0x45 */
	NoSymbol,	NoSymbol,		/* 0x46 */
	XK_Home,	NoSymbol,		/* 0x47 */
	XK_Up,		NoSymbol,		/* 0x48 */
	NoSymbol,	NoSymbol,		/* 0x49 */
	XK_KP_Subtract,	NoSymbol,		/* 0x4a */
	XK_Left,	NoSymbol,		/* 0x4b */
	NoSymbol,	NoSymbol,		/* 0x4c */
	XK_Right,	NoSymbol,		/* 0x4d */
	XK_KP_Add,	NoSymbol,		/* 0x4e */
	NoSymbol,	NoSymbol,		/* 0x4f */
	XK_Down,	NoSymbol,		/* 0x50 */
	NoSymbol,	NoSymbol,		/* 0x51 */
	XK_Insert,	NoSymbol,		/* 0x53 */
	XK_Delete,	NoSymbol,		/* 0x53 */
	NoSymbol,	NoSymbol,		/* 0x54 */
	NoSymbol,	NoSymbol,		/* 0x55 */
	NoSymbol,	NoSymbol,		/* 0x56 */
	NoSymbol,	NoSymbol,		/* 0x57 */
	NoSymbol,	NoSymbol,		/* 0x58 */
	NoSymbol,	NoSymbol,		/* 0x59 */
	NoSymbol,	NoSymbol,		/* 0x5a */
	NoSymbol,	NoSymbol,		/* 0x5b */
	NoSymbol,	NoSymbol,		/* 0x5c */
	NoSymbol,	NoSymbol,		/* 0x5d */
	NoSymbol,	NoSymbol,		/* 0x5e */
	NoSymbol,	NoSymbol,		/* 0x5f */
	XK_backslash,	XK_bar,			/* 0x60 */
	XK_Undo,	NoSymbol,		/* 0x61 */
	XK_Help,	NoSymbol,		/* 0x62 */
	XK_parenleft,	NoSymbol,		/* 0x63 */
	XK_parenright,	NoSymbol,		/* 0x64 */
	XK_KP_Divide,	NoSymbol,		/* 0x65 */
	XK_KP_Multiply,	XK_Print,		/* 0x66 */
	XK_KP_7,	XK_Home,		/* 0x67 */
	XK_KP_8,	XK_Home,		/* 0x68 */
	XK_KP_9,	XK_Home,		/* 0x69 */
	XK_KP_4,	XK_Home,		/* 0x6a */
	XK_KP_5,	XK_Home,		/* 0x6b */
	XK_KP_6,	XK_Home,		/* 0x6c */
	XK_KP_1,	XK_Home,		/* 0x6d */
	XK_KP_2,	XK_Home,		/* 0x6e */
	XK_KP_3,	XK_Home,		/* 0x6f */
	XK_KP_0,	XK_Insert,		/* 0x70 */
	XK_KP_Decimal,	XK_Delete,		/* 0x71 */
	XK_KP_Enter,	NoSymbol,		/* 0x72 */
	NoSymbol,	NoSymbol,		/* 0x73 */
	NoSymbol,	NoSymbol,		/* 0x74 */
	NoSymbol,	NoSymbol,		/* 0x75 */
	NoSymbol,	NoSymbol,		/* 0x76 */
	NoSymbol,	NoSymbol,		/* 0x77 */
	NoSymbol,	NoSymbol,		/* 0x78 */
	NoSymbol,	NoSymbol,		/* 0x79 */
	NoSymbol,	NoSymbol,		/* 0x7a */
	NoSymbol,	NoSymbol,		/* 0x7b */
	NoSymbol,	NoSymbol,		/* 0x7c */
	NoSymbol,	NoSymbol,		/* 0x7d */
	NoSymbol,	NoSymbol,		/* 0x7e */
	NoSymbol,	NoSymbol,		/* 0x7f */
};


KeySymsRec amigaKeySyms[] = {
    /*	map	   minKeyCode	maxKC	width */
    (KeySym *)NULL,	0,	0,	0,
    (KeySym *)NULL,	0,	0,	0,
    (KeySym *)NULL,	0,	0,	0,
    (KeySym *)NULL,	0,	0,	0,
    AmigaMap,		0,	0x72,	2,
};

#define	cT	(ControlMask)
#define	sH	(ShiftMask)
#define	lK	(LockMask)
#define	mT	(Mod1Mask)
#define	m2	(Mod2Mask)

static CARD8 amigamodmap[MAP_LENGTH] = {
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, /* 00-0f */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  cT, 0,  0, /* 10-1f */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  sH, 0,  0,  0,  0,  0, /* 20-2f */
    0,  0,  0,  0,  0,  0,  sH, 0,  mT, 0,  lK, 0,  0,  0,  0,  0, /* 30-3f */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, /* 40-4f */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, /* 50-5f */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, /* 60-6f */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, /* 70-7f */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, /* 80-8f */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, /* 90-9f */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, /* a0-af */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, /* b0-bf */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, /* c0-cf */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, /* d0-df */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, /* e0-ef */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, /* f0-ff */
};

CARD8 *amigaModMap[] = {
	NULL,
	NULL,
	NULL,
	NULL,
	amigamodmap,
};
