/*	$NetBSD: menus.md.fr,v 1.1.2.3 1997/12/15 13:21:18 bouyer Exp $	*/

/*
 * Copyright 1997 Piermont Information Systems Inc.
 * All rights reserved.
 *
 * Written by Philip A. Nelson for Piermont Information Systems Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software develooped for the NetBSD Project by
 *      Piermont Information Systems Inc.
 * 4. The name of Piermont Information Systems Inc. may not be used to endorse
 *    or promote products derived from this software without specific prior
 *    written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY PIERMONT INFORMATION SYSTEMS INC. ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL PIERMONT INFORMATION SYSTEMS INC. BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/* Menu definitions for sysinst. i386 version, machine dependent. */

menu fullpart, title  "  Faite votre choix";
	option "Utilisation de tout le disque", 	    exit, action  {usefull = 1;};
	option "Utilisation d'une partie du disque", exit, action  {usefull = 0;};

menu wdtype, title  "  Choix du type de disque";
	display action { msg_display (MSG_wdtype, diskdev); };
	option "IDE", 	exit;
	option "ESDI", 	exit, action
		{ msg_display (MSG_sectforward);
		  process_menu (MENU_yesno);
		  if (yesno)
			doessf = "sf:";
		};
	option "ST506", exit, action
		{ msg_display (MSG_sectforward);
		  process_menu (MENU_yesno);
		  if (yesno)
			doessf = "sf:";
		};


menu dlgeom, title "  Choisissez une option";
	display action { msg_display (MSG_dlgeom, diskdev, dlcyl, dlhead,
				dlsec, disk->geom[0], disk->geom[1],
				disk->geom[2]);
			};
	option "Utilisation de la gomtrie relle", exit, action {
			dlcyl  = disk->geom[0];
			dlhead = disk->geom[1];
			dlsec  = disk->geom[2];
		};
	option "Utilisation de la gomtrie du disklabel", exit, action {
			disk->geom[0] = dlcyl;
			disk->geom[1] = dlhead;
			disk->geom[2] = dlsec;
		};



menu nobiosgeom, title  "  Choisissez une option", y=16;
	display action { msg_display (MSG_nobiosgeom, diskdev);
			 disp_cur_geom ();
			};
	option "Arrter l'installation",
		action (endwin)  { exit(1); };
	option "Entrer la gomtrie",
		action  { msg_clear(); set_fdisk_geom(); },
		next menu confirmbiosgeom;

menu confirmbiosgeom, y=16;
	display action  {
		extern int mbr_present; /* XXX */
		msg_clear();
		if (mbr_present)
			msg_display_add(MSG_confirmbiosgeom);
		msg_display_add(MSG_badgeom);
		disp_cur_geom ();
	};
	option "Entrer  nouveau la gomtrie",
		action  { msg_clear(); set_fdisk_geom(); };
	option "Continuer l'installation",
		action  {
			if (check_geom())
				return TRUE;
			msg_display (MSG_reentergeom);
			set_fdisk_geom();
		};

menu editparttable, title  "  Choisissez votre partition", exit;
	display action  { msg_display (MSG_editparttable);
			  disp_cur_part (activepart,-1);
			};
	option "Edition de la partition 0",  sub menu editpart,
		action  { editpart = 0; };
	option "Edition de la partition 1",  sub menu editpart,
		action  { editpart = 1; };
	option "Edition de la partition 2",  sub menu editpart,
		action  { editpart = 2; };
	option "Edition de la partition 3",  sub menu editpart,
		action  { editpart = 3; };
	option "Changer d'untit",
		action  { reask_sizemult(); };

menu editpart, title  " Changement ";
	display action { msg_display (MSG_editpart, editpart);
			   disp_cur_part (activepart,editpart);
			   msg_printf_add ("\n");
			};
	option "du type de FS", sub menu chooseid;
	option "du Dbut et de la taille", action 
		{	char buf[40]; int start, size;
			msg_prompt_add (MSG_start, NULL, buf, 40);
			start = NUMSEC(atoi(buf),sizemult,dlcylsize);
			if (sizemult > 1 && start < bsec)
				start = bsec;
			msg_prompt_add (MSG_size, NULL, buf, 40);
			size = NUMSEC(atoi(buf),sizemult,dlcylsize);
			if (sizemult > 1 && start == bsec)
				size -= bsec;
			if (start + size > bsize)
				size = bsize - start;
			if (size < 0) {
				size = 0;
				start = 0;
			}
			part[editpart][START] = start;
			part[editpart][SIZE] = size;
			part[editpart][SET] = 1;
		};
	option "Rendre la partition active", action { activepart = editpart; };
	option "Partition OK", exit;

menu chooseid, title  "  Type de Partition? ";
	option "NetBSD", 	exit,	action
	{
		part[editpart][ID] = 165;
		part[editpart][SET] = 1;
	};
	option "DOS < 32 Meg",	exit,	action
	{
		part[editpart][ID] = 4;
		part[editpart][SET] = 1;
	};
	option "DOS > 32 Meg",	exit,	action
	{
		part[editpart][ID] = 6;
		part[editpart][SET] = 1;
	};
	option "unused",	exit,	action
	{
		part[editpart][ID] = 0;
		part[editpart][SET] = 1;
	};

menu cyl1024;
    display action {
		msg_display(MSG_cyl1024);
	};
	option "Rditer le secteur de boot et le label", exit, action
	{
		/* XXX UGH */
		extern int c1024_resp;

		c1024_resp = 1;
	};
    option "Rditer le label", exit, action
	{
		extern int c1024_resp;

		c1024_resp = 2;
	};
	option "L'utiliser tout de mme", exit, action
	{
		extern int c1024_resp;

		c1024_resp = 3;
	};

menu editfsparts, y=13, exit;
	display action  {
			ask_sizemult();
			msg_display(MSG_fspart, multname);
			disp_cur_fspart(-1, 1);
		};
	option "Changer a", action { editpart = A;}, sub menu edfspart;
	option "Changer b", action { editpart = B;}, sub menu edfspart;
	option "Changer e", action { editpart = E;}, sub menu edfspart;
	option "Changer f", action { editpart = F;}, sub menu edfspart;
	option "Changer g", action { editpart = G;}, sub menu edfspart;
	option "Changer h", action { editpart = H;}, sub menu edfspart;
	option "Changer d'unit", action { reask_sizemult(); };
 

menu md_distcustom, exit, title " Slection des composants";
	display action { show_cur_distsets (); };
	option  "Outils de dveloppement ", 	 action { toggle_getit (3); };
	option  "Jeux", 		 action { toggle_getit (4); };
	option  "Pages de manuel", 	 action { toggle_getit (5); };
	option  "Divers", 	 action { toggle_getit (6); };
	option  "Outils de manipulation de textes", action { toggle_getit (7); };

