/*	$NetBSD: menus.mi.fr,v 1.1.2.4 1997/12/26 02:39:46 perry Exp $	*/

/*
 * Copyright 1997 Piermont Information Systems Inc.
 * All rights reserved.
 *
 * Written by Philip A. Nelson for Piermont Information Systems Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software develooped for the NetBSD Project by
 *      Piermont Information Systems Inc.
 * 4. The name of Piermont Information Systems Inc. may not be used to endorse
 *    or promote products derived from this software without specific prior
 *    written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY PIERMONT INFORMATION SYSTEMS INC. ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL PIERMONT INFORMATION SYSTEMS INC. BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 * Menu system definitions -- machine independent
 *
 * Some menus may be called directly in the code rather than via the 
 * menu system.
 *
 *  This file must be first in the sed command line.
 *
 */

{
#include <stdio.h>
#include <curses.h>
#include "defs.h"
#include "md.h"
#include "msg_defs.h"
#include "menu_defs.h"
}

default x=20, y=12, no exit;

menu netbsd, title "  NetBSD-@@VERSION@@ Programme d'installation";
	display action  { toplevel(); };
	option "Installation de NetBSD sur disque dur",
		action { do_install(); };
	option "Mise  jour de NetBSD sur disque dur",
		action { do_upgrade(); };
	option "Rinstaller ou installer de nouveaux composants",
		action { do_reinstall_sets(); };
	option "Redmarrer l'ordinateur", exit,
		action (endwin) { run_prog("/sbin/reboot"); };
	option "Menu utilitaire", sub menu utility;
	option "Quitter le programme d'installation", exit;

menu utility, title " Utilitaires NetBSD-@@VERSION@@", exit;
	option "Excuter /bin/sh",
		action (endwin) { system("/bin/sh"); };
	option "Configuration du rseau",
		action {
			extern int network_up;

			network_up = 0;
			config_network();
		};
/*	option "Partitioner un disque"; XXX add later.  */
	option "Arrter le systme", exit,
		action (endwin) { run_prog("/sbin/halt"); };

menu yesno, title "  oui ou non?  ";
	option "Oui", exit, action  {yesno = 1;};
	option "Non",  exit, action  {yesno = 0;};

menu noyes, title "  oui ou non?  ";
	option "Non",  exit, action  {yesno = 0;};
	option "Oui", exit, action  {yesno = 1;};

menu ok, title "  Presser entre pour continuer ";
	option "ok", exit;

menu scsigeom1, title "  Choisissez une option";
	display action {
		msg_display (MSG_scsigeom1, diskdev, disk->geom[4],
			dlcyl, dlhead, dlsec, dlcyl*dlhead*dlsec, 
			disk->geom[0], disk->geom[1], disk->geom[2],
			disk->geom[0]*disk->geom[1]*disk->geom[2]);
	};
	option "Utiliser la gomtrie relle", exit, action {
			dlcyl  = disk->geom[0];
			dlhead = disk->geom[1];
			dlsec  = disk->geom[2];
		};
	option "Utiliser la gomtrie du disklabel", exit, action {
			disk->geom[0] = dlcyl;
			disk->geom[1] = dlhead;
			disk->geom[2] = dlsec;
		};
	option "Choisir une gomtrie maison", action { scsi_fake ();}, exit;

menu scsigeom2, title "  Choisissez une option";
	display action {
		msg_display (MSG_scsigeom2, diskdev, disk->geom[4],
			disk->geom[0], disk->geom[1], disk->geom[2],
			disk->geom[0]*disk->geom[1]*disk->geom[2]);
	};
	option " Utiliser la gomtrie relle ", exit, action {
			dlcyl  = disk->geom[0];
			dlhead = disk->geom[1];
			dlsec  = disk->geom[2];
		};
	option "  Choisir une gomtrie maison", action { scsi_fake ();}, exit;

menu scsi_fake, title "  Choisissez une gomtrie";
	option "Gomtrie 1", action { fake_sel = 0; }, exit;
	option "Gomtrie 2", action { fake_sel = 1; }, exit;
	option "Gomtrie 3", action { fake_sel = 2; }, exit;
	option "Gomtrie 4", action { fake_sel = 3; }, exit;
	option "Gomtrie 5", action { fake_sel = 4; }, exit;

menu layout, title  "  Choisissez votre type d'installation  ";
	option "Standard", 	  exit, action { layoutkind = 1; };
	option "Standard avec X", exit, action { layoutkind = 2; };
	option "Personnalise", 	  exit, action { layoutkind = 3; };

menu sizechoice, title  "  Choisissez votre unit d'espace disque";
	option "Megaoctets", exit, action 
		{ sizemult = MEG / sectorsize;
		  multname = msg_string(MSG_megname);
		};
	option "Cylindres", exit, action 
		{ sizemult = dlcylsize; 
		  multname = msg_string(MSG_cylname);
		};
	option "Secteurs", exit, action 
		{ sizemult = 1; 
		  multname = msg_string(MSG_secname);
		};

menu fspartok, title "  Partitions ok?", y=15;
	display action  {
		msg_display(MSG_fspart, multname);
		disp_cur_fspart(-1, 0);
	};
	option "Les Partitions sont ok", exit;
	option "Changer une partition", sub menu editfsparts;

menu edfspart, title "  Changer quoi? ", exit, y=15;
	display action  {
		msg_display (MSG_edfspart, 'a'+editpart);
		disp_cur_fspart(editpart, 1);
	};
	option "type de FS", sub menu  selfskind;
	option "Offset/taille", action  
		{	char buf[40]; int start, size;
			msg_prompt_add (MSG_offset, NULL, buf, 40);
			start = NUMSEC(atoi(buf),sizemult,dlcylsize);
			msg_prompt_add (MSG_size, NULL, buf, 40);
			size = NUMSEC(atoi(buf),sizemult,dlcylsize);
			if (size == -1)
				size = dlsize - start;
			if (editpart == 1 && 
			    bsdlabel[editpart][D_FSTYPE] == T_SWAP)
				size -= swapadj;
			if (start + size > dlsize)
				size = dlsize - start;
			bsdlabel[editpart][D_OFFSET] = start;
			bsdlabel[editpart][D_SIZE] = size;
		};
	option "Taille de block/Taille de fragment", action 
		{	char buf[40]; int i;

			if (bsdlabel[editpart][D_FSTYPE] != T_42BSD) {
				msg_display (MSG_not42bsd, 'a'+editpart);
				process_menu (MENU_ok);
				return FALSE;
			}
			msg_prompt_add (MSG_bsize, NULL, buf, 40);
			i = atoi(buf);
			bsdlabel[editpart][D_BSIZE] = i;
			msg_prompt_add (MSG_fsize, NULL, buf, 40);
			i = atoi(buf);
			bsdlabel[editpart][D_FSIZE] = i;
		};
	option "Point de montage", action 
		{	if (bsdlabel[editpart][D_FSTYPE] == T_42BSD ||
			    bsdlabel[editpart][D_FSTYPE] == T_MSDOS)
				msg_prompt_add (MSG_mountpoint, NULL,
					fsmount[editpart], 20);
			else {
				msg_display (MSG_nomount, 'a'+editpart);
				process_menu (MENU_ok);
			}
		};

menu selfskind, title "  Selection du type de systme de fichier", y=15;
	option "4.2BSD", exit, action 
			{ bsdlabel[editpart][D_FSTYPE] = T_42BSD;
			  bsdlabel[editpart][D_BSIZE]  = 8192;
			  bsdlabel[editpart][D_FSIZE]  = 1024;
			};
	option "unused", exit, action 
			{ bsdlabel[editpart][D_FSTYPE] = T_UNUSED;
			  bsdlabel[editpart][D_BSIZE]  = 0;
			  bsdlabel[editpart][D_FSIZE]  = 0;
			};
	option "swap", exit, action 
			{ bsdlabel[editpart][D_FSTYPE] = T_SWAP;
			  bsdlabel[editpart][D_BSIZE]  = 0;
			  bsdlabel[editpart][D_FSIZE]  = 0;
			};
	option "msdos", exit, action 
			{ bsdlabel[editpart][D_FSTYPE] = T_MSDOS;
			  bsdlabel[editpart][D_BSIZE]  = 0;
			  bsdlabel[editpart][D_FSIZE]  = 0;
			};


menu distmedium, title "  Slection du media d'installation";
	display action { msg_display (MSG_distmedium); nodist = 0; };
	option "ftp",  action   {
				got_dist = get_via_ftp();
				if (got_dist) process_menu (MENU_distset);
				},
				exit;
	option "nfs",  action   {
				got_dist = get_via_nfs();
				if (got_dist) process_menu (MENU_distset);
				}, exit;
	option "cdrom", action  {
				got_dist = get_via_cdrom();
				if (got_dist) process_menu (MENU_distset);
				}, exit;
	option "disquette", action {
				got_dist = get_via_floppy();
				if (got_dist) process_menu (MENU_distset);
				}, exit;
	
	option "systeme de fichier non-mont", action {
				got_dist = get_via_localfs();
				if (got_dist) process_menu (MENU_distset);
				}, exit;
	option "rpertoire local", action {
				got_dist = get_via_localdir();
				if (got_dist)
				process_menu (MENU_distset);
				}, exit;
	option "aucun",  action { nodist = 1; }, exit;

menu distset, title " Slection de la distribution";
	display action { msg_display (MSG_distset); };
	option "Installation complte", exit;
	option "Installation personnalise", next menu md_distcustom;

menu ftpsource, title "  Changer";
	display action
		{ int i;
		  msg_display (MSG_ftpsource, ftp_host, ftp_dir, ftp_user);
		  if (strcmp(ftp_user, "ftp") == 0)
			msg_printf_add ("%s", ftp_pass);
		  else
			for (i = strlen(ftp_pass); i>0; i--)
				msg_printf_add ("*");
		};
	option "Serveur ftp", action
		{ msg_prompt (MSG_host, NULL, ftp_host, 255); };
	option "Rpertoire", action
		{ msg_prompt (MSG_dir, NULL, ftp_dir, 255); };
	option "Utilisateur", action
		{ msg_prompt (MSG_user, NULL, ftp_user, 255); };
	option "Mot de passe", action
		{ if (strcmp(ftp_user, "ftp") == 0)
			msg_prompt (MSG_email, NULL, ftp_pass, 255);
		  else {
			msg_noecho ();
			msg_prompt (MSG_passwd, NULL, ftp_pass, 255);
			msg_echo ();
		  }
		};
	option "Rcuprer la Distribution", exit;

menu nfssource, title "  Changer";
	display action
		{ msg_display (MSG_nfssource, nfs_host, nfs_dir); };
	option "Serveur nfs", action
		{ msg_prompt (MSG_host, NULL, nfs_host, 255); };
	option "Rpertoire", action
		{ msg_prompt (MSG_dir, NULL, nfs_dir, 255); };
	option "Continuer", exit;

menu nfsbadmount, title "  Que voulez vous faire?";
	option "Ressayer", exit, sub menu nfssource, action
		{ yesno = 1; ignorerror = 0; };
	option "Abandonner", exit, action
		{ yesno = 1; ignorerror = 0; };
	option "Ignorer les erreurs, continuer quand mme", exit, action
		{ yesno = 1; ignorerror = 1; };


menu fdremount, title " Que voulez vous faire? ";
	option "Ressayer", exit, action { yesno = 1; };
	option "Annuler l'installation", exit, action { yesno = 0; };

menu fdok, title "  Presser entre pour continuer  ";
	option "OK", exit, action { yesno = 1; };
	option "Abandonner l'installation", exit, action { yesno = 0; };


menu cdromsource, title "  Changer";
	display action
		{ msg_display (MSG_cdromsource, cdrom_dev, cdrom_dir); };
	option "Device", action
		{ msg_prompt (MSG_dev, cdrom_dev, cdrom_dev, SSTRSIZE); };
	option "Rpertoire", action
		{ msg_prompt (MSG_dir, cdrom_dir, cdrom_dir, STRSIZE); };
	option "Continue", exit;

menu cdrombadmount, title "  Que voulez-vous faire?";
	option "Ressayer", exit, sub menu cdromsource, action
		{ yesno = 1; ignorerror = 0; };
	option "Abandonner", exit, action
		{ yesno = 0; ignorerror = 0; };
	option "Ignorer les erreurs, continuer quand mme", exit, action
		{ yesno = 1; ignorerror = 1; };

menu localfssource, title "  Changer";
	display action
		{ msg_display (MSG_localfssource, localfs_dev, localfs_fs, localfs_dir); };
	option "Device", action
		{ msg_prompt (MSG_dev, localfs_dev, localfs_dev, SSTRSIZE); };
	option "Systme de fichier", action
		{ msg_prompt (MSG_filesys, localfs_fs, localfs_fs, STRSIZE); };
	option "Rpertoire", action
		{ msg_prompt (MSG_dir, localfs_dir, localfs_dir, STRSIZE); };
	option "Continuer", exit;

menu localfsbadmount, title "  Que voulez vous faire?";
	option "Ressayer", exit, sub menu localfssource, action
		{ yesno = 1; ignorerror = 0; };
	option "Abandonner", exit, action
		{ yesno = 1; ignorerror = 0; };
	option "Ignorer les erreurs, continuer quand mme", exit, action
		{ yesno = 1; ignorerror = 1; };

menu localdirsource, title "Changer";
	display action
		{ msg_display(MSG_localdir, localfs_dir); };
	option "Rpertoire", action
		{ msg_prompt (MSG_dir, localfs_dir, localfs_dir, STRSIZE); },
		exit;
	option "Continuer", exit;

menu localdirbad, title "  Que voulez vous faire?";
	option "Changer le chemin d'accs",  action
		{ yesno = 1;
			msg_prompt(MSG_localdir, localfs_dir, localfs_dir, STRSIZE);
		}, exit;
	option "Abandonner", exit, action
		{ yesno = 0; ignorerror = 0; };
	option "Ignorer les erreurs, continuer quand mme", exit, action
		{ yesno = 1; ignorerror = 1; };
