/*	$NetBSD: crt0.S,v 1.7 1996/10/18 05:36:54 thorpej Exp $	*/

/*
 * Copyright (c) 1991, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Ralph Campbell.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	from: @(#)crt0.s	8.2 (Berkeley) 3/21/94
 */

#include <machine/regdef.h>
#include <machine/machAsmDefs.h>

	.comm	_C_LABEL(environ), 4
	.comm	_C_LABEL(__progname), 4
	.data
$L1:
	.word	0		# null string plus padding
	.text

NON_LEAF(__start, 24, ra)
	.set	noreorder
#ifdef __GP_SUPPORT__
	la	gp, _C_LABEL (_gp)
#endif
	lw	s0, 0(sp)		# get argc from stack
	addu	s1, sp, 4		# get pointer to argv
	addu	s2, s1, 4		# skip null pointer on stack
	sll	v0, s0, 2		# add number of argv pointers
	addu	s2, s2, v0		# final pointer to environment list
	sw	s2, _C_LABEL(environ)	# save environment pointer
	subu	sp, sp, 24		# allocate standard frame
	.mask	0x80000000, -4
	sw	zero, 20(sp)		# clear return address for debugging
#ifdef MCRT0
eprol:
	la	a0, eprol
	la	a1, etext
	jal	_C_LABEL(monstartup)	# monstartup(eprol, etext);
	nop
	la	a0, _C_LABEL(mcleanup)
	jal	_C_LABEL(atexit)	# atexit(mcleanup);
	nop
	sw	zero, _C_LABEL(errno)
#endif
	lw	a0, 0(s1)		# a0 = argv[0];
	nop
	bne	a0, zero, 2f		# If a0 is NULL, use null string.
	nop
	la	a0, $L1
	nop
2:
	move	s3, a0			# save argv[0]
	jal	_C_LABEL(strrchr)
	li	a1, 0x2f		# a1 = '/'
	bne	v0, zero, 1f		# if slash found
	addu	v0, v0, 1
	move	v0, s3			# v0 = argv[0];
1:
	sw	v0, _C_LABEL(__progname)
	move	a0, s0
	move	a1, s1
	jal	_C_LABEL(main)		# v0 = main(argc, argv, env);
	move	a2, s2
	jal	_C_LABEL(exit)		# exit(v0);
	move	a0, v0
	break	0
	.set	reorder
END(__start)

#ifndef MCRT0
LEAF(moncontrol)
	j	ra
END(moncontrol)

LEAF(_mcount)
	.set	noreorder
	.set	noat
	addu	sp, sp, 8		# undo push
	j	ra
	move	ra, AT
	.set	at
	.set	reorder
END(_mcount)
#endif
