/*	$NetBSD: option.h,v 1.1.1.3 1997/09/21 12:23:17 mrg Exp $	*/

/*
 * Copyright (c) 1984,1985,1989,1994,1995,1996  Mark Nudelman
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice in the documentation and/or other materials provided with 
 *    the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT 
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR 
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN 
 * IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */


#define	END_OPTION_STRING	('$')

/*
 * Types of options.
 */
#define	BOOL		01	/* Boolean option: 0 or 1 */
#define	TRIPLE		02	/* Triple-valued option: 0, 1 or 2 */
#define	NUMBER		04	/* Numeric option */
#define	STRING		010	/* String-valued option */
#define	NOVAR		020	/* No associated variable */
#define	REPAINT		040	/* Repaint screen after toggling option */
#define	NO_TOGGLE	0100	/* Option cannot be toggled with "-" cmd */
#define	HL_REPAINT	0200	/* Repaint hilites after toggling option */
#define	NO_QUERY	0400	/* Option cannot be queried with "_" cmd */

#define	OTYPE		(BOOL|TRIPLE|NUMBER|STRING|NOVAR)

/*
 * Argument to a handling function tells what type of activity:
 */
#define	INIT	0	/* Initialization (from command line) */
#define	QUERY	1	/* Query (from _ or - command) */
#define	TOGGLE	2	/* Change value (from - command) */

/* Flag to toggle_option to specify how to "toggle" */
#define	OPT_NO_TOGGLE	0
#define	OPT_TOGGLE	1
#define	OPT_UNSET	2
#define	OPT_SET		3

struct option
{
	char oletter;		/* The controlling letter (a-z) */
	int otype;		/* Type of the option */
	int odefault;		/* Default value */
	int *ovar;		/* Pointer to the associated variable */
	void (*ofunc)();	/* Pointer to special handling function */
	char *odesc[3];		/* Description of each value */
};

