#	$NetBSD: Makefile.inc,v 1.1.1.1 1997/03/14 02:40:32 perry Exp $
#
#	Configuration variables (default values are below):
#
#	S	must be set to the top of the 'sys' tree.
#	I386DST	may be set to the location of the directory where library
#		objects are to be built.  Defaults to ${.OBJDIR}/lib/i386.
#	I386MISCCPPFLAGS
#		Miscellaneous cpp flags to be passed to the library's Makefile
#		when building.
#	I386MISCMAKEFLAGS
#		Miscellaneous flags to be passed to the library's Makefile when
#		building.  See library's Makefile for more details about
#		supported flags and their default values.

# Default values:
I386DST?=		${.OBJDIR}/lib/i386

#I386DIR=		$S/arch/i386/stand/lib
I386LIB=		${I386DST}/libi386.a

I386MAKE= \
	cd ${I386DIR} && MAKEOBJDIR=${I386DST} ${MAKE} \
	    CC=${CC:Q} CFLAGS=${CFLAGS:Q} \
	    AS=${AS:Q} AFLAGS=${AFLAGS:Q} \
	    LD=${LD:Q} STRIP=${STRIP:Q} \
	    MACHINE=${MACHINE} MACHINE_ARCH=${MACHINE_ARCH:Q} \
	    I386CPPFLAGS=${CPPFLAGS:S@^-I.@-I../../.@g:Q} \
	    I386MISCCPPFLAGS=${I386MISCCPPFLAGS:Q} \
	    ${I386MISCMAKEFLAGS}

${I386LIB}:		.NOTMAIN __always_make_i386lib
	@echo making sure the i386 library is up to date...
	@${I386MAKE} libi386.a

clean:			.NOTMAIN cleani386lib
cleani386lib:		.NOTMAIN __always_make_i386lib
	@echo cleaning the i386 library objects
	@${I386MAKE} clean

cleandir:		.NOTMAIN cleandiri386lib
cleandiri386lib:		.NOTMAIN __always_make_i386lib
	@echo cleandiring the i386 library objects
	@${I386MAKE} cleandir

depend:			.NOTMAIN dependi386lib
dependi386lib:		.NOTMAIN __always_make_i386lib
	@echo depending the i386 library objects
	@${I386MAKE} depend

__always_make_i386lib:	.NOTMAIN
	@mkdir -p ${I386DST}
