/*	$NetBSD: tx39ioreg.h,v 1.2 2000/01/16 21:47:00 uch Exp $ */

/*
 * Copyright (c) 1999, by UCHIYAMA Yasushi
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. The name of the developer may NOT be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */
/*
 * TOSHIBA TX3912/TX3922 IO module
 */

#define	TX39_IOCTRL_REG			0x180
#define	TX39_IOMFIODATAOUT_REG		0x184
#define	TX39_IOMFIODATADIR_REG		0x188
#define	TX39_IOMFIODATAIN_REG		0x18c
#define	TX39_IOMFIODATASEL_REG		0x190
#define	TX39_IOIOPOWERDWN_REG		0x194
#define	TX39_IOMFIOPOWERDWN_REG		0x198
#ifdef TX392X
#define TX39_IODATAINOUT_REG		0x19c
#endif /* TX392X */

#define TX39_IO_MFIO_MAX		32
#ifdef TX391X
#define TX39_IO_IO_MAX			7
#endif /* TX391X */
#ifdef TX392X
#define TX39_IO_IO_MAX			16
#endif /* TX392X */

/*
 *	IO Control Register
 */
#ifdef TX391X
#define TX39_IOCTRL_IODEBSEL_SHIFT	24
#define TX39_IOCTRL_IODEBSEL_MASK	0x7f
#define TX39_IOCTRL_IODEBSEL(cr) \
	(((cr) >> TX39_IOCTRL_IODEBSEL_SHIFT) & \
	TX39_IOCTRL_IODEBSEL_MASK)
#define TX39_IOCTRL_IODEBSEL_SET(cr, val) \
	((cr) | (((val) << TX39_IOCTRL_IODEBSEL_SHIFT) & \
	(TX39_IOCTRL_IODEBSEL_MASK << TX39_IOCTRL_IODEBSEL_SHIFT)))

#define TX39_IOCTRL_IODIREC_SHIFT	16
#define TX39_IOCTRL_IODIREC_MASK	0x7f
#define TX39_IOCTRL_IODIREC(cr) \
	(((cr) >> TX39_IOCTRL_IODIREC_SHIFT) & \
	TX39_IOCTRL_IODIREC_MASK)
#define TX39_IOCTRL_IODIREC_SET(cr, val) \
	((cr) | (((val) << TX39_IOCTRL_IODIREC_SHIFT) & \
	(TX39_IOCTRL_IODIREC_MASK << TX39_IOCTRL_IODIREC_SHIFT)))

#define TX39_IOCTRL_IODOUT_SHIFT	8
#define TX39_IOCTRL_IODOUT_MASK		0x7f
#define TX39_IOCTRL_IODOUT(cr) \
	(((cr) >> TX39_IOCTRL_IODOUT_SHIFT) & \
	TX39_IOCTRL_IODOUT_MASK)
#define TX39_IOCTRL_IODOUT_CLR(cr) \
	((cr) &= ~(TX39_IOCTRL_IODOUT_MASK << TX39_IOCTRL_IODOUT_SHIFT))
#define TX39_IOCTRL_IODOUT_SET(cr, val) \
	((cr) | (((val) << TX39_IOCTRL_IODOUT_SHIFT) & \
	(TX39_IOCTRL_IODOUT_MASK << TX39_IOCTRL_IODOUT_SHIFT)))

#define TX39_IOCTRL_IODIN_SHIFT	0
#define TX39_IOCTRL_IODIN_MASK	0x7f
#define TX39_IOCTRL_IODIN(cr) \
	(((cr) >> TX39_IOCTRL_IODIN_SHIFT) & \
	TX39_IOCTRL_IODIN_MASK)
#endif /* TX391X */

#ifdef TX392X
#define TX39_IOCTRL_IODEBSEL_SHIFT	16
#define TX39_IOCTRL_IODEBSEL_MASK	0xffff
#define TX39_IOCTRL_IODEBSEL(cr) \
	(((cr) >> TX39_IOCTRL_IODEBSEL_SHIFT) & \
	TX39_IOCTRL_IODEBSEL_MASK)
#define TX39_IOCTRL_IODEBSEL_SET(cr, val) \
	((cr) | (((val) << TX39_IOCTRL_IODEBSEL_SHIFT) & \
	(TX39_IOCTRL_IODEBSEL_MASK << TX39_IOCTRL_IODEBSEL_SHIFT)))

#define TX39_IOCTRL_IODIREC_SHIFT	0
#define TX39_IOCTRL_IODIREC_MASK	0xffff
#define TX39_IOCTRL_IODIREC(cr) \
	(((cr) >> TX39_IOCTRL_IODIREC_SHIFT) & \
	TX39_IOCTRL_IODIREC_MASK)
#define TX39_IOCTRL_IODIREC_SET(cr, val) \
	((cr) | (((val) << TX39_IOCTRL_IODIREC_SHIFT) & \
	(TX39_IOCTRL_IODIREC_MASK << TX39_IOCTRL_IODIREC_SHIFT)))

#define TX39_IODATAINOUT_DOUT_SHIFT	16
#define TX39_IODATAINOUT_DOUT_MASK	0xffff
#define TX39_IODATAINOUT_DOUT(cr) \
	(((cr) >> TX39_IODATAINOUT_DOUT_SHIFT) & \
	TX39_IODATAINOUT_DOUT_MASK)
#define TX39_IODATAINOUT_DOUT_SET(cr, val) \
	((cr) | (((val) << TX39_IODATAINOUT_DOUT_SHIFT) & \
	(TX39_IODATAINOUT_DOUT_MASK << TX39_IODATAINOUT_DOUT_SHIFT)))

#define TX39_IODATAINOUT_DIN_SHIFT	0
#define TX39_IODATAINOUT_DIN_MASK	0xffff
#define TX39_IODATAINOUT_DIN(cr) \
	(((cr) >> TX39_IODATAINOUT_DIN_SHIFT) & \
	TX39_IODATAINOUT_DIN_MASK)
#define TX39_IODATAINOUT_DIN_SET(cr, val) \
	((cr) | (((val) << TX39_IODATAINOUT_DIN_SHIFT) & \
	(TX39_IODATAINOUT_DIN_MASK << TX39_IODATAINOUT_DIN_SHIFT)))
#endif /* TX392X */
/*
 *	MFIO Data Output Register
 */
#define TX39_IOMFIODATAOUT_MFIODOUT	0

/*
 *	MFIO Data Direction Register
 */
#define TX39_IOMFIODATADIR_MFIODIREC	0

/*
 *	MFIO Data Input Register
 */
#define TX39_IOMFIODATAIN_MFIODIN	0

/*
 *	MFIO Data Select Register
 */
#define TX39_IOMFIODATASEL_MFIOSEL		0
#define TX39_IOMFIODATASEL_MFIOSEL_RESET	0xf20f0fff

/*
 *	IO Power Down Register
 */
#define TX39_IOIOPOWERDWN_IOPD_SHIFT	0
#ifdef TX391X
#define TX39_IOIOPOWERDWN_IOPD_MASK	0x7f
#define TX39_IOIOPOWERDWN_IOPD_RESET	0x7f
#endif /* TX391X */
#ifdef TX392X
#define TX39_IOIOPOWERDWN_IOPD_MASK	0xffff
#define TX39_IOIOPOWERDWN_IOPD_RESET	0x0fff
#endif /* TX392X */
#define TX39_IOIOPOWERDWN_IOPD(cr) \
	(((cr) >> TX39_IOIOPOWERDWN_IOPD_SHIFT) & \
	TX39_IOIOPOWERDWN_IOPD_MASK)
#define TX39_IOIOPOWERDWN_IOPD_SET(cr, val) \
	((cr) | (((val) << TX39_IOIOPOWERDWN_IOPD_SHIFT) & \
	(TX39_IOIOPOWERDWN_IOPD_MASK << TX39_IOIOPOWERDOWN_IOPD_SHIFT)))


/*
 *	MFIO Power Down Register
 */
#define	TX39_IOMFIOPOWERDWN_MFIOPD		0
#define	TX39_IOMFIOPOWERDWN_MFIOPD_RESET	0xfaf03ffc

