#include <stdio.h>
#include <graph.h>

struct Buttons
{
	long Bc;		/* Background Color	*/
	int  Tc;    /* Text Color		*/
	int  r;     /* row				*/
	int  c;	   /* column			*/
	char oo;    /* On/Off flag		*/
	char *l;    /* Button label		*/
};

struct Wins
{
	int rul;					/* Row Upper Left Coordinate	*/
	int cul;					/* Column Upper Left Coordinate	*/
	int rlr;					/* Row Lower Right Coordinate	*/
	int clr;					/* Column Lower Right Coordinate	*/
	long bc;					/* Background Color	*/
	int nb;					/* Number of Buttons	*/
	struct Buttons *wp;	/* Pointer to Buttons for Window	*/
};

struct Buttons tt[] = {0, 0, 0, 0, 0, ""};

struct Buttons rb[] =
{
	1, 7,  0, 0, 1, " A  ",
	1, 7,  2, 0, 0, " NR ",
	1, 7,  4, 0, 0, " IR ",
   1, 7,  6, 0, 0, " MQ ",
   1, 7,  8, 0, 0, " NIA",
   1, 7, 10, 0, 0, " S  ",
   5, 1, 12, 0, 0, " PR ",
};

struct Buttons kb[] =
{ 7, 15,  0, 0, 0, "00000000000000",
  6,  0,  2, 1, 0, "77",
  6,  0,  3, 1, 0, "66",
  6,  0,  4, 1, 0, "55",
  6,  0,  5, 1, 0, "44",
  6,  0,  6, 1, 0, "33",
  6,  0,  7, 1, 0, "22",
  6,  0,  8, 0, 0, "111",
  6,  0,  9, 0, 0, "000",
  6,  0, 10, 0, 0, "---",
  6,  0,  2, 7, 0, "777",
  6,  0,  3, 7, 0, "666",
  6,  0,  4, 7, 0, "555",
  6,  0,  5, 7, 0, "444",
  6,  0,  6, 7, 0, "333",
  6,  0,  7, 7, 0, "222",
  6,  0,  8, 7, 0, "111",
  6,  0,  9, 7, 0, "000",
  6,  0, 10, 7, 0, "---",
  7,  0,  2, 3, 0, "7777",
  7,  0,  3, 3, 0, "6666",
  7,  0,  4, 3, 0, "5555",
  7,  0,  5, 3, 0, "4444",
  7,  0,  6, 3, 0, "3333",
  7,  0,  7, 3, 0, "2222",
  7,  0,  8, 3, 0, "1111",
  7,  0,  9, 3, 0, "0000",
  7,  0, 10, 3, 0, "----",
  7,  0,  2, 10, 0, "7777",
  7,  0,  3, 10, 0, "6666",
  7,  0,  4, 10, 0, "5555",
  7,  0,  5, 10, 0, "4444",
  7,  0,  6, 10, 0, "3333",
  7,  0,  7, 10, 0, "2222",
  7,  0,  8, 10, 0, "1111",
  7,  0,  9, 10, 0, "0000",
  7,  0, 10, 10, 0, "----",
};

struct Buttons ek[] =
{ 6, 0, 0, 0, 0, " E ",
  6, 0, 1, 0, 0, " N ",
  6, 0, 2, 0, 0, " T ",
  6, 0, 4, 0, 0, "E C",
  6, 0, 5, 0, 0, "N&L",
  6, 0, 6, 0, 0, "T R",
  6, 0, 8, 0, 0, " C ",
  6, 0, 9, 0, 0, " L ",
  6, 0, 10, 0, 0, " R ",
};

struct Buttons sw[] =
{ 2, 1, 0, 0, 0, "",
  2, 1, 0, 4, 0, "",
  2, 1, 0, 8, 0, "",
  2, 1, 0, 12, 0, "",
  2, 14, 0, 16, 0, "",
  3, 1, -1, 7, 0, "IAD BEL",
};
struct Buttons ck[] =
{ 1, 7, 0, 0, 0, "CLR",
  1, 7, 1, 0, 0, "CND",
  1, 7, 2, 0, 0, "KYS",
  1, 7, 0, 4, 0, "Ov IGN",
  1, 7, 2, 4, 0, "D1",
  1, 7, 2, 7, 0, "D2",
  1, 7, 2, 10, 0, "D3",
  1, 7, 0, 13, 0, "T1",
  1, 7, 0, 16, 0, "T2",
  1, 7, 0, 19, 0, "T2",
  1, 7, 2, 13, 0, "H1",
  1, 7, 2, 16, 0, "H2",
  1, 7, 2, 19, 0, "H3",
};
struct Buttons ie[] =
{ 5, 8, 0, 5, 0, "FETCH",
  5, 8, 2, 0, 0, "L INSTR",
  5, 8, 2, 8, 0, "R INSTR",
  5, 8, 4, 3, 0, "ONE INSTR",
};

struct Buttons sg[] =
{ 4, 15, 6, 0, 1, "     STOP     ",
  2, 8, 0, 5, 0, "LOAD",
  2, 8, 2, 5, 0, " GO ",
  2, 8, 4, 3, 0, "GO TO S",
};

struct Buttons hs[] =
{ 3, 6, 0,  0, 0, "00",
  3, 6, 1,  0, 0, "01",
  3, 6, 2, 0, 0, "02",
  3, 6, 3, 0, 0, "03",
  3, 6, 4, 0, 0, "04",
  3, 6, 5, 0, 0, "05",
  3, 6, 6, 0, 0, "06",
  3, 6, 7, 0, 0, "07",
  3, 6, 8, 0, 0, "10.4",
  3, 6, 9, 0, 0, "10,5",
  3, 6, 10, 0, 0, "11",
  3, 6, 11, 0, 0, "12",
  3, 6, 12, 0, 0, "13",
  3, 6, 13, 0, 0, "14",
  3, 6, 14, -2, 0, "->MGA",
  3, 7, -1, -1, 0, "Hoot"
};


struct Wins wo[] =
{
	 1, 19,  8, 62, 3,  1, &tt[0],	/* Title				*/
	16, 18, 29, 21, 3,  7, &rb[0],	/* Registers		*/
	16, 23, 27, 36, 3, 37, &kb[0],	/* Keyboard			*/
	16, 38, 27, 40, 3,  9, &ek[0],	/* Enter Keys		*/
	11, 30, 11, 47, 3,  6, &sw[0],	/* Switches			*/
	13, 42, 15, 61, 3, 13, &ck[0],	/* Condition Keys	*/
	17, 45, 21, 58, 3,  4, &ie[0],	/* Instruction Ex	*/
	23, 45, 29, 58, 3,  4, &sg[0],	/* Stop/Go			*/
	16, 10, 32, 65, 3, 16, &hs[0],	/* Hoot Selection	*/
};

char colb[] = { 0x02, 0x01, 0x01, 0x81, 0xFE, 0x80,
					 0x0E, 0x11, 0x11, 0x11, 0x0E, 0x00,
					 0xFF, 0x08, 0x10, 0x10, 0x0F, 0x00,
					 0x1F, 0x08, 0x10, 0x10, 0x0F, 0x00,
					 0x1F, 0x08, 0x10, 0x10, 0x0F, 0x00,
					 0x9F, 0x00,
					 0x0E, 0x11, 0x11, 0x0A, 0x1F, 0x00,
					 0x0E, 0x11, 0x11, 0x11, 0x0A};

struct Buttons *bp;
void GenButtons(struct Buttons *bptr, int rorg, int corg, int n);
void Vprint(int r, int c, char b);
void JACLogo(void);

char buffer[80];

main(void)
{
	long bkcolor;
	long Green = 0x002800L;
	long BkGreen = 0x021902L;
	long Yellow = 0x003838L;
	long Brown = 0x0A1829L;
	short txtcolor, i, j;
   bkcolor = _getbkcolor();
	txtcolor = _gettextcolor();
	_settextrows(50);
	_remappalette(2, Green);
	_remappalette(3, BkGreen);
	_remappalette(5, Yellow);
	_remappalette(6, Brown);
	_setbkcolor(3L);
   _clearscreen(_GCLEARSCREEN);
	_settextcolor(15);
	JACLogo();
	_settextcursor(0x0007);
	 for(j = 1; j < 9; j++)
	 {
    	bp = wo[j].wp;
    	for(i = 0; i < wo[j].nb; i++)GenButtons(bp, wo[j].rul, wo[j].cul, i);
	 }
	getch();
	_setbkcolor(bkcolor);
	_settextcolor(txtcolor);
	_clearscreen(_GCLEARSCREEN);
	_settextrows(25);
	_settextcursor(0x0707);
}

void GenButtons(struct Buttons *bptr, int rorg, int corg, int n)
{
	_setbkcolor(bptr[n].Bc);
	if(bptr[n].oo == 0) _settextcolor(bptr[n].Tc);
	else _settextcolor(15);
	_settextposition(bptr[n].r + rorg, bptr[n].c + corg);
	sprintf(buffer, "%s", bptr[n].l);
	_outtext(buffer);
}

void JACLogo(void)
{
	int row = 2, col, i;

	for(col = 18, i = 0; col < 60; col++, i++)
	{
		Vprint(row, col, colb[i]);
	}
}

void Vprint(int r, int c, char b)
{
	int m;
	char buffer[20], bit[] = {0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x01};

	if(b == 0) return;
	for(m = 0; m < 8; m++)
	{
		_settextposition(r, c);
		if((b & bit[m]) != 0)
		{
			sprintf(buffer, "%c", 0xDB);
			_outtext(buffer);
		}
		++r;
	}
}

