#include <stdio.h>
#include <graph.h>

#define Ac 0
#define Mq 1
#define Nr 3
#define Ir 4
#define Cck 0
#define Oig 1
#define d1 2
#define d2 3
#define d3 4
#define t1 5
#define t2 6
#define t3 7
#define h1 8
#define h2 9
#define h3 10
#define St 11
#define Fe 12
#define Li 13
#define Ri 14
#define Oi 15
#define Ld 16
#define Go 17
#define Gs 18

int NIA = 0, ST = 0;


struct Buttons
{
	long Bc;	/* Background Color	*/
	int  Tc;	/* Text Color			*/
	int  r;	/* row					*/
	int  c;	/* column				*/
	char oo;	/* On/Off flag			*/
	char *l;	/* Button label		*/
};

struct Buttons *bp;
void GenButtons(struct Buttons *bptr, int n);
void GenRegs(int);
void GenLabels(int n);
void Vprint(int r, int c, char b);
void JACLogo(void);

struct OctRegs
{
	long Bc;	/* Background Color	*/
	int Tc;	/* Text Color			*/
	int r;	/* text Row				*/
	int c;	/* Text Column			*/
	int lop;	/* Left Op				*/
	int lad;	/* Left Address		*/
	int rop;	/* Right Op				*/
	int rad;	/* Right Address		*/
};

struct Labels
{
  int Tc;	/* Text Color	*/
  int r;		/* Text Row		*/
  int c;		/* Text Row		*/
  char *l;	/* Text Label	*/
};

struct OctRegs reg[] =
{ 7, 15, 17, 10, 0, 0, 0, 0,	/* Accumulator				*/
  7, 15, 19, 10, 0, 0, 0, 0,	/* Instruction Register	*/
  7, 15, 21, 10, 0, 0, 0, 0,	/* Number Register		*/
  7, 15, 23, 10, 0, 0, 0, 0	/* MQ							*/
};

struct Buttons btn[] =
{ 1, 3, 17, 35, 0, " CLR COND KEYS ",
  1, 3, 19, 37, 0, " O'FLO IGN ",
  1, 3, 21, 35, 0, " D1 ",
  1, 3, 21, 40, 0, " D2 ",
  1, 3, 21, 45, 0, " D3 ",
  1, 3, 23, 35, 0, " T1 ",
  1, 3, 23, 40, 0, " T2 ",
  1, 3, 23, 45, 0, " T2 ",
  1, 3, 25, 35, 0, " H1 ",
  1, 3, 25, 40, 0, " H2 ",
  1, 3, 25, 45, 0, " H3 ",
  4, 15, 27, 34, 1, "      STOP      ",
  5, 7, 17, 60, 0, "  FETCH  ",
  5, 7, 19, 55, 0, " L INSTR ",
  5, 7, 19, 65, 0, " R INSTR ",
  5, 7, 21, 59, 0, " ONE INSTR ",
  3, 7, 23, 60, 0, "  LOAD  ",
  3, 7, 25, 60, 0, "   GO   ",
  3, 7, 27, 60, 0, " GO TO S ",
};

struct Buttons Hut[] =
{ 6, 7, 30, 10, 0, " 0 ",
  6, 7, 30, 14, 0, " 1 ",
  6, 7, 30, 18, 0, " 2 ",
  6, 7, 30, 22, 0, " 3 ",
  6, 7, 30, 26, 0, " 4 ",
  6, 7, 30, 30, 0, " 5 ",
  6, 7, 30, 34, 0, " 6 ",
  6, 7, 30, 38, 0, " 7 ",
  6, 7, 30, 42, 0, "104",
  6, 7, 30, 46, 0, "105",
  6, 7, 30, 50, 0, " 11",
  6, 7, 30, 54, 0, " 12",
  6, 7, 30, 58, 0, " 13",
  6, 7, 30, 62, 0, " 14",
  6, 7, 30, 66, 1, "MGA",
};
  
struct Labels labs[] =
{
  0, 14, 41, "BELL",
  0, 14, 49, "IAD",
  0, 17, 5, "A",
  0, 19, 5, "IR",
  0, 21, 5, "NR",
  0, 23, 5, "MQ",
  0, 25, 5, "NIA",
  0, 27, 5, "S",
  0, 31, 35, "Hoot Selector",
};

char colb[] = { 0x02, 0x01, 0x01, 0x81, 0xFE, 0x80,
					 0x0E, 0x11, 0x11, 0x11, 0x0E, 0x00,
					 0xFF, 0x08, 0x10, 0x10, 0x0F, 0x00,
					 0x1F, 0x08, 0x10, 0x10, 0x0F, 0x00,
					 0x1F, 0x08, 0x10, 0x10, 0x0F, 0x00,
					 0x9F, 0x00,
					 0x0E, 0x11, 0x11, 0x0A, 0x1F, 0x00,
					 0x0E, 0x11, 0x11, 0x11, 0x0A};

char buffer[81];

main(void)
{
	long bkcolor;
	short txtcolor, i;

	bkcolor = _getbkcolor();
	txtcolor = _gettextcolor();
	_settextrows(50);
	_setbkcolor(2L);
   _clearscreen(_GCLEARSCREEN);
	_settextcolor(1);
	JACLogo();
	_settextcursor(0x0007);
	for(i = 0; i < 9; i++) GenLabels(i);
   bp = &btn[0];
   for(i = 0; i < 19; i++)GenButtons(bp, i);
	for(i = 0; i < 4; i++) GenRegs(i);
	_settextposition(25, 10);
	sprintf(buffer, "    %04o         ", NIA);
	_outtext(buffer);
	_settextposition(27, 10);
	sprintf(buffer, "    %04o         ", ST);
	_outtext(buffer);
	bp = &Hut[0];
 	for(i = 0; i < 15; i++) GenButtons(bp, i);
	getch();
	_setbkcolor(bkcolor);
	_settextcolor(txtcolor);
	_clearscreen(_GCLEARSCREEN);
	_settextrows(25);
	_settextcursor(0x0707);
}

void GenButtons(struct Buttons *bptr, int n)
{
	_setbkcolor(bptr[n].Bc);
	if(bptr[n].oo == 0) _settextcolor(bptr[n].Tc);
	else _settextcolor(15);
	_settextposition(bptr[n] .r, bptr[n].c);
	sprintf(buffer, "%s", bptr[n].l);
	_outtext(buffer);
}

void GenRegs(int n)
{
	_setbkcolor(reg[n].Bc);
	_settextcolor(reg[n].Tc);
	_settextposition(reg[n].r, reg[n].c);
	sprintf(buffer, "%03o %04o %03o %04o", reg[n].lop, reg[n].lad, reg[n].rop, reg[n].rad);
	_outtext(buffer);
}

void GenLabels(int n)
{
	_settextcolor(labs[n].Tc);
	_settextposition(labs[n].r, labs[n].c);
	sprintf(buffer, "%s", labs[n].l);
	_outtext(buffer);
}

void JACLogo(void)
{
	int row = 2, col, i;

	for(col = 18, i = 0; col < 60; col++, i++)
	{
		Vprint(row, col, colb[i]);
	}
}

void Vprint(int r, int c, char b)
{
	int m;
	char buffer[20], bit[] = {0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x01};

	if(b == 0) return;
	for(m = 0; m < 8; m++)
	{
		_settextposition(r, c);
		if((b & bit[m]) != 0)
		{
			sprintf(buffer, "%c", 0xDB);
			_outtext(buffer);
		}
		++r;
	}
}

