/*	qpdiag.h	2.3	82/12/16	*/

/* (C) Copyright 1982 by Sun Microsystems, Inc. */

/* ======================================================================
   Editor : Peter Costello
   Date   : May 14, 1982
   Purpose : 
	This file contains the includes for the program pdiag.c. This
	file takes stuff from the Monitor Kernel includes, but only
	takes the stuff it needs rather than the whole rats next.

   Algorithm :
   Error Handling : 
   ====================================================================== */

typedef unsigned char uchar;
typedef unsigned short ushort;


#define EVEC1_BUSERR ((long*)0x0008)

/* label a point for assembler jumps */
#define label(a)	labelU(_/**/a)
#define labelU(a)	asm("a:") 


/* The following Resets the timers and makes sure that we don't generate a
   bus error or Reset pulse when we exit boot state. Code stolen from
   John Gilmore's Monitor source. */

#define Reset_Timers   \
	/* FIRST! reset Timers, to avoid being interrupted */		    \
	ResTIMER; 							    \
									    \
	/* Now point to the master mode register to do some things */	    \
	TMRLoadCmd((unsigned short)(0xFF00 | TSMasterMode)); 		    \
	LoadReg(TMMBus16 + TMMFoutOff + TMMFoutDiv2);  /* Div FOUT by 2 */  \
	TCClrOut(TIMRefresh);  		    /* clear possible interrupt */  \
	TCClrOut(TIMWatchDog)   	    /* Ditto */		    	    \
	/* The other timers either interrupt at levels lower than 7 (or	    \
	   RESET) or are not connected to the CPU at all (Uart clocks) */


/* Timer definitions -- also see ../diag/timer.h */
/*  Sun processor Channel Assignment is: 
 *  #define TIMRefresh	3	-* for refresh task *-
 *  #define TIMAClk	4	-* Ch.A clock *-
 *  #define TIMBClk	5	-* Ch.B clock *-
 *  #define TIMInter	2	-* Interrupt Clock, Level 6 *-
 *  #define TIMWatchDog	1	-* Watchdog Timer Clock *-
 */ 

#define CPUMHZ 10
#define TICKSPERSEC ((CPUMHZ*1000000)/(4*16))   /* 16 samples per bit */
#define TFRQ_uart (TICKSPERSEC/9600)
#define Uart_A_Init \
	TCSetModeLoad(TIMAClk,TMODuart,TFRQ_uart); \
	TCArmCnt(TSCountA);   \
	ContReg(A) = (char)NECchres;   /* Make sure we're at register 0 */ \
	ContReg(A) = (char)NECchres;   /* Reset channel */  \
	ContReg(A) = (char)2;	       /* Point to data Register 2 */  \
	ContReg(A) = (char)NECINR2;    /* Set Register 2 */  \
	ContReg(A) = (char)4;	       /* Point to data Register 4 */  \
	ContReg(A) = (char)NECINR4;    /* Set Register 4 */  \
	ContReg(A) = (char)3;	       /* Point to data Register 3 */  \
	ContReg(A) = (char)NECINR3;    /* Set Register 3 */  \
	ContReg(A) = (char)5;	       /* Point to data Register 5 */  \
	ContReg(A) = (char)NECINR5;    /* Set Register 5 */  \
	ContReg(A) = (char)1;	       /* Point to data Register 1 */  \
	ContReg(A) = (char)NECINR1     /* Set Register 1 */ 


/* Includes from pcmap.h */
#define Set_Context(i) \
	*((unsigned short*)0xE00000) = (i<<12)

#define Read_Context(i) \
	i = (*((unsigned short*)0xC00000) >> 12) & 0x0F;


/* The following defines are used to test out the segment maps */

#define Smap_Low  (short*)0xC00000   	/* Bottom Segmap */
#define Smap_Hi   (short*)0xDFFFFF	/* Top Segmap */
#define Smap_Incr         0x004000	/* Increment addr by 16K short words
					   to access next higher segment */
#define Smap_Entries          1024	/* 1024 Smap Entries */
#define Clr_Top4	    0x0FFF
	

/* Define constants used by the page map tests */

#define Pmap_Low (short*)0xA00000   	/* Bottom Pagemap */
#define Pmap_Mid (short*)0xB00000	/* Start of Multibus Memory */
#define Pmap_Hi  (short*)0xBFFFFF	/* Top Pagemap */
#define Pmap_Incr    	 0x000400	/* Increment address by 1000 short
					   words to access next page */
#define Pmap_Entries	     1024	/* 1024 Pmap Entries */


/* The following definitions are used to do memory refresh after a wait or
   after we print an error message (Print chars takes 0.1msec/char). */

/* Define number of addresses we must cycle through in order to do 128 
   RAS cycles to refresh main memory. */

#define RamRef_Addr (short*)256  

#define Do_Refresh  \
	taddr = ((short*)0); \
	do { *taddr++ = *taddr; } while (taddr <= RamRef_Addr);

/* The following routine takes 22 clock periods to complete as compiled by
   the Unisoft "optimizing" compiler. The code produced is:
	foo: subql	#1,d4	    -- 8 clocks, or 800ns w/ 10Mhz CPU --
	     tstl	d4	    -- 4 clocks, or 400ns w/ 10Mhz CPU --
	     jgt	foo         --10 clocks, or 1usec w/ 10Mhz CPU --
 */
   
#define Sleep_6msec(foo) \
	foo = 2200; /* With Unisoft compiler Summer '82 */ \
	do { foo-=1; } while (foo > 0);  \
	Do_Refresh


#define Init_Smap(i,addr) 		/* Init seg map */    	\
	Set_Context(0);			/* Just use context 0 */\
	i = 0;							\
	for (addr = Smap_Low;addr <= Smap_Hi;addr += Smap_Incr) {  \
	   *addr = ((i++) | SEGPRO_ALL);     			\
	}

/* Initialize Page Map. Assume all of memory is on-board RAM. */
#define Init_Pmap(i,addr)   		/* Init Page Map */  	\
	addr = Pmap_Low;					\
	for (i=0;i<PAGEMAPSIZE; ){   /* Set up memory Pages */  \
	   *addr = i++;			/* Access code = 0 */   \
	   addr += Pmap_Incr;					\
	}							\


/* Initialize Page Map. Assume Multibus RAM starts at 0x100000. */
#define Init_MBPmap(i,addr)   		/* Init Page Map */  	\
	addr = Pmap_Mid;					\
	for (i=512;i<PAGEMAPSIZE;){  /* Set up memory Pages */  \
	   *addr = ((i++) | PGSPC_MBMEM);  			\
	   addr += Pmap_Incr;  					\
	}


#define ALLOCHUNK 64			/* Min Mem quantum = 128K */
#define SZ_MEM(i,addr_hi) 		/* Size on-board mem */ \
	for (i=PAGEMAPSIZE;i>=0;i-=ALLOCHUNK) {	 		\
	   (*(short*) ((long) i << 11)) = i;			\
	}							\
	for (i=0;i<PAGEMAPSIZE;i+=ALLOCHUNK) {			\
	   if ((*(short*)((long) i << 11)) != i) break;		\
	}							\
	addr_hi = (short*)((long) i << 11)


/* The following code sets up the watchdog timer to give a bus error
 * after 3 msec.  Unlike the monitor code, the output for the watchdog
 * timer will not toggle, so a Reset pulse will never happen, and the
 * monitor will not skip the diagnostic routines. 
 * I thank John Gilmore who originally wrote this code for the monitor.
 */ 
   
/* Refresh counter: 1/2000th of system clock in MHz gives 2ms or 500KHz */
/* Note that the frequency of our input source, FOUT, is 1/4 the system clock */
#define TFreqRefr (500*CPUMHZ)

/* Refresh Timing: same as watchdog timer; similar to Uart but using FOUT as
   input source (so we can gate it off while we reload).  Also "MODE D".
   Note that FOUT is not selectable as a source, so we route the FOUT pin
   back to the Gate 1 input pin on the board. */
#define TModRefr \
	( (unsigned short)\
	  (TCMNoGa + TCMFall + TCMGate1 + TCMDiSpG + TCMRldLd +\
	   TCMCntRp + TCMBinCt + TCMDwnCt + TCMTCTog)    )

/* Mode D, as usual, but with a pulse at TC instead of toggle. */
#define TModWatchDog \
	( (unsigned short)\
	  (TCMNoGa + TCMFall + TCMGate1 + TCMDiSpG + TCMRldLd +\
	   TCMCntRp + TCMBinCt + TCMDwnCt + TCMHiPulse)    )

/* 50% longer than Refresh timer, minus 1% slop */
#define	TFreqWatchDog	 ( ((TFreqRefr*3)/2) - (TFreqRefr/100) )

#define Turn_Dog_On   \
	/* Set up watchdog timer and refresh timer. */			   \
	TCGateOff;		/* Gate off FOUT */			   \
	TCSetModeLoad(TIMRefresh, TModRefr, TFreqRefr); 		   \
	/* Refresh task is ready - load and arm watchdog timer */	   \
	/* Due to peculiar timing glitch, we must gate the watchdog clock  \
	   off while doing the load "loadreg->counter" command.  The deal  \
	   is that the timer can't tick within about 70 ns of when	   \ 
	   we do the write.  Since that clock is a 200ns cycle, it's 	   \
	   kinda frequent that we'd screw up unless we do this.  This is   \
	   thanks to the wonderful folks at AMD.  Thanks fellas...you blew it.\
									   \
	   All this was described by Andy Bechtolshiem and implemented     \
	   by John Gilmore. */						   \
	/* TCSetModeLoad(TIMWatchDog, TModWatchDog, TFreqWatchDog); */	   \
	TCSetModeLoad(TIMWatchDog,(TModWatchDog^TCMCntRp),TFreqWatchDog);  \
	/* Load and arm both counters. Counter 1 is Watchdog. 3 is Refr. */\
	TCLdArCnt( (TSCount1 + TSCount3) );  			  	   \
	TCGateOn		/* Gate on FOUT */


/* Reset Watch Dog Timer */
#define Reset_Dog	\
	TCClrOut(TIMRefresh);		/* reset refresh timer */	   \
	TCGateOff;		/* Gate off clock signal for watchdog */   \
	TCLdCnt( (TSCount1 + TSCount3) );  	/* Retrigger it */	   \
	TCGateOn		/* Gate ON clock signal for watchdog */


#define TimerOff 0x0B00
#define Dog_Off  \
	/* Turn off the watchdog timer. It has served its purpose. */	\
	TCGateOff;							\
	TCSetMode(TIMWatchDog,TimerOff); /* Clear mode reg */		\
	TCSetMode(TIMRefresh,TimerOff);					\
	TCClrOut(TIMRefresh);		/* Clear output. No more ints */\
	TCClrOut(TIMWatchDog)		/* Ditto */


#define MB_low_addr ((short*)0x100000)	/* Low address on multibus */
#define MB_hi_addr ((short*)0x1F0000)	/* High mem addr on multibus */
#define MB_1CHUNK 0x200  /* 1k bytes */ /* Test in 1K increments. There must
					   be a min of 2k between MB RAM and
					   MB devices. Also by convention, MB
					   RAM is at a lower address than all
					   MB devices. */ 
#define MB_CHUNK 0x2000			/* Test in 8K word increments */



#define BUSERR   ((int*)0x08)
#define IRQ7Vect ((int*)0x7C)
/* Size High End of Multibus Memory */
#define SZ_MBHI(addr_hi)	\
	{int HiTIMo(),HiInt();}						\
	*BUSERR = ((int)HiTIMo); 	/* Set bus error vector */	\
	*IRQ7Vect = ((int)HiInt);	/* Set Level 7 interrupt */     \
	addr_hi = MB_low_addr;						\
	Turn_Dog_On;			/* Turn on WatchDog */		\
	while (addr_hi < MB_hi_addr) { 					\
	   *addr_hi = 0xA157;		/* Wait for timeout */		\
	   if (*addr_hi != 0xA157) break; /* Graphics bd will return */ \
	   addr_hi += MB_CHUNK; 	/* Memory exists at old addr */	\
	} 								\
	goto HI_TMOUT_jmp;		/* Don't go into I/O space */	\
									\
	label(HiInt);			/* Code to handle int7 immed-   \
					   iately after bus error. */   \
	asm("	rte");			/* Just return */		\
									\
	label(HiTIMo);			/* Handle Bus Error */		\
	asm("	addl	#12,sp");	/* Remove all junk from stack   \
					   "RTE" not needed. */		\
	HI_TMOUT_jmp:			/* Jump over label */  		\
	   Dog_Off			/* Turn off WatchDog */



#define SZ_MBMEM(i,addr_hi)	\
	Init_MBPmap(i,addr_hi);		/* Init Page Map for MB mem */  \
	SZ_MBHI(addr_hi)		/* Find Hi end of MB mem */


/* Set up watchdog timer in case there are any Multibus Memory Boards that
   will time out on a parity error. */
#define WATCH_TMOUT	\
	{int TIMout(),Int7();}						\
	*BUSERR = ((int)TIMout); 	/* Set bus error vector */	\
	*IRQ7Vect = ((int)Int7);	/* Set Level 7 interrupt */     \
	Turn_Dog_On;			/* Turn on WatchDog */		\
	goto Cont_TMout;		/* Don't go into I/O space */	\
									\
	UnLab88:			/* Avoid compiler warning */	\
	label(Int7);			/* Code to handle int7 */	\
	Reset_Dog;			/* Reset Watchdog timer */	\
	asm("	rte");			/* Just return */		\
									\
	label(TIMout);			/* Handle Bus Error */		\
	asm("	addl	#12,sp");	/* Remove all junk from stack   \
					   "RTE" not needed. */		\
	Dog_Off;			/* Turn off watchdog */		\
        goto mbmem_err;			/* Diagnostic error */		\
Cont_TMout:				/* Jump over label */  		\


#define OFF_WATCH	\
	Dog_Off				/* Turn off watchdog */


/* Define a macro to jump from prom2 back to prom1 */
/* NOTE that this depends on refresh not running (no NMI's or other
   interrupts possible) */
#define Goto_Mon \
	asm("	movl	DiagRet,sp");\
	asm("	jmp	sp@");
/* was previously...
	(*RomVecPtr->v_diagret)();   */
/* was previously...
	asm("	jmp	0x200008");  */


