/*	reg.h	4.7	83/04/02	*/

/*
 * Location of the users' stored
 * registers relative to R0.
 * Usage is u.u_ar0[XX].
 */
#define	R0	(0)
#define	R1	(1)
#define	R2	(2)
#define	R3	(3)
#define	R4	(4)
#define	R5	(5)
#define	R6	(6)
#define	R7	(7)
#define	AR0	(8)
#define	AR1	(9)
#define	AR2	(10)
#define	AR3	(11)
#define	AR4	(12)
#define	AR5	(13)
#define	AR6	(14)
#define	AR7	(15)
#define	SP	(15)
#define	PS	(16)
#define	PC	(17)

/*
 * And now for something completely the same...
 *
 * NOTE: function code, access address, and instruction register
 * are valid only for bus and address error traps.
 */
#ifndef LOCORE
#define	u_short	unsigned short	/* XXX */
#define	u_int	unsigned int	/* XXX */
struct regs {	
	int	r_dreg[8];	/* data registers */
#define r_r0	r_dreg[0]	/* r0 for portability */
	int	r_areg[8];	/* address registers */
#define r_sp	r_areg[7]	/* user stack pointer */
	u_short	r_context;	/* context */
	u_short	r_sr;		/* status register */
	int	r_pc;		/* program counter */
	u_int	r_stkfmt : 4;	/* stack format */
	u_int		 : 2;
	u_int	r_vector : 10;	/* vector offset */
	u_int	r_rerun  : 1;	/* rerun bus cycle */
	u_int		 : 1;
	u_int	r_ifetch : 1;	/* inst fetch (1=true) */
	u_int	r_dfetch : 1;	/* data fetch */
	u_int	r_rmw	 : 1;	/* read/modify/write */
	u_int	r_hibyte : 1;	/* high byte transfer */
	u_int	r_bytex  : 1;	/* byte transfer */
	u_int	r_rw	 : 1;	/* read=1,write=0 */
	u_int		 : 4;
	u_int	r_fcode	 : 4;	/* function code */
	int	r_accaddr;	/* access address */
	u_int		 : 16;	/* undefined */
	short	r_dob;		/* data output buffer */
	u_int		 : 16;	/* undefined */
	short	r_dib;		/* data input buffer */
	u_int		 : 16;	/* undefined */
	short	r_irc;		/* inst buffer */
	short	r_maskpc;	/* chip mask # & micropc */
	short	r_undef[15];	/* undefined */
};
#undef u_short
#undef u_int
#endif
