/*	%M%	%I%	%E%	*/

/*	Copyright Sun Microsystems 1983.  All rights reserved */

/*
 * 	Overview:	Defines the interface to the geometric object
 *			called a Rect which is a rectangle.
 */

/*			Includes		*/

#ifdef KERNEL
#include "../sundev/basics.h"
#else
#include <sundev/basics.h>
#endif

/*			Rect Types		*/

typedef	struct	{
	  coord	left, top;
	  short	width, height; }
	 Rect ;

extern	Rect	nullRect;

/*			Rect Geometry macros				*/

#define	rectRight(rect)  ((rect)->left+(rect)->width-1)

#define	rectBottom(rect) ((rect)->top+(rect)->height-1)

#define printRect(rect)	printf("[left: %d, top: %d, width: %d, height: %d]", \
	(rect)->left, (rect)->top, (rect)->width, (rect)->height)

#define adjustRectByMargin(r,m)	{(r)->left-=m;(r)->top-=m; \
				 (r)->width+=m+m;(r)->height+=m+m;}

#define constructRect(r,x,y,w,h) {(r)->left=x;(r)->top=y; \
				  (r)->width=w;(r)->height=h;}

#define copyRect(r1,r2)	 {(r2)->left=(r1)->left;(r2)->top=(r1)->top; \
			  (r2)->width=(r1)->width;(r2)->height=(r1)->height;}

/*			Predicates					*/

#define bvEqualRects(r1,r2)	((r1)->left==(r2)->left && \
				 (r1)->width==(r2)->width && \
				 (r1)->top==(r2)->top && \
				 (r1)->height==(r2)->height)

#define bvNullRect(r)			((r)->width == 0 || (r)->height == 0)

#define bvRectIncludesPoint(r,x,y)	( x >= (r)->left && y >= (r)->top && \
					  x<(r)->left+(r)->width && \
					  y<(r)->top+(r)->height )

#define bvRectIncludesRect(r1, r2) ((r1)->left <= (r2)->left && \
				    (r1)->top <= (r2)->top && \
				    (r1)->left+(r1)->width >= \
					(r2)->left+(r2)->width && \
				    (r1)->top+(r1)->height >= \
					(r2)->top+(r2)->height )

#define bvRectsIntersect(r1,r2)		((r1)->left<(r2)->left+(r2)->width && \
					 (r1)->top<(r2)->top+(r2)->height &&  \
					 (r2)->left<(r1)->left+(r1)->width && \
					 (r2)->top<(r1)->top+(r1)->height )

bool  bvVectorIntersectsRect(); /* (Rect *r; vertex *v1, *v2)
				 * returns TRUE if modified v1 & v2 are
				 * visible and thus should be displayed.
				 * clips vector described by vertices v1, v2
				 * to r, using Cohen-Sutherland algorithm
				 */

/*			Rect geometry manipulations		*/

Rect  boundingRect();		/*(Rect *r1, *r2) bounding Rect returned  */

      rectIntersection();	/* (Rect *r1, *r2, *r)
				 *  Modifies r to be intersection of r1 & r2 
				 */

/*			Embedded Rect Transformations	*/

      rectChildToParent();	/* (coord xChildInParent, yChildInParent;
				 *  Rect *rectWrtChild)
				 * Modifies Rect so is x, y relative to
				 * parent instead of self 
				 */
      rectParentToChild();	/* (coord xChildInParent, yChildInParent;
				 *  Rect *rectWrtParent)
				 * Modifies Rect so is x, y relative to
				 * self instead of parent 
				 */
